/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.business.api.query.DEdgeQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.business.internal.query.StyleConfigurationQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeBeginNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEndNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public final class DiagramNameEditPartOperation {
    private DiagramNameEditPartOperation() {
    }

    public static void refreshFont(IDiagramNameEditPart self) {
        EObject eObj = self.resolveSemanticElement();
        IFigure figure = self.getFigure();
        if (eObj instanceof DStylizable) {
            Style style = null;
            if (self instanceof DEdgeBeginNameEditPart && eObj instanceof DEdge) {
                Option beginLabelStyle = new DEdgeQuery((DEdge)eObj).getBeginLabelStyle();
                if (beginLabelStyle.some()) {
                    DiagramNameEditPartOperation.refreshFont(self, figure, (BasicLabelStyle)beginLabelStyle.get());
                } else {
                    figure.setVisible(false);
                }
            } else if (self instanceof DEdgeEndNameEditPart && eObj instanceof DEdge) {
                Option endLabelStyle = new DEdgeQuery((DEdge)eObj).getEndLabelStyle();
                if (endLabelStyle.some()) {
                    DiagramNameEditPartOperation.refreshFont(self, figure, (BasicLabelStyle)endLabelStyle.get());
                } else {
                    figure.setVisible(false);
                }
            } else if (self instanceof DEdgeNameEditPart && eObj instanceof DEdge) {
                Option centerLabelStyle = new DEdgeQuery((DEdge)eObj).getCenterLabelStyle();
                if (centerLabelStyle.some()) {
                    DiagramNameEditPartOperation.refreshFont(self, figure, (BasicLabelStyle)centerLabelStyle.get());
                } else {
                    figure.setVisible(false);
                }
            } else {
                style = ((DStylizable)eObj).getStyle();
                if (style instanceof BasicLabelStyle) {
                    DiagramNameEditPartOperation.refreshFont(self, figure, (BasicLabelStyle)style);
                }
            }
        }
    }

    private static void refreshFont(IDiagramNameEditPart self, IFigure figure, BasicLabelStyle style) {
        BasicLabelStyle lStyle = style;
        figure.setFont(VisualBindingManager.getDefault().getFontFromLabelStyle(lStyle, DiagramNameEditPartOperation.getFontName(self)));
        FontStyle fontStyle = DiagramNameEditPartOperation.getFontStyle(self);
        if (fontStyle != null && figure instanceof SiriusWrapLabel) {
            SiriusWrapLabel wrap = (SiriusWrapLabel)figure;
            wrap.setTextUnderline(VisualBindingManager.getDefault().isUnderlineFromLabelStyle(lStyle));
            wrap.setTextStrikeThrough(VisualBindingManager.getDefault().isStrikeThroughFromLabelStyle(lStyle));
        }
        RGBValues labelRGBColor = lStyle.getLabelColor();
        Color labelColor = VisualBindingManager.getDefault().getLabelColorFromRGBValues(labelRGBColor);
        if (figure.getForegroundColor() == null || !figure.getForegroundColor().equals((Object)labelColor)) {
            figure.setForegroundColor(labelColor);
        }
        if (self instanceof IBorderItemEditPart) {
            IBorderItemEditPart borderItemEditPart = (IBorderItemEditPart)self;
            IBorderItemLocator borderItemLocator = borderItemEditPart.getBorderItemLocator();
            borderItemLocator.setConstraint(figure.getBounds());
        }
    }

    private static String getFontName(IDiagramNameEditPart self) {
        FontStyle fontStyle = DiagramNameEditPartOperation.getFontStyle(self);
        if (fontStyle != null) {
            return fontStyle.getFontName();
        }
        return null;
    }

    private static FontStyle getFontStyle(IDiagramNameEditPart self) {
        FontStyle fontStyle = (FontStyle)self.getNotationView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (fontStyle == null && self.getParent() instanceof IDiagramElementEditPart) {
            IDiagramElementEditPart parent = (IDiagramElementEditPart)self.getParent();
            fontStyle = (FontStyle)parent.getNotationView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        }
        return fontStyle;
    }

    public static Image getLabelIcon(IDiagramNameEditPart self) {
        EObject element = self.resolveSemanticElement();
        if (element instanceof DDiagramElement && element instanceof DStylizable) {
            DiagramElementMapping mapping = ((DDiagramElement)element).getDiagramElementMapping();
            Style style = ((DStylizable)element).getStyle();
            StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(mapping, style);
            Image image = new StyleConfigurationQuery(styleConfiguration).getLabelIcon((DDiagramElement)element, self);
            return image;
        }
        return null;
    }
}

