/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.paramArchConfigurator.ui.dialog;

import eu.fbk.tools.editor.contract.expression.validation.ProposalProvider;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class ConfigParameter {
    static String[] boolValues = new String[]{"true", "false"};
    private String fullName;
    private ProposalProvider.VariableType type;
    private String[] permittedValues;
    private String value;
    private VerifyListener verifyListener;

    public ConfigParameter(String fullName, ProposalProvider.VariableType type) {
        this.fullName = fullName;
        this.type = type;
        if (type == ProposalProvider.VariableType.BOOLEAN) {
            this.permittedValues = boolValues;
        } else if (type == ProposalProvider.VariableType.INTEGER) {
            this.verifyListener = new IntegerVerifyListener();
        } else if (type == ProposalProvider.VariableType.REAL) {
            this.verifyListener = new RealVerifyListener();
        }
    }

    public ConfigParameter(String fullName, ProposalProvider.VariableType type, String[] permittedValues) {
        this(fullName, type);
        this.permittedValues = permittedValues;
    }

    public String getFullName() {
        return this.fullName;
    }

    public ProposalProvider.VariableType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String[] getPermittedValues() {
        return this.permittedValues;
    }

    public VerifyListener getVerifyListener() {
        return this.verifyListener;
    }

    class IntegerVerifyListener
    implements VerifyListener {
        IntegerVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            if (e.text.isEmpty()) {
                e.doit = true;
            } else if (e.keyCode == 0x1000003 || e.keyCode == 0x1000004 || e.keyCode == 8 || e.keyCode == 127 || e.keyCode == 262144 || e.keyCode == 131072) {
                e.doit = true;
            } else {
                boolean allow = false;
                int i = 0;
                while (i < e.text.length()) {
                    char c = e.text.charAt(i);
                    allow = Character.isDigit(c);
                    if (!allow) break;
                    ++i;
                }
                e.doit = allow;
            }
        }
    }

    class RealVerifyListener
    implements VerifyListener {
        RealVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            if (e.text.isEmpty()) {
                e.doit = true;
            } else if (e.keyCode == 0x1000003 || e.keyCode == 0x1000004 || e.keyCode == 8 || e.keyCode == 127 || e.keyCode == 262144 || e.keyCode == 131072) {
                e.doit = true;
            } else {
                boolean allow = false;
                int i = 0;
                while (i < e.text.length()) {
                    char c = e.text.charAt(i);
                    boolean bl = allow = Character.isDigit(c) || c == '.' && e.start != 0 && this.dotIsAllowed(((Text)e.getSource()).getText());
                    if (!allow) break;
                    ++i;
                }
                e.doit = allow;
            }
        }

        private boolean dotIsAllowed(String text) {
            return text.length() > 1 && !text.contains(".");
        }
    }
}

