/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.oclinecore.ui.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.internal.delegate.DelegateInstaller;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.resource.OCLASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.xtext.base.ui.model.BaseCSorASDocumentProvider;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.oclinecore.ui.OCLinEcoreUiPluginHelper;
import org.eclipse.ocl.xtext.oclinecore.ui.model.OCLinEcoreDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.uml2.uml.Package;
import org.eclipse.xtext.parsetree.reconstr.XtextSerializationException;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;

public class OCLinEcoreDocumentProvider
extends BaseCSorASDocumentProvider {
    private static final Logger log = Logger.getLogger(OCLinEcoreDocumentProvider.class);
    public static final String PERSIST_AS_ECORE = "as-ecore";
    public static final String PERSIST_IN_ECORE = "in-ecore";
    public static final String PERSIST_AS_OCLINECORE = "oclinecore";
    public static final String PERSIST_AS_UML = "uml";

    protected @NonNull String createTestDocument(@NonNull URI uri, @NonNull String lastSegment) {
        return "package " + lastSegment + " : pfx = '" + uri + "' {\n" + "}\n";
    }

    private void diagnoseErrors(Resource resource) throws CoreException {
        EList errors = resource.getErrors();
        if (errors.size() > 0) {
            String formattedMessage = PivotUtil.formatResourceDiagnostics((List)errors, (String)"Failed to load", (String)"\n");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.xtext.oclinecore.ui", formattedMessage));
        }
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        String saveAs = (String)this.saveAsMap.get(document);
        if (element instanceof IFileEditorInput && document instanceof OCLinEcoreDocument && !PERSIST_AS_OCLINECORE.equals(saveAs)) {
            StringWriter xmlWriter = new StringWriter();
            try {
                ASResource asResource = ((OCLinEcoreDocument)document).getASResource();
                URI savedURI = asResource != null ? asResource.getURI() : null;
                try {
                    URI uri = EditUIUtil.getURI((IEditorInput)((IFileEditorInput)element));
                    if (asResource != null) {
                        EcoreUtil.resolveAll((Resource)asResource);
                        asResource.setURI(uri);
                    }
                    if (uri == null) {
                        log.warn((Object)"No URI");
                    } else if (PERSIST_AS_ECORE.equals(saveAs)) {
                        ((OCLinEcoreDocument)document).saveAsEcore(xmlWriter, uri, (String)this.exportDelegateURIMap.get(document));
                    } else if (PERSIST_IN_ECORE.equals(saveAs)) {
                        ((OCLinEcoreDocument)document).saveInEcore(xmlWriter, uri, (String)this.exportDelegateURIMap.get(document));
                    } else if ("pivot".equals(saveAs)) {
                        ((OCLinEcoreDocument)document).saveAsPivot(xmlWriter);
                    } else if (PERSIST_AS_UML.equals(saveAs)) {
                        ((OCLinEcoreDocument)document).saveAsUML(xmlWriter, uri);
                    } else {
                        log.warn((Object)("Unknown saveAs '" + saveAs + "'"));
                    }
                }
                finally {
                    if (asResource != null && savedURI != null) {
                        asResource.setURI(savedURI);
                    }
                }
                Document saveDocument = new Document();
                saveDocument.set(xmlWriter.toString());
                super.doSaveDocument(monitor, element, (IDocument)saveDocument, overwrite);
                this.loadedAsMap.put(document, saveAs);
            }
            catch (Exception e) {
                OCLinEcoreUiPluginHelper helper = OCLinEcoreUiPluginHelper.INSTANCE;
                String title = helper.getString("_UI_SaveFailure_title", true);
                String message = helper.getString("_UI_SaveFailure_message", true);
                ErrorDialog.openError(null, (String)title, (String)message, (IStatus)helper.createErrorStatus(e));
                monitor.setCanceled(true);
            }
        } else {
            super.doSaveDocument(monitor, element, document, overwrite);
        }
    }

    protected String getCScontentType() {
        return "org.eclipse.ocl.xtext.oclinecore";
    }

    protected @NonNull String getFileExtension() {
        return PERSIST_AS_OCLINECORE;
    }

    protected void setDocumentContent(IDocument document, InputStream inputStream, String encoding) throws CoreException {
        boolean reload = false;
        try {
            if (!inputStream.markSupported()) {
                inputStream = OCLinEcoreDocumentProvider.createResettableInputStream((InputStream)inputStream);
            }
            boolean isXML = this.isXML(inputStream, encoding);
            String persistAs = PERSIST_AS_OCLINECORE;
            if (isXML) {
                URI uri;
                XMLResource xmiResource;
                ResourceSet esResourceSet = this.getEnvironmentFactory().getResourceSet();
                StandaloneProjectMap projectMap = StandaloneProjectMap.getAdapter((ResourceSet)esResourceSet);
                ProjectManager.IConflictHandler conflictHandler = StandaloneProjectMap.MapToFirstConflictHandlerWithLog.INSTANCE;
                projectMap.configure(esResourceSet, StandaloneProjectMap.LoadFirstStrategy.INSTANCE, conflictHandler);
                ProjectManager.IProjectDescriptor pivotPackageDescriptor = projectMap.getProjectDescriptor("org.eclipse.ocl.pivot");
                if (pivotPackageDescriptor != null) {
                    pivotPackageDescriptor.configure(esResourceSet, StandaloneProjectMap.LoadBothStrategy.INSTANCE, conflictHandler);
                }
                if ((xmiResource = (XMLResource)esResourceSet.getResource(uri = (URI)this.uriMap.get(document), false)) == null || xmiResource.getResourceSet() == null) {
                    xmiResource = (XMLResource)esResourceSet.createResource(uri, null);
                } else {
                    xmiResource.unload();
                    reload = true;
                }
                xmiResource.load(inputStream, null);
                EcoreUtil.resolveAll((ResourceSet)esResourceSet);
                ArrayList allErrors = null;
                for (Resource resource : esResourceSet.getResources()) {
                    EList errors = resource.getErrors();
                    if (errors.size() <= 0) continue;
                    if (allErrors == null) {
                        allErrors = new ArrayList();
                    }
                    allErrors.addAll(errors);
                }
                if (allErrors != null) {
                    StringBuilder s = new StringBuilder();
                    for (Resource.Diagnostic diagnostic : allErrors) {
                        s.append("\n");
                        s.append(diagnostic.toString());
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.xtext.base.ui", s.toString()));
                }
                ASResource asResource = null;
                EList contents = xmiResource.getContents();
                if (contents.size() > 0) {
                    Model pivotModel;
                    EObject xmiRoot = (EObject)contents.get(0);
                    if (xmiRoot instanceof EPackage) {
                        Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)xmiResource, (EnvironmentFactoryInternal)this.getEnvironmentFactory());
                        pivotModel = ecore2as.getASModel();
                        asResource = (ASResource)pivotModel.eResource();
                        if (asResource != null) {
                            if (reload) {
                                ecore2as.update((Resource)asResource, (Collection)contents);
                            }
                            this.diagnoseErrors((Resource)asResource);
                        }
                        persistAs = PERSIST_AS_ECORE;
                        this.exportDelegateURIMap.put(document, DelegateInstaller.getDelegateURI((List)contents));
                    } else if (xmiRoot instanceof Model) {
                        asResource = (ASResource)xmiResource;
                        persistAs = "pivot";
                    } else if (xmiRoot instanceof Package) {
                        UML2AS uml2as = UML2AS.getAdapter((Resource)xmiResource, (EnvironmentFactoryInternal)this.getEnvironmentFactory());
                        pivotModel = uml2as.getASModel();
                        asResource = (ASResource)pivotModel.eResource();
                        persistAs = PERSIST_AS_OCLINECORE;
                    }
                }
                if (asResource == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.xtext.base.ui", "Failed to load"));
                }
                ResourceSetImpl csResourceSet = (ResourceSetImpl)this.getOCL().getResourceSet();
                csResourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ocl/2015/Pivot", (Object)PivotPackage.eINSTANCE);
                URI textURI = xmiResource.getURI().appendFileExtension(this.getFileExtension());
                CSResource csResource = (CSResource)csResourceSet.getResource(textURI, false);
                if (csResource == null) {
                    csResource = (CSResource)csResourceSet.createResource(textURI, this.getCScontentType());
                    Map map = csResourceSet.getURIResourceMap();
                    map.put(textURI, csResource);
                    csResource.setURI(xmiResource.getURI());
                }
                csResource.updateFrom(asResource, (EnvironmentFactory)this.getOCL().getEnvironmentFactory());
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    csResource.save((OutputStream)outputStream, null);
                    inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                }
                catch (IConcreteSyntaxValidator.InvalidConcreteSyntaxException e) {
                    this.diagnoseErrors((XtextResource)csResource, (Exception)((Object)e));
                }
                catch (XtextSerializationException e) {
                    this.diagnoseErrors((XtextResource)csResource, (Exception)((Object)e));
                }
                csResource.unload();
                ((BaseCSResource)csResource).dispose();
                csResourceSet.getResources().remove((Object)csResource);
                inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            } else if (inputStream.available() == 0) {
                URI uri = (URI)ClassUtil.nonNullState((Object)((URI)this.uriMap.get(document)));
                Resource.Factory factory = Resource.Factory.Registry.INSTANCE.getFactory(uri);
                if (factory instanceof EcoreResourceFactoryImpl) {
                    persistAs = PERSIST_AS_ECORE;
                } else if (factory instanceof OCLASResourceFactory) {
                    persistAs = "pivot";
                }
                String lastSegment = uri.trimFileExtension().lastSegment();
                if (lastSegment == null) {
                    lastSegment = "Default";
                }
                String testDocument = this.createTestDocument(uri, lastSegment);
                inputStream = new ByteArrayInputStream(testDocument.getBytes());
            }
            this.loadedAsMap.put(document, persistAs);
            this.saveAsMap.put(document, persistAs);
        }
        catch (ParserException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.xtext.oclinecore.ui", "Failed to load", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.xtext.oclinecore.ui", "Failed to load", (Throwable)e));
        }
        this.superSetDocumentContent(document, inputStream, encoding);
    }
}

