/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.nusmv.formatting2;

import com.google.inject.Inject;
import eu.fbk.tools.editor.nusmv.services.NuSMVGrammarAccess;
import eu.fbk.tools.editor.nusmv.smv.AssignBody;
import eu.fbk.tools.editor.nusmv.smv.AssignDeclaration;
import eu.fbk.tools.editor.nusmv.smv.CaseBody;
import eu.fbk.tools.editor.nusmv.smv.CaseExpression;
import eu.fbk.tools.editor.nusmv.smv.DefineBody;
import eu.fbk.tools.editor.nusmv.smv.DefineDeclaration;
import eu.fbk.tools.editor.nusmv.smv.FrozenVariableDeclaration;
import eu.fbk.tools.editor.nusmv.smv.FunBody;
import eu.fbk.tools.editor.nusmv.smv.FunctionDeclaration;
import eu.fbk.tools.editor.nusmv.smv.IVariableDeclaration;
import eu.fbk.tools.editor.nusmv.smv.Model;
import eu.fbk.tools.editor.nusmv.smv.Module;
import eu.fbk.tools.editor.nusmv.smv.ModuleElement;
import eu.fbk.tools.editor.nusmv.smv.ModuleParameter;
import eu.fbk.tools.editor.nusmv.smv.TimeAnnotation;
import eu.fbk.tools.editor.nusmv.smv.VarBody;
import eu.fbk.tools.editor.nusmv.smv.VariableDeclaration;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;

public class NuSMVFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private NuSMVGrammarAccess _nuSMVGrammarAccess;

    protected void _format(Model model, @Extension IFormattableDocument document) {
        document.format((Object)model.getAnnotation());
        EList<Module> _modules = model.getModules();
        for (Module module : _modules) {
            if (model.getAnnotation() != null && model.getAnnotation().getValue() != null) {
                Procedures.Procedure1 _function = it -> it.newLine();
                document.format((Object)((Module)document.surround((EObject)module, _function)));
                continue;
            }
            Procedures.Procedure1 _function_1 = it -> it.newLine();
            document.format((Object)((Module)document.append((EObject)module, _function_1)));
        }
    }

    protected void _format(TimeAnnotation annotation, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.append((EObject)annotation, _function);
    }

    protected void _format(Module module, @Extension IFormattableDocument document) {
        EList<ModuleParameter> _moduleParameters = module.getModuleParameters();
        for (ModuleParameter moduleParameter : _moduleParameters) {
            document.format((Object)moduleParameter);
        }
        EList<ModuleElement> _moduleElements = module.getModuleElements();
        for (ModuleElement moduleElement : _moduleElements) {
            Procedures.Procedure1 _function = it -> it.newLine();
            Procedures.Procedure1 _function_1 = it -> it.indent();
            document.format((Object)((ModuleElement)document.surround((EObject)((ModuleElement)document.surround((EObject)moduleElement, _function)), _function_1)));
        }
    }

    protected void _format(VariableDeclaration v, @Extension IFormattableDocument document) {
        EList<VarBody> varList = v.getVariables();
        for (VarBody vb : varList) {
            Procedures.Procedure1 _function = it -> it.newLine();
            Procedures.Procedure1 _function_1 = it -> it.indent();
            document.format((Object)((VarBody)document.surround((EObject)((VarBody)document.surround((EObject)vb, _function)), _function_1)));
        }
    }

    protected void _format(IVariableDeclaration v, @Extension IFormattableDocument document) {
        EList<VarBody> varList = v.getVariables();
        for (VarBody vb : varList) {
            Procedures.Procedure1 _function = it -> it.newLine();
            Procedures.Procedure1 _function_1 = it -> it.indent();
            document.format((Object)((VarBody)document.surround((EObject)((VarBody)document.surround((EObject)vb, _function)), _function_1)));
        }
    }

    protected void _format(FrozenVariableDeclaration v, @Extension IFormattableDocument document) {
        EList<VarBody> varList = v.getVariables();
        for (VarBody vb : varList) {
            Procedures.Procedure1 _function = it -> it.newLine();
            Procedures.Procedure1 _function_1 = it -> it.indent();
            document.format((Object)((VarBody)document.surround((EObject)((VarBody)document.surround((EObject)vb, _function)), _function_1)));
        }
    }

    protected void _format(DefineDeclaration d, @Extension IFormattableDocument document) {
        EList<DefineBody> dList = d.getBodies();
        for (DefineBody db : dList) {
            Procedures.Procedure1 _function = it -> it.newLine();
            Procedures.Procedure1 _function_1 = it -> it.indent();
            document.format((Object)((DefineBody)document.surround((EObject)((DefineBody)document.surround((EObject)db, _function)), _function_1)));
        }
    }

    protected void _format(FunctionDeclaration f, @Extension IFormattableDocument document) {
        EList<FunBody> varList = f.getVariables();
        for (FunBody fb : varList) {
            Procedures.Procedure1 _function = it -> it.newLine();
            Procedures.Procedure1 _function_1 = it -> it.indent();
            document.format((Object)((FunBody)document.surround((EObject)((FunBody)document.surround((EObject)fb, _function)), _function_1)));
        }
    }

    protected void _format(AssignDeclaration a, @Extension IFormattableDocument document) {
        EList<AssignBody> aList = a.getBodies();
        for (AssignBody ab : aList) {
            Procedures.Procedure1 _function = it -> it.newLine();
            Procedures.Procedure1 _function_1 = it -> it.indent();
            document.format((Object)((AssignBody)document.surround((EObject)((AssignBody)document.surround((EObject)ab, _function)), _function_1)));
        }
    }

    protected void _format(CaseExpression e, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        Procedures.Procedure1 _function_1 = it -> it.indent();
        document.surround((EObject)((CaseExpression)document.prepend((EObject)e, _function)), _function_1);
        EList<CaseBody> eList = e.getBodies();
        for (CaseBody eb : eList) {
            Procedures.Procedure1 _function_2 = it -> it.newLine();
            Procedures.Procedure1 _function_3 = it -> it.indent();
            document.format((Object)((CaseBody)document.surround((EObject)((CaseBody)document.surround((EObject)eb, _function_2)), _function_3)));
        }
    }

    public void format(Object e, IFormattableDocument document) {
        if (e instanceof CaseExpression) {
            this._format((CaseExpression)e, document);
            return;
        }
        if (e instanceof XtextResource) {
            this._format((XtextResource)e, document);
            return;
        }
        if (e instanceof AssignDeclaration) {
            this._format((AssignDeclaration)e, document);
            return;
        }
        if (e instanceof DefineDeclaration) {
            this._format((DefineDeclaration)e, document);
            return;
        }
        if (e instanceof FrozenVariableDeclaration) {
            this._format((FrozenVariableDeclaration)e, document);
            return;
        }
        if (e instanceof FunctionDeclaration) {
            this._format((FunctionDeclaration)e, document);
            return;
        }
        if (e instanceof IVariableDeclaration) {
            this._format((IVariableDeclaration)e, document);
            return;
        }
        if (e instanceof VariableDeclaration) {
            this._format((VariableDeclaration)e, document);
            return;
        }
        if (e instanceof Model) {
            this._format((Model)e, document);
            return;
        }
        if (e instanceof Module) {
            this._format((Module)e, document);
            return;
        }
        if (e instanceof TimeAnnotation) {
            this._format((TimeAnnotation)e, document);
            return;
        }
        if (e instanceof EObject) {
            this._format((EObject)e, document);
            return;
        }
        if (e == null) {
            this._format(null, document);
            return;
        }
        if (e != null) {
            this._format(e, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, document).toString());
    }
}

