/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.dialog.architecture;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.script.GenerateRedundantArchitecture;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class GenerateRedundantArchitectureParametersDialog
extends Dialog {
    private GenerateRedundantArchitecture function;
    private Combo kindCombo;
    private Text codeText;
    private Spinner votersSpinner;
    private Spinner sizeSpinner;
    private Text architectureFileNameText;
    private Text mapFileNameText;
    private Text abstractCmdFileNameText;
    private Text concreteCmdFileNameText;
    private Button asyncCheckBox;
    private Boolean asyncExecution = false;
    private String[] architectureTypes = new String[]{GenerateRedundantArchitecture.RedundantArchitectureType.custom.name(), GenerateRedundantArchitecture.RedundantArchitectureType.linear.name(), GenerateRedundantArchitecture.RedundantArchitectureType.rectangular.name(), GenerateRedundantArchitecture.RedundantArchitectureType.random.name()};
    private boolean goAhead = false;

    public GenerateRedundantArchitectureParametersDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32);
    }

    public GenerateRedundantArchitectureParametersDialog(Shell parentShell, GenerateRedundantArchitecture function, Boolean asyncExecution) {
        this(parentShell);
        this.function = function;
        this.asyncExecution = asyncExecution == null ? false : asyncExecution;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Contract Implementation Parameters");
    }

    protected void okPressed() {
        this.goAhead = false;
        try {
            this.function.setArchitectureType(GenerateRedundantArchitecture.RedundantArchitectureType.valueOf((String)this.kindCombo.getItems()[this.kindCombo.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        if (this.architectureFileNameText.getText().isEmpty()) {
            return;
        }
        if (this.mapFileNameText.getText().isEmpty()) {
            return;
        }
        this.function.setArchitectureFile(FileUtils.stringToURI((String)this.architectureFileNameText.getText()));
        this.function.setMappingFile(FileUtils.stringToURI((String)this.mapFileNameText.getText()));
        this.function.setVoters(this.votersSpinner.getSelection());
        this.function.setArchitectureSize(this.sizeSpinner.getSelection());
        if (!this.codeText.getText().isEmpty()) {
            this.function.setArchitecturalCode(this.codeText.getText());
        }
        if (!this.abstractCmdFileNameText.getText().isEmpty()) {
            this.function.setAbstractCmdFile(FileUtils.stringToURI((String)this.abstractCmdFileNameText.getText()));
        }
        if (!this.concreteCmdFileNameText.getText().isEmpty()) {
            this.function.setConcreteCmdFile(FileUtils.stringToURI((String)this.concreteCmdFileNameText.getText()));
        }
        this.asyncExecution = this.asyncCheckBox.getSelection();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new GridLayout(2, false));
        GridData gd_combo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 400;
        Label lblKind = new Label(container2, 0);
        lblKind.setText("Architecture Kind");
        this.kindCombo = new Combo(container2, 8);
        this.kindCombo.setLayoutData((Object)gd_combo);
        this.setComboValues(this.kindCombo, this.architectureTypes, this.function.getArchitectureType() == null ? "" : this.function.getArchitectureType().name());
        Label lblCode = new Label(container2, 0);
        lblCode.setText("Architecture description ");
        this.codeText = new Text(container2, 2114);
        this.codeText.setLayoutData((Object)new GridData(1808));
        String code = this.function.getArchitecturalCode();
        this.codeText.setText(StringUtils.isBlank((CharSequence)code) ? "" : code);
        GridData gd_text = new GridData(0, 0, true, false, 1, 1);
        gd_text.widthHint = 400;
        gd_text.heightHint = 150;
        this.codeText.setLayoutData((Object)gd_text);
        this.kindCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GenerateRedundantArchitectureParametersDialog.this.enableDisableArchitectureParameters();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblVoters = new Label(container2, 0);
        lblVoters.setText("Num Voters");
        this.votersSpinner = new Spinner(container2, 2048);
        this.votersSpinner.setMinimum(1);
        this.votersSpinner.setMaximum(10);
        this.votersSpinner.setSelection(1);
        this.votersSpinner.setIncrement(1);
        this.votersSpinner.setPageIncrement(5);
        this.votersSpinner.setSelection(this.function.getVoters());
        Label lblArchitectureSize = new Label(container2, 0);
        lblArchitectureSize.setText("Architecture Size");
        this.sizeSpinner = new Spinner(container2, 2048);
        this.sizeSpinner.setMinimum(1);
        this.sizeSpinner.setMaximum(10);
        this.sizeSpinner.setSelection(1);
        this.sizeSpinner.setIncrement(1);
        this.sizeSpinner.setPageIncrement(5);
        this.sizeSpinner.setSelection(this.function.getArchitectureSize());
        this.enableDisableArchitectureParameters();
        Label lblArchitectureFileName = new Label(container2, 0);
        lblArchitectureFileName.setText("Result Architecture File Name *");
        this.architectureFileNameText = new Text(container2, 2052);
        this.architectureFileNameText.setLayoutData((Object)new GridData(768));
        URI architecturalFile = this.function.getArchitectureFile();
        this.architectureFileNameText.setText(architecturalFile == null ? "" : architecturalFile.toString());
        Label lblMapFileName = new Label(container2, 0);
        lblMapFileName.setText("Result Map File Name *");
        this.mapFileNameText = new Text(container2, 2052);
        this.mapFileNameText.setLayoutData((Object)new GridData(768));
        URI mapFile = this.function.getArchitectureFile();
        this.mapFileNameText.setText(mapFile == null ? "" : mapFile.toString());
        Label lblAbstractCmdFileName = new Label(container2, 0);
        lblAbstractCmdFileName.setText("Result Abstract Cmd File Name");
        this.abstractCmdFileNameText = new Text(container2, 2052);
        this.abstractCmdFileNameText.setLayoutData((Object)new GridData(768));
        URI abstractCmdFile = this.function.getAbstractCmdFile();
        this.abstractCmdFileNameText.setText(abstractCmdFile == null ? "" : abstractCmdFile.toString());
        Label lblConcreteCmdFileName = new Label(container2, 0);
        lblConcreteCmdFileName.setText("Result Concrete Cmd File Name");
        this.concreteCmdFileNameText = new Text(container2, 2052);
        this.concreteCmdFileNameText.setLayoutData((Object)new GridData(768));
        URI concreteCmdFile = this.function.getConcreteCmdFile();
        this.concreteCmdFileNameText.setText(abstractCmdFile == null ? "" : concreteCmdFile.toString());
        this.asyncCheckBox = new Button(container, 32);
        this.asyncCheckBox.setText("OSLC Asynchronous Execution");
        this.asyncCheckBox.setSelection(this.asyncExecution.booleanValue());
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(700, 550);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public Boolean getAsyncExecution() {
        return this.asyncExecution;
    }

    private void setComboValues(Combo combo, String[] admittedValues, String currentValue) {
        combo.setItems(admittedValues);
        combo.select(0);
        if (currentValue != null) {
            int i = 0;
            while (i < admittedValues.length) {
                if (admittedValues[i].equals(currentValue)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    private void enableDisableArchitectureParameters() {
        if (this.kindCombo.getText().equals(GenerateRedundantArchitecture.RedundantArchitectureType.custom.name())) {
            this.codeText.setEnabled(true);
            this.votersSpinner.setEnabled(false);
            this.sizeSpinner.setEnabled(false);
        } else {
            this.codeText.setEnabled(false);
            this.votersSpinner.setEnabled(true);
            this.sizeSpinner.setEnabled(true);
        }
    }
}

