/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.satisfiability;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import eu.fbk.tools.Request;
import eu.fbk.tools.adapter.ui.commands.satisfiability.CheckSatisfiabilityCommand;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProofGenerationAndCheckSatisfiabilityCommand
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(ProofGenerationAndCheckSatisfiabilityCommand.class);
    private String resultFile;
    private Shell shell;
    private Cursor waitCursor;
    private Cursor arrowCursor;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        return this.executeNoJob(event);
    }

    private Object executeNoJob(ExecutionEvent event) throws ExecutionException {
        try {
            Request generateVMTModelCommandRequest = this.executeGenerateVMTModelCommand(event);
            if (generateVMTModelCommandRequest.getStatus() != Request.RequestStatus.completed) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.setCursorToWait();
            if (generateVMTModelCommandRequest.getResultStatus() != Request.ResultStatus.available) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            String vmtModelFile = generateVMTModelCommandRequest.getResultFile();
            Request generateIC3IAProofCommandRequest = this.executeGenerateIC3IAProofCommand(event, vmtModelFile);
            if (generateIC3IAProofCommandRequest.getStatus() != Request.RequestStatus.completed) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (generateIC3IAProofCommandRequest.getResultStatus() != Request.ResultStatus.available) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            String smtFile = generateIC3IAProofCommandRequest.getResultFile();
            Request checkSatisfiabilityCommandRequest = this.executeCheckSatisfiabilityCommand(event, smtFile);
            if (checkSatisfiabilityCommandRequest.getStatus() != Request.RequestStatus.completed) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (checkSatisfiabilityCommandRequest.getResultStatus() != Request.ResultStatus.available) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.resultFile = checkSatisfiabilityCommandRequest.getResultFile();
        }
        finally {
            this.setCursorToDefault();
        }
        this.showResult(HandlerUtil.getActiveShell((ExecutionEvent)event), this.resultFile);
        return null;
    }

    private Object executeJob(final ExecutionEvent event) throws ExecutionException {
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                    subMonitor.setTaskName("Generating VMT Model");
                    subMonitor.split(1);
                    Request generateVMTModelCommandRequest = ProofGenerationAndCheckSatisfiabilityCommand.this.executeGenerateVMTModelCommand(event);
                    if (generateVMTModelCommandRequest.getStatus() != Request.RequestStatus.completed) {
                        return Status.CANCEL_STATUS;
                    }
                    if (generateVMTModelCommandRequest.getResultStatus() != Request.ResultStatus.available) {
                        return Status.CANCEL_STATUS;
                    }
                    String vmtModelFile = generateVMTModelCommandRequest.getResultFile();
                    subMonitor.setTaskName("Generating Proof");
                    subMonitor.split(1);
                    Request generateIC3IAProofCommandRequest = ProofGenerationAndCheckSatisfiabilityCommand.this.executeGenerateIC3IAProofCommand(event, vmtModelFile);
                    if (generateIC3IAProofCommandRequest.getStatus() != Request.RequestStatus.completed) {
                        return Status.CANCEL_STATUS;
                    }
                    if (generateIC3IAProofCommandRequest.getResultStatus() != Request.ResultStatus.available) {
                        return Status.CANCEL_STATUS;
                    }
                    String smtFile = generateIC3IAProofCommandRequest.getResultFile();
                    subMonitor.setTaskName("Check Satisfiability");
                    subMonitor.split(1);
                    Request checkSatisfiabilityCommandRequest = ProofGenerationAndCheckSatisfiabilityCommand.this.executeCheckSatisfiabilityCommand(event, smtFile);
                    if (checkSatisfiabilityCommandRequest.getStatus() != Request.RequestStatus.completed) {
                        return Status.CANCEL_STATUS;
                    }
                    if (checkSatisfiabilityCommandRequest.getResultStatus() != Request.ResultStatus.available) {
                        return Status.CANCEL_STATUS;
                    }
                    ProofGenerationAndCheckSatisfiabilityCommand.this.resultFile = checkSatisfiabilityCommandRequest.getResultFile();
                    ProofGenerationAndCheckSatisfiabilityCommand.this.shell.getDisplay().asyncExec(() -> ProofGenerationAndCheckSatisfiabilityCommand.this.showResult(HandlerUtil.getActiveShell((ExecutionEvent)event), ProofGenerationAndCheckSatisfiabilityCommand.this.resultFile));
                    return Status.OK_STATUS;
                }
                catch (Exception exception) {
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.schedule();
        return null;
    }

    private Request executeGenerateVMTModelCommand(ExecutionEvent event) throws ExecutionException {
        Parameterization[] params;
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command generateVMTModelCommand = service.getCommand("eu.fbk.tools.adapter.ui.commands.behaviour.GenerateVMTModelCommand");
        try {
            Parameterization internalExecutionParam = new Parameterization(generateVMTModelCommand.getParameter("internal_execution"), "true");
            params = new Parameterization[]{internalExecutionParam};
        }
        catch (NotDefinedException notDefinedException) {
            throw new RuntimeException("A command parameter is not defined");
        }
        ParameterizedCommand parametrizedCommand = new ParameterizedCommand(generateVMTModelCommand, params);
        return this.executeInternalCommand(event, parametrizedCommand);
    }

    private Request executeGenerateIC3IAProofCommand(ExecutionEvent event, String vmtModelFile) throws ExecutionException {
        Parameterization[] params;
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command generateVMTModelCommand = service.getCommand("eu.fbk.tools.adapter.ui.commands.behaviour.GenerateIC3IAProofCommand");
        try {
            Parameterization internalExecutionParam = new Parameterization(generateVMTModelCommand.getParameter("internal_execution"), "true");
            Parameterization vmtModelFileParam = new Parameterization(generateVMTModelCommand.getParameter("vmt_model"), vmtModelFile);
            params = new Parameterization[]{internalExecutionParam, vmtModelFileParam};
        }
        catch (NotDefinedException notDefinedException) {
            throw new RuntimeException("A command parameter is not defined");
        }
        ParameterizedCommand parametrizedCommand = new ParameterizedCommand(generateVMTModelCommand, params);
        return this.executeInternalCommand(event, parametrizedCommand);
    }

    private Request executeCheckSatisfiabilityCommand(ExecutionEvent event, String smtFile) throws ExecutionException {
        Parameterization[] params;
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command checkSatisfiabilityCommand = service.getCommand("eu.fbk.tools.adapter.ui.commands.satisfiability.CheckSatisfiabilityCommand");
        try {
            Parameterization internalExecutionParam = new Parameterization(checkSatisfiabilityCommand.getParameter("internal_execution"), "true");
            Parameterization smtFileParam = new Parameterization(checkSatisfiabilityCommand.getParameter(CheckSatisfiabilityCommand.ID_PARAMETER_SMT_QUERY), smtFile);
            params = new Parameterization[]{internalExecutionParam, smtFileParam};
        }
        catch (NotDefinedException notDefinedException) {
            throw new RuntimeException("A command parameter is not defined");
        }
        ParameterizedCommand parametrizedCommand = new ParameterizedCommand(checkSatisfiabilityCommand, params);
        return this.executeInternalCommand(event, parametrizedCommand);
    }

    private Request executeInternalCommand(ExecutionEvent event, ParameterizedCommand parametrizedCommand) throws ExecutionException {
        IHandlerService handlerService = (IHandlerService)HandlerUtil.getActiveSite((ExecutionEvent)event).getService(IHandlerService.class);
        try {
            return (Request)handlerService.executeCommand(parametrizedCommand, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Error executing command " + parametrizedCommand.getId());
        }
    }

    private void setCursorToWait() {
        this.shell.setEnabled(false);
        if (this.waitCursor == null) {
            this.waitCursor = new Cursor((Device)this.shell.getDisplay(), 1);
        }
        this.shell.setCursor(this.waitCursor);
    }

    private void setCursorToDefault() {
        if (this.arrowCursor == null) {
            this.arrowCursor = new Cursor((Device)this.shell.getDisplay(), 0);
        }
        this.shell.setCursor(this.arrowCursor);
        this.shell.setEnabled(true);
    }

    private void showResult(Shell activeShell, String resultFileName) {
        try {
            String result = Files.toString((File)new File(this.resultFile), (Charset)Charsets.UTF_8);
            String cleanedResult = result.replaceAll("[ /\n/\t/\r]", "");
            if (cleanedResult.trim().equalsIgnoreCase("unsat")) {
                MessageDialog.openInformation((Shell)activeShell, (String)"Check Satisfiability Result", (String)"Proof generated and succesfully checked.");
            } else if (cleanedResult.trim().equalsIgnoreCase("sat")) {
                MessageDialog.openWarning((Shell)activeShell, (String)"Check Satisfiability Result", (String)"Proof generated and unsuccesfully checked.");
            } else {
                MessageDialog.openError((Shell)activeShell, (String)"Check Satisfiability Result", (String)"Something got wrong.");
            }
        }
        catch (IOException iOException) {}
    }
}

