/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.safety;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ui.commands.AbstractToolCommand;
import eu.fbk.tools.adapter.xsap.ExpandFei;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandFeiCommand
extends AbstractToolCommand {
    private static final Logger logger = LoggerFactory.getLogger(ExpandFeiCommand.class);
    private ExpandFei function;
    protected String behaviourFileName = null;
    protected String feiFileName = null;

    public ExpandFeiCommand() {
        super("FaultExtensionExpander", "Expand Fault Extentions", "tools.fei_expander.executable", "tools.fei_expander.timeout");
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    protected boolean initialize() {
        this.function = new ExpandFei();
        this.behaviourFileName = null;
        this.feiFileName = null;
        return super.initialize();
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.feiFileName = this.getFileNameParameter(event, "fault_extensions", "fei", "Choose the fei file");
        if (StringUtils.isBlank((CharSequence)this.feiFileName)) {
            this.displayError(this.getCommandDescription(), "Fei model has not been specified, can't execute the command.");
            logger.error("Fei model has not been specified, can't execute the command.");
            return false;
        }
        this.function.setFaultExtensions(FileUtils.stringToURI((String)this.feiFileName));
        logger.debug("Set fei model to " + this.feiFileName);
        return true;
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }
}

