/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.architecture;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.script.GenerateRedundantArchitecture;
import eu.fbk.tools.adapter.ui.Activator;
import eu.fbk.tools.adapter.ui.commands.AbstractToolCommand;
import eu.fbk.tools.adapter.ui.dialog.architecture.GenerateRedundantArchitectureParametersDialog;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateRedundantArchitectureCommand
extends AbstractToolCommand {
    private static final Logger logger = LoggerFactory.getLogger(GenerateRedundantArchitectureCommand.class);
    public static final String ID_PARAMETER_KIND = "kind";
    public static final String ID_PARAMETER_NUM_VOTERS = "num_voters";
    public static final String ID_PARAMETER_SIZE = "size";
    public static final String ID_PARAMETER_CODE = "code";
    public static final String ID_PARAMETER_RESULT_OSS_FILE = "result_oss_file";
    public static final String ID_PARAMETER_RESULT_MAP_FILE = "result_map_file";
    public static final String ID_PARAMETER_RESULT_ABSTRACT_CMD_FILE = "result_abstract_cmd_file";
    public static final String ID_PARAMETER_RESULT_CONCRETE_CMD_FILE = "result_concrete_cmd_file";
    private GenerateRedundantArchitecture function;

    public GenerateRedundantArchitectureCommand() {
        super("RedundantArchitectureGenerator", "Generate Redundant Architecture", "python.executable", "tools.redundant_architecture_generator.timeout");
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean initialize() {
        this.function = new GenerateRedundantArchitecture();
        String scriptRootDirName = Activator.getDefault().getPreferenceStore().getString("tools.redundant_architecture_generator.script.rootdir");
        if (StringUtils.isBlank((CharSequence)scriptRootDirName)) {
            this.displayError(this.getCommandDescription(), "Python root script directory not configured, can't execute the command.");
            return false;
        }
        File scriptRootDir = new File(scriptRootDirName);
        if (!scriptRootDir.exists()) {
            this.displayError(this.getCommandDescription(), "Python root script directory not exist, can't execute the command.");
            return false;
        }
        this.function.setRootScriptDir(scriptRootDir);
        String scriptFileName = Activator.getDefault().getPreferenceStore().getString("tools.redundant_architecture_generator.pyscript");
        if (StringUtils.isBlank((CharSequence)scriptFileName)) {
            this.displayError(this.getCommandDescription(), "Python function script not configured, can't execute the command.");
            return false;
        }
        File scriptFile = new File(scriptFileName);
        if (!scriptFile.exists()) {
            this.displayError(this.getCommandDescription(), "Python function script not exist, can't execute the command.");
            return false;
        }
        this.function.setFunctionScript(scriptFile);
        return super.initialize();
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        String concreteCmdFile;
        String abstractCmdFile;
        String mappingFile;
        String architectureFile;
        String architectureSize;
        String voters;
        String architecturalCode;
        if (!super.preprocessEvent(event)) {
            return false;
        }
        String architectureType = event.getParameter(ID_PARAMETER_KIND);
        if (!StringUtils.isBlank((CharSequence)architectureType)) {
            try {
                this.function.setArchitectureType(GenerateRedundantArchitecture.RedundantArchitectureType.valueOf((String)architectureType));
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid value of architecture kind parameter, can't execute the command.");
                logger.error("Invalid architecture type parameter value: " + architectureType);
                return false;
            }
            logger.debug("Set architecture type to " + this.function.getArchitectureType().name());
        }
        if (!StringUtils.isBlank((CharSequence)(architecturalCode = event.getParameter(ID_PARAMETER_CODE)))) {
            this.function.setArchitecturalCode(architecturalCode);
            logger.debug("Set architectural code to " + this.function.getArchitecturalCode());
        }
        if (!StringUtils.isBlank((CharSequence)(voters = event.getParameter(ID_PARAMETER_NUM_VOTERS)))) {
            try {
                this.function.setVoters(Integer.valueOf(voters).intValue());
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid value of voters parameter, can't execute the command.");
                logger.error("Invalid voters parameter value: " + voters);
                return false;
            }
            logger.debug("Set voters to " + this.function.getVoters());
        }
        if (!StringUtils.isBlank((CharSequence)(architectureSize = event.getParameter(ID_PARAMETER_SIZE)))) {
            try {
                this.function.setArchitectureSize(Integer.valueOf(architectureSize).intValue());
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid value of architecture size parameter, can't execute the command.");
                logger.error("Invalid architecture size parameter value: " + architectureSize);
                return false;
            }
            logger.debug("Set architecture size to " + this.function.getArchitectureSize());
        }
        if (!StringUtils.isBlank((CharSequence)(architectureFile = event.getParameter(ID_PARAMETER_RESULT_OSS_FILE)))) {
            this.function.setArchitectureFile(FileUtils.stringToURI((String)architectureFile));
        }
        if (!StringUtils.isBlank((CharSequence)(mappingFile = event.getParameter(ID_PARAMETER_RESULT_MAP_FILE)))) {
            this.function.setMappingFile(FileUtils.stringToURI((String)mappingFile));
        }
        if (!StringUtils.isBlank((CharSequence)(abstractCmdFile = event.getParameter(ID_PARAMETER_RESULT_ABSTRACT_CMD_FILE)))) {
            this.function.setAbstractCmdFile(FileUtils.stringToURI((String)abstractCmdFile));
        }
        if (!StringUtils.isBlank((CharSequence)(concreteCmdFile = event.getParameter(ID_PARAMETER_RESULT_CONCRETE_CMD_FILE)))) {
            this.function.setAbstractCmdFile(FileUtils.stringToURI((String)concreteCmdFile));
        }
        if (this.isDevelopmentModeEnabled()) {
            final GenerateRedundantArchitectureParametersDialog dialog = new GenerateRedundantArchitectureParametersDialog(this.activeShell, this.function, this.asyncExecution);
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (dialog.open() == 1) {
                        return;
                    }
                    if (dialog.goAhead()) {
                        GenerateRedundantArchitectureCommand.this.asyncExecution = dialog.getAsyncExecution();
                    }
                }
            };
            display.syncExec(runnable);
            if (dialog.getReturnCode() == 1) {
                return false;
            }
        }
        if (this.function.getArchitectureFile() == null) {
            this.displayError(this.getCommandDescription(), "Missing value of architecture oss file parameter, can't execute the command.");
            return false;
        }
        if (this.function.getMappingFile() == null) {
            this.displayError(this.getCommandDescription(), "Missing value of map file parameter, can't execute the command.");
            return false;
        }
        return true;
    }
}

