/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.InteractionFragmentHelper;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class ExecutionSpecificationHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        OccurrenceSpecification osFinish;
        OccurrenceSpecification osStart;
        ArrayList<Object> dependentsToDestroy = new ArrayList<Object>();
        ExecutionSpecification es = (ExecutionSpecification)request.getElementToDestroy();
        if (this.shouldDestroyOccurrenceSpecification(es, osStart = es.getStart())) {
            dependentsToDestroy.add(osStart);
        }
        if (this.shouldDestroyOccurrenceSpecification(es, osFinish = es.getFinish())) {
            dependentsToDestroy.add(osFinish);
        }
        HashSet coveredLifelines = new HashSet(es.getCovereds());
        InteractionFragment previousIft = InteractionFragmentHelper.findPreviousFragment((InteractionFragment)osStart, (EObject)es.getOwner());
        while (previousIft != null) {
            if (coveredLifelines.equals(new HashSet(previousIft.getCovereds()))) {
                Message msg;
                if (!(previousIft instanceof MessageOccurrenceSpecification) || (msg = ((MessageOccurrenceSpecification)previousIft).getMessage()) == null || !MessageSort.SYNCH_CALL_LITERAL.equals((Object)msg.getMessageSort())) break;
                dependentsToDestroy.add(previousIft);
                break;
            }
            previousIft = InteractionFragmentHelper.findPreviousFragment((InteractionFragment)previousIft, (EObject)es.getOwner());
        }
        OccurrenceSpecification fragment = osStart;
        while (fragment != null && !fragment.equals(osFinish)) {
            if (fragment instanceof MessageOccurrenceSpecification && coveredLifelines.equals(new HashSet(fragment.getCovereds()))) {
                dependentsToDestroy.add(fragment);
            }
            fragment = InteractionFragmentHelper.findNextFragment((InteractionFragment)fragment, (EObject)es.getOwner());
        }
        if (!dependentsToDestroy.isEmpty()) {
            return request.getDestroyDependentsCommand(dependentsToDestroy);
        }
        return null;
    }

    private boolean shouldDestroyOccurrenceSpecification(ExecutionSpecification es, OccurrenceSpecification os) {
        return os instanceof ExecutionOccurrenceSpecification || os != null && EMFHelper.isOnlyUsage((EObject)os, (EObject)es);
    }
}

