/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.command.ElementImportReorientCommand;
import org.eclipse.papyrus.uml.service.types.helper.DirectedRelationshipEditHelper;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;

public class ElementImportEditHelper
extends DirectedRelationshipEditHelper {
    @Override
    protected EReference getSourceReference() {
        return UMLPackage.eINSTANCE.getElementImport_ImportingNamespace();
    }

    @Override
    protected EReference getTargetReference() {
        return UMLPackage.eINSTANCE.getElementImport_ImportedElement();
    }

    @Override
    protected boolean canCreate(EObject source, EObject target) {
        if (source != null && !(source instanceof Namespace)) {
            return false;
        }
        return target == null || target instanceof PackageableElement;
    }

    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return new ElementImportReorientCommand(req);
    }

    protected ICommand getDestroyReferenceCommand(DestroyReferenceRequest req) {
        ICommand command = super.getDestroyReferenceCommand(req);
        PackageImport elementToEdit = (PackageImport)req.getContainer();
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)elementToEdit.eContainer());
        if (provider == null) {
            return command;
        }
        boolean shouldDestroyPackageImport = false;
        if (this.getSourceReference().equals(req.getContainingFeature()) && elementToEdit.getImportingNamespace() != null) {
            shouldDestroyPackageImport = true;
        }
        if (this.getTargetReference().equals(req.getContainingFeature()) && elementToEdit.getImportedPackage() != null) {
            shouldDestroyPackageImport = true;
        }
        if (shouldDestroyPackageImport) {
            DestroyElementRequest destroyRequest = new DestroyElementRequest((EObject)elementToEdit, false);
            command = provider.getEditCommand((IEditCommandRequest)destroyRequest);
        }
        return command;
    }

    protected ICommand getSetCommand(SetRequest req) {
        IElementEditService provider;
        Object value;
        if ((this.getSourceReference().equals(req.getFeature()) || this.getTargetReference().equals(req.getFeature())) && (value = req.getValue()) == null && (provider = ElementEditServiceUtils.getCommandProvider((Object)req.getElementToEdit())) != null) {
            DestroyElementRequest destroyRequest = new DestroyElementRequest(req.getElementToEdit(), false);
            ICommand destroyCommand = provider.getEditCommand((IEditCommandRequest)destroyRequest);
            return destroyCommand;
        }
        return super.getSetCommand(req);
    }
}

