/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrus.uml.service.types.command.NotContainmentMoveCommand;
import org.eclipse.papyrus.uml.service.types.helper.ActivityNodeHelper;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.uml2.uml.UMLPackage;

public class ActivityHelper
extends ElementEditHelper {
    public ActivityHelper() {
        this.getDefaultContainmentFeatures().put(UMLPackage.eINSTANCE.getActivityGroup(), UMLPackage.eINSTANCE.getActivity_OwnedGroup());
        this.getDefaultContainmentFeatures().put(UMLPackage.eINSTANCE.getActivityNode(), UMLPackage.eINSTANCE.getActivity_OwnedNode());
    }

    protected ICommand getMoveCommand(MoveRequest req) {
        CompositeCommand cc = new CompositeCommand("Move To Activity");
        cc.compose((IUndoableOperation)ActivityNodeHelper.getMoveOutFromPartitionCommand(req));
        cc.compose((IUndoableOperation)ActivityNodeHelper.getMoveOutFromInterruptibleActivityRegionCommand(req));
        cc.compose((IUndoableOperation)new NotContainmentMoveCommand(req));
        return cc.reduce();
    }

    protected ICommand getCreateCommand(CreateElementRequest req) {
        IElementType elementType = req.getElementType();
        CreateElementRequest request = this.isStructuredNode(elementType) ? this.createStructuredNodeRequest(req) : req;
        return super.getCreateCommand(request);
    }

    protected CreateElementRequest createStructuredNodeRequest(CreateElementRequest baseReq) {
        CreateElementRequest req = new CreateElementRequest(baseReq.getEditingDomain(), baseReq.getContainer(), baseReq.getElementType());
        req.addParameters(baseReq.getParameters());
        req.setContainmentFeature(UMLPackage.eINSTANCE.getActivity_StructuredNode());
        return req;
    }

    protected boolean isStructuredNode(IElementType type) {
        return type.getEClass() != null && UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(type.getEClass());
    }
}

