/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.utils.core.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class FileSystemUtil {
    private static final Logger logger = Logger.getLogger(FileSystemUtil.class);
    public static final String UTF8_ENCODING = "UTF-8";
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static String EXTERNAL_FILE_FOLDER_NAME = "EXT_FILES";

    public static void writeFile(File file, String content) throws IOException {
        FileSystemUtil.writeFile(file, content, Charset.defaultCharset().name());
    }

    public static String getFileContent(File file) throws IOException {
        String line;
        String fileContent = "";
        InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(is);
        while ((line = reader.readLine()) != null) {
            fileContent = fileContent.concat(String.valueOf(line) + System.lineSeparator());
        }
        reader.close();
        return fileContent;
    }

    public static void writeFileUTF8(File file, String content) throws IOException {
        FileSystemUtil.writeFile(file, content, UTF8_ENCODING);
    }

    public static void writeFile(File file, String content, String encoding) throws IOException {
        FileSystemUtil.ensureParentDirectoryExists(file);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
            writer.write(content);
        }
        catch (Throwable throwable) {
            FileSystemUtil.close(writer);
            throw throwable;
        }
        FileSystemUtil.close(writer);
    }

    public static void ensureDirectoryExists(File file) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Couldn't create directory: " + file);
        }
    }

    public static void ensureParentDirectoryExists(File file) throws IOException {
        FileSystemUtil.ensureDirectoryExists(file.getCanonicalFile().getParentFile());
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isWindowsOperatingSystem() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static String interpretProcessExitValues(int exitValue) {
        if (!FileSystemUtil.isWindowsOperatingSystem()) {
            switch (exitValue) {
                case 126: {
                    return "Command not found";
                }
                case 139: {
                    return "Segmentation fault";
                }
            }
        }
        return "";
    }

    public static File generateEmptyFile(String fileName, String extension, String workspaceDir) {
        File directory = new File(workspaceDir);
        if (!directory.exists()) {
            logger.debug((Object)("creating directory: " + directory.getName()));
            boolean result = false;
            try {
                directory.mkdirs();
                result = true;
            }
            catch (SecurityException securityException) {}
            if (result) {
                logger.debug((Object)"DIR created");
            }
        }
        return new File(workspaceDir, String.valueOf(fileName) + extension);
    }

    public static File generateEmptyFile(String extension, String workspaceDir) {
        Random randomGenerator = new Random();
        String fileName = Long.toHexString(randomGenerator.nextLong());
        return FileSystemUtil.generateEmptyFile(fileName, extension, workspaceDir);
    }

    public static File createSmvMapFile(String smvMapFileName, String smvMapDirPath, HashMap<String, String> smvPathComponentNameMap) throws IOException {
        String content = "";
        ArrayList<String> keyList = new ArrayList<String>(smvPathComponentNameMap.keySet());
        Collections.sort(keyList);
        for (String key : keyList) {
            String componentName = smvPathComponentNameMap.get(key);
            String filePath = "\"" + key + "\"";
            String line = String.valueOf(componentName) + " " + filePath + System.lineSeparator();
            logger.debug((Object)("line: " + line));
            content = content.concat(line);
        }
        File mapFile = FileSystemUtil.generateEmptyFile(smvMapFileName, ".txt", smvMapDirPath);
        FileSystemUtil.writeFile(mapFile, content);
        return mapFile;
    }

    public static IFile convert(File file, IProject project) throws Exception {
        Path location = new Path(file.getAbsolutePath());
        String linkedFileFolderDir = String.valueOf(project.getLocation().toFile().getPath()) + File.separator + EXTERNAL_FILE_FOLDER_NAME + File.separator;
        File linkedFilefolder = new File(linkedFileFolderDir);
        linkedFilefolder.mkdirs();
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        IFile ifile = project.getFile(String.valueOf(File.separator) + EXTERNAL_FILE_FOLDER_NAME + File.separator + location.lastSegment());
        ifile.createLink((IPath)location, 256, null);
        return ifile;
    }
}

