/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagramsCreator.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.gmfdiag.css.CSSShapeImpl;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.edit.part.CustomStateEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.edit.part.CustomTransitionEditPart;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.diagramsCreator.utils.DiagramUtils;

public class ShowSMDElementsAction {
    private static String SMD_LABEL = "StateMachine Diagram";
    private static final int MIN_WIDTH = 100;
    private static final int MAX_WIDTH = 250;
    private static final int HEIGHT = 50;
    private final EntityUtil entityUtil = EntityUtil.getInstance();
    private final DiagramUtils diagramUtils = DiagramUtils.getInstance();
    private static final Logger logger = Logger.getLogger(ShowSMDElementsAction.class);
    private static ShowSMDElementsAction classInstance;

    public static ShowSMDElementsAction getInstance() {
        if (classInstance == null) {
            classInstance = new ShowSMDElementsAction();
        }
        return classInstance;
    }

    private Set<Diagram> getDiagramsList() {
        Set chessDiagrams = (Set)org.polarsys.chess.core.util.uml.DiagramUtils.getDiagrams();
        return chessDiagrams;
    }

    private Diagram getNewDiagram(Set<Diagram> preList, Set<Diagram> postList) {
        postList.removeAll(preList);
        if (postList.size() == 1) {
            return postList.iterator().next();
        }
        return null;
    }

    public Diagram addSMD(Class owner) {
        ArrayList<ViewPrototype> data = new ArrayList<ViewPrototype>();
        for (ViewPrototype proto : PolicyChecker.getCurrent().getPrototypesFor((EObject)owner)) {
            if (!(proto.getConfiguration() instanceof PapyrusDiagram)) continue;
            data.add(proto);
        }
        ViewPrototype smdViewPrototype = null;
        for (ViewPrototype viewPrototype : data) {
            if (!viewPrototype.getLabel().equals(SMD_LABEL)) continue;
            smdViewPrototype = viewPrototype;
            break;
        }
        Set<Diagram> preList = this.getDiagramsList();
        smdViewPrototype.instantiateOn((EObject)owner, String.valueOf(((Class)owner.getOwner()).getName()) + "_SMD");
        Set<Diagram> postList = this.getDiagramsList();
        Diagram diag = this.getNewDiagram(preList, postList);
        return diag;
    }

    private int[] getSize(State state) {
        int width = 0;
        int maxLength = 0;
        maxLength = state.getName().length();
        width = Math.round(10 * maxLength);
        int[] size = new int[]{width < 100 ? 100 : (width > 250 ? 250 : width), 50};
        return size;
    }

    private void resizeStates(IGraphicalEditPart diagramEP, final EList<State> displayedStates, TransactionalEditingDomain domain) {
        final List<EditPart> childrenEPs = this.diagramUtils.findAllChildren((EditPart)diagramEP);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                for (EditPart childEP : childrenEPs) {
                    View childView;
                    Element semanticElement;
                    if (!(childEP instanceof IGraphicalEditPart) || !((semanticElement = (Element)(childView = ((IGraphicalEditPart)childEP).getNotationView()).getElement()) instanceof State) || displayedStates.contains((Object)semanticElement) || !(childView instanceof CSSShapeImpl)) continue;
                    CSSShapeImpl viewShape = (CSSShapeImpl)childView;
                    Bounds layout = (Bounds)viewShape.getLayoutConstraint();
                    int[] size = ShowSMDElementsAction.this.getSize((State)semanticElement);
                    layout.setWidth(size[0]);
                    layout.setHeight(size[1]);
                }
            }
        });
    }

    public void addComponents(Diagram diagram) {
        final EObject element = diagram.getElement();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagram);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                if (element instanceof StateMachine) {
                    StateMachine stateMachine = (StateMachine)element;
                    EList regions = stateMachine.getRegions();
                    Region region = (Region)regions.get(0);
                    Transition transition = region.createTransition(null);
                    ShowSMDElementsAction.this.entityUtil.createTransitionGuard(transition, null, "MyGuardBody", "cleanC");
                    ShowSMDElementsAction.this.entityUtil.createTransitionEffect(transition, null, "MyEffectBody;", "cleanC");
                    Vertex source = region.createSubvertex("myOriginState", UMLPackage.eINSTANCE.getPseudostate());
                    Vertex target = region.createSubvertex("myTargetState", UMLPackage.eINSTANCE.getState());
                    transition.setSource(source);
                    transition.setTarget(target);
                }
            }
        });
    }

    public void populateDiagram(Diagram diagram) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        DiagramEditPart diagramEP = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorPart activeEditor = ((PapyrusMultiDiagramEditor)editorPart).getActiveEditor();
        logger.debug((Object)("activeEditor = " + activeEditor));
        IGraphicalEditPart selectedElementEP = (IGraphicalEditPart)diagramEP.getChildren().get(0);
        logger.debug((Object)("\n\nselectedElement EditPart = " + selectedElementEP + "\n\n"));
        StateMachine stateMachine = (StateMachine)selectedElementEP.resolveSemanticElement();
        EList stateMachineElements = stateMachine.allOwnedElements();
        List<EditPart> childrenList = this.diagramUtils.findAllChildren((EditPart)diagramEP);
        ArrayList<EObject> statesToDisplay = new ArrayList<EObject>();
        ArrayList<EObject> transitionsToDisplay = new ArrayList<EObject>();
        for (Element element : stateMachineElements) {
            if (element instanceof State || element instanceof Pseudostate || element instanceof FinalState) {
                statesToDisplay.add((EObject)element);
                continue;
            }
            if (!(element instanceof Transition)) continue;
            transitionsToDisplay.add((EObject)element);
        }
        org.eclipse.gef.commands.Command showStatesCmd = this.diagramUtils.showElementsIn(statesToDisplay, (DiagramEditor)activeEditor, (EditPart)diagramEP, childrenList, new Point(100, 100));
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagram);
        domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper(showStatesCmd));
        this.resizeStates((IGraphicalEditPart)diagramEP, (EList<State>)new BasicEList(), domain);
        org.eclipse.gef.commands.Command showTransitionsCmd = this.diagramUtils.showElementsIn(transitionsToDisplay, (DiagramEditor)activeEditor, (EditPart)diagramEP, childrenList, new Point(200, 200));
        domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper(showTransitionsCmd));
    }

    public void refreshDiagram(Diagram diagram) {
        logger.debug((Object)("refreshDiagram " + diagram.getName()));
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        DiagramEditPart diagramEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorPart activeEditor = ((PapyrusMultiDiagramEditor)editorPart).getActiveEditor();
        Map elements = diagramEditPart.getViewer().getEditPartRegistry();
        Object[] editParts = elements.values().toArray();
        BasicEList displayedStates = new BasicEList();
        BasicEList displayedTransitions = new BasicEList();
        int i = 0;
        while (i < editParts.length) {
            if (editParts[i] instanceof CustomStateEditPart) {
                displayedStates.add((Object)((State)((CustomStateEditPart)editParts[i]).resolveSemanticElement()));
            } else if (editParts[i] instanceof CustomTransitionEditPart) {
                displayedTransitions.add((Object)((Transition)((CustomTransitionEditPart)editParts[i]).resolveSemanticElement()));
            }
            ++i;
        }
        IGraphicalEditPart selectedElementEP = (IGraphicalEditPart)diagramEditPart.getChildren().get(0);
        logger.debug((Object)("\n\nselectedElement EditPart = " + selectedElementEP + "\n\n"));
        StateMachine stateMachine = (StateMachine)selectedElementEP.resolveSemanticElement();
        EList stateMachineElements = stateMachine.allOwnedElements();
        BasicEList missingStates = new BasicEList();
        BasicEList missingTransitions = new BasicEList();
        for (Element element : stateMachineElements) {
            if (element instanceof State) {
                if (displayedStates.contains((Object)element)) {
                    logger.debug((Object)("state already present in diagram: " + element));
                    continue;
                }
                logger.debug((Object)("state is not present in diagram: " + element));
                missingStates.add((Object)element);
                continue;
            }
            if (!(element instanceof Transition)) continue;
            if (displayedTransitions.contains((Object)element)) {
                logger.debug((Object)("transition already present in diagram: " + element));
                continue;
            }
            logger.debug((Object)("transition is not present in diagram:  " + element));
            missingTransitions.add((Object)element);
        }
        List<EditPart> childrenList = this.diagramUtils.findAllChildren((EditPart)diagramEditPart);
        CompoundCommand completeCmd = new CompoundCommand("Show Elements Command");
        int index = 0;
        for (Element element : missingStates) {
            logger.debug((Object)("calling showElementIn for element = " + element));
            org.eclipse.gef.commands.Command cmd = this.diagramUtils.showElementIn((EObject)element, (DiagramEditor)activeEditor, (EditPart)diagramEditPart, ++index, childrenList);
            completeCmd.add(cmd);
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagram);
        domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper((org.eclipse.gef.commands.Command)completeCmd));
        this.resizeStates((IGraphicalEditPart)diagramEditPart, (EList<State>)displayedStates, domain);
        completeCmd = new CompoundCommand("Show Transitions Command");
        for (Element element : missingTransitions) {
            logger.debug((Object)("calling showElementIn for element = " + element));
            org.eclipse.gef.commands.Command cmd = this.diagramUtils.showElementIn((EObject)element, (DiagramEditor)activeEditor, (EditPart)diagramEditPart, 1, childrenList);
            completeCmd.add(cmd);
        }
        domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper((org.eclipse.gef.commands.Command)completeCmd));
    }
}

