/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagramsCreator.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.impl.LocationImpl;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.gmfdiag.css.CSSDecorationNodeImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.CSSShapeImpl;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.BlockPropertyCompositeEditPart;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.FlowPortAffixedLabelNameEditPart;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.FlowPortAffixedNodeEditPart;
import org.eclipse.papyrus.sysml.diagram.internalblock.InternalBlockDiagramCreateCommand;
import org.eclipse.papyrus.uml.diagram.common.actions.AbstractShowHideAction;
import org.eclipse.papyrus.uml.diagram.common.actions.ShowHideContentsAction;
import org.eclipse.papyrus.uml.diagram.common.commands.ShowHideElementsRequest;
import org.eclipse.papyrus.uml.diagram.common.edit.part.ConnectorEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.PortAffixedLabelNameEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.PortAffixedNodeEditPart;
import org.eclipse.papyrus.uml.diagram.composite.providers.UMLElementTypes;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.polarsys.chess.contracts.profile.chesscontract.util.ContractEntityUtil;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;

public class ShowIBDElementsAction
extends ShowHideContentsAction {
    private static final int MAIN_WIDTH = 1000;
    private static final int MIN_MAIN_HEIGHT = 600;
    private static final int MAX_MAIN_HEIGHT = 6000;
    private static final int MIN_SUB_WIDTH = 150;
    private static final int MAX_SUB_WIDTH = 1000;
    private static final int MIN_SUB_HEIGHT = 150;
    private static final int MAX_SUB_HEIGHT = 2000;
    private static final int INCREMENT = 40;
    private EditPart host;
    private List<Object> selection;
    private static final Logger logger = Logger.getLogger(ShowIBDElementsAction.class);
    final EntityUtil entityUtil = EntityUtil.getInstance();
    final ContractEntityUtil contractEntityUtil = ContractEntityUtil.getInstance();
    private boolean sortedPorts;
    private static ShowIBDElementsAction classInstance;

    public static ShowIBDElementsAction getInstance() {
        if (classInstance == null) {
            classInstance = new ShowIBDElementsAction();
        }
        return classInstance;
    }

    public Diagram addIBD(Class owner) throws Exception {
        ServicesRegistry servicesRegistry = ServiceUtilsForResource.getInstance().getServiceRegistry(owner.eResource());
        ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)servicesRegistry);
        InternalBlockDiagramCreateCommand command = new InternalBlockDiagramCreateCommand();
        return command.createDiagram(modelSet, (EObject)owner, String.valueOf(owner.getName()) + "_IBD");
    }

    /*
     * WARNING - void declaration
     */
    protected void buildShowHideElementsList(Object[] results) {
        void var3_4;
        this.viewsToCreate = new ArrayList();
        this.viewsToDestroy = new ArrayList();
        ArrayList<AbstractShowHideAction.EditPartRepresentation> result = new ArrayList<AbstractShowHideAction.EditPartRepresentation>();
        boolean bl = false;
        while (var3_4 < results.length) {
            AbstractShowHideAction.EditPartRepresentation editPartRepresentation = (AbstractShowHideAction.EditPartRepresentation)results[var3_4];
            Element semanticElement = (Element)editPartRepresentation.getSemanticElement();
            if (this.entityUtil.isPort(semanticElement) || this.entityUtil.isComponentInstance(semanticElement) || this.entityUtil.isDelegationConstraint(semanticElement)) {
                result.add(editPartRepresentation);
            }
            ++var3_4;
        }
        for (Object e : result) {
            if (this.initialSelection.contains(e) || !(e instanceof AbstractShowHideAction.EditPartRepresentation)) continue;
            this.viewsToCreate.add((AbstractShowHideAction.EditPartRepresentation)e);
        }
    }

    private void contributeToSelection(List<Object> listToComplete, AbstractShowHideAction.EditPartRepresentation representation) {
        listToComplete.addAll(representation.getPossibleElement());
        List children = representation.getPossibleElement();
        if (children != null) {
            for (AbstractShowHideAction.EditPartRepresentation child : children) {
                this.contributeToSelection(listToComplete, child);
            }
        }
    }

    private void buildSelection() {
        this.selection = new ArrayList<Object>();
        for (AbstractShowHideAction.EditPartRepresentation current : this.representations) {
            this.contributeToSelection(this.selection, current);
        }
    }

    protected org.eclipse.gef.commands.Command getActionCommand() {
        CompoundCommand completeCmd = new CompoundCommand("Show/Hide Inherited Elements Command");
        ShowHideElementsRequest request = null;
        Point propertyLocation = new Point(20, 20);
        Point portLocationLeft = new Point(-10, 20);
        Point portLocationRight = new Point(-10, 20);
        Class mainElement = (Class)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        EList ports = mainElement.getOwnedPorts();
        ArrayList<Port> inputPorts = this.getPorts((EList<Port>)ports, true, this.sortedPorts);
        ArrayList<Port> outputPorts = this.getPorts((EList<Port>)ports, false, this.sortedPorts);
        for (AbstractShowHideAction.EditPartRepresentation rep : this.viewsToCreate) {
            Element element;
            if (!(rep instanceof ShowHideContentsAction.OptionalEditPartRepresentation)) continue;
            IGraphicalEditPart editPart = ((ShowHideContentsAction.OptionalEditPartRepresentation)rep).getParentRepresentation().getParentRepresentation().getRepresentedEditPart();
            View compartmentView = ((ShowHideContentsAction.OptionalEditPartRepresentation)rep).getParentRepresentation().getRepresentedEditPart().getNotationView();
            portLocationRight.x = 10000;
            if (compartmentView == null) continue;
            request = new ShowHideElementsRequest(compartmentView, ((ShowHideContentsAction.OptionalEditPartRepresentation)rep).getSemanticElement());
            if (this.isXYLayout(compartmentView, (EditPart)editPart)) {
                propertyLocation.x += 40;
                propertyLocation.y += 40;
                request.setLocation(new Point(propertyLocation));
            } else if (this.isAffixedChildNode((EditPart)editPart, ((ShowHideContentsAction.OptionalEditPartRepresentation)rep).getSemanticElement()) && (element = (Element)((ShowHideContentsAction.OptionalEditPartRepresentation)rep).getSemanticElement()) instanceof Port) {
                if (inputPorts.indexOf(element) != -1) {
                    portLocationLeft.y = 20 + 40 * (inputPorts.indexOf(element) + 1);
                    request.setLocation(new Point(portLocationLeft));
                } else if (outputPorts.indexOf(element) != -1) {
                    portLocationRight.y = 20 + 40 * (outputPorts.indexOf(element) + 1);
                    request.setLocation(new Point(portLocationRight));
                }
            }
            org.eclipse.gef.commands.Command cmd = editPart.getCommand((Request)request);
            if (cmd == null || !cmd.canExecute()) continue;
            completeCmd.add(cmd);
        }
        return completeCmd;
    }

    private ArrayList<Port> getPorts(EList<Port> ports, boolean inputType, boolean sorted) {
        ArrayList<Port> listPorts = new ArrayList<Port>();
        for (Port port : ports) {
            if (inputType) {
                if (!this.entityUtil.isInputPort((Element)port)) continue;
                listPorts.add(port);
                continue;
            }
            if (this.entityUtil.isInputPort((Element)port)) continue;
            listPorts.add(port);
        }
        if (sorted) {
            Comparator<Port> comparator = new Comparator<Port>(){

                @Override
                public int compare(Port left, Port right) {
                    return left.getName().compareToIgnoreCase(right.getName());
                }
            };
            Collections.sort(listPorts, comparator);
        }
        return listPorts;
    }

    private void drawAllComponentInstancesPorts(IGraphicalEditPart elementEP) {
        CompoundCommand command = new CompoundCommand("Draw Component Instances Ports Commands");
        IGraphicalEditPart compartmentEP = (IGraphicalEditPart)elementEP.getChildren().get(1);
        List compartmentChildren = compartmentEP.getChildren();
        for (Object childEP : compartmentChildren) {
            EObject semanticElement = ((IGraphicalEditPart)childEP).resolveSemanticElement();
            if (!(semanticElement instanceof Property)) continue;
            command.add((org.eclipse.gef.commands.Command)this.drawComponentInstancePorts((IGraphicalEditPart)childEP));
        }
        TransactionalEditingDomain domain = elementEP.getEditingDomain();
        domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper((org.eclipse.gef.commands.Command)command));
    }

    private CompoundCommand drawComponentInstancePorts(IGraphicalEditPart componentInstanceEP) {
        CompoundCommand command = new CompoundCommand("Draw Component Instances Ports Commands");
        Point portLocationLeft = null;
        Point portLocationRight = null;
        EObject semanticElement = componentInstanceEP.resolveSemanticElement();
        Class component = (Class)((Property)semanticElement).getType();
        View compartmentView = componentInstanceEP.getNotationView();
        portLocationLeft = new Point(-10, 20);
        portLocationRight = new Point(-10, 20);
        CSSShapeImpl viewShape = (CSSShapeImpl)componentInstanceEP.getNotationView();
        Bounds layout = (Bounds)viewShape.getLayoutConstraint();
        portLocationRight.x += layout.getWidth() + 20;
        EList ports = component.getOwnedPorts();
        ArrayList<Port> inputPorts = this.getPorts((EList<Port>)ports, true, this.sortedPorts);
        ArrayList<Port> outputPorts = this.getPorts((EList<Port>)ports, false, this.sortedPorts);
        for (Port port : ports) {
            if (compartmentView == null) continue;
            ShowHideElementsRequest request = new ShowHideElementsRequest(compartmentView, (EObject)port);
            if (inputPorts.indexOf(port) != -1) {
                portLocationLeft.y = 20 + 40 * (inputPorts.indexOf(port) + 1);
                request.setLocation(new Point(portLocationLeft));
            } else if (outputPorts.indexOf(port) != -1) {
                portLocationRight.y = 20 + 40 * (outputPorts.indexOf(port) + 1);
                request.setLocation(new Point(portLocationRight));
            }
            org.eclipse.gef.commands.Command cmd = componentInstanceEP.getCommand((Request)request);
            if (cmd == null || !cmd.canExecute()) continue;
            command.add(cmd);
        }
        if (command.canExecute()) {
            return command;
        }
        return null;
    }

    private int[] getSize(Element element) {
        EList ports;
        int width = 0;
        int height = 60;
        int[] size = new int[2];
        int inputPorts = 0;
        int outputPorts = 0;
        int maxLengthInput = 0;
        int maxLengthOutput = 0;
        boolean isMain = false;
        if (element instanceof Property) {
            Property property = (Property)element;
            ports = ((Class)property.getType()).getOwnedPorts();
        } else {
            isMain = true;
            ports = ((Class)element).getOwnedPorts();
        }
        for (Port port : ports) {
            int textLength;
            if (this.entityUtil.isInputPort((Element)port)) {
                ++inputPorts;
                textLength = port.getName().length();
                if ((textLength += port.getType() != null ? port.getType().getName().length() : 11) <= maxLengthInput) continue;
                maxLengthInput = textLength;
                continue;
            }
            ++outputPorts;
            textLength = port.getName().length();
            if ((textLength += port.getType() != null ? port.getType().getName().length() : 11) <= maxLengthOutput) continue;
            maxLengthOutput = textLength;
        }
        width = (int)Math.round(100.0 + 7.5 * (double)(maxLengthInput + maxLengthOutput));
        height = inputPorts > outputPorts ? (height += 40 * inputPorts) : (height += 40 * outputPorts);
        if (isMain) {
            size[0] = 1000;
            size[1] = height < 600 ? 600 : (height > 6000 ? 6000 : height);
        } else {
            size[0] = width < 150 ? 150 : (width > 1000 ? 1000 : width);
            size[1] = height < 150 ? 150 : (height > 2000 ? 2000 : height);
        }
        return size;
    }

    private void resizeElements(IGraphicalEditPart diagramEP) {
        IGraphicalEditPart elementEP = (IGraphicalEditPart)diagramEP.getChildren().get(0);
        final View elementView = elementEP.getNotationView();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)elementView);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                if (elementView instanceof CSSShapeImpl) {
                    CSSShapeImpl viewShape = (CSSShapeImpl)elementView;
                    Bounds layout = (Bounds)viewShape.getLayoutConstraint();
                    int[] size = ShowIBDElementsAction.this.getSize((Element)elementView.getElement());
                    layout.setWidth(size[0]);
                    layout.setHeight(size[1]);
                }
                EList compartmentChildren = ((View)elementView.getChildren().get(1)).getChildren();
                EObject semanticElement = null;
                int offset = 100;
                for (Object child : compartmentChildren) {
                    semanticElement = ((View)child).getElement();
                    if (!(semanticElement instanceof Property) || !(child instanceof CSSShapeImpl)) continue;
                    CSSShapeImpl viewShape = (CSSShapeImpl)child;
                    Bounds layout = NotationFactory.eINSTANCE.createBounds();
                    int[] size = ShowIBDElementsAction.this.getSize((Element)((Property)semanticElement));
                    layout.setWidth(size[0]);
                    layout.setHeight(size[1]);
                    layout.setX(offset);
                    layout.setY(200);
                    offset += 250;
                    viewShape.setLayoutConstraint((LayoutConstraint)layout);
                }
            }
        });
    }

    private void resizeMissingComponentInstances(IGraphicalEditPart mainElementEP, final EList<Property> missingComponentInstances) {
        final View elementView = mainElementEP.getNotationView();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)elementView);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                EList compartmentChildren = ((View)elementView.getChildren().get(1)).getChildren();
                EObject semanticElement = null;
                int offset = 40;
                for (Object child : compartmentChildren) {
                    semanticElement = ((View)child).getElement();
                    if (!(semanticElement instanceof Property) || !missingComponentInstances.contains((Object)semanticElement) || !(child instanceof CSSShapeImpl)) continue;
                    CSSShapeImpl viewShape = (CSSShapeImpl)child;
                    Bounds layout = NotationFactory.eINSTANCE.createBounds();
                    int[] size = ShowIBDElementsAction.this.getSize((Element)((Property)semanticElement));
                    layout.setWidth(size[0]);
                    layout.setHeight(size[1]);
                    layout.setX(40);
                    layout.setY(offset);
                    offset += 40;
                    viewShape.setLayoutConstraint((LayoutConstraint)layout);
                }
            }
        });
    }

    public EditPart getHost() {
        return this.host;
    }

    private EditPart getEditPartFromView(View view) {
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private EditPart getPortEditPart(Port role, Property property, View elementView) {
        logger.debug((Object)("\n\nLooking for port " + role.getQualifiedName()));
        if (property != null) {
            logger.debug((Object)("Containing property: " + property.getQualifiedName()));
            View compartmentView = (View)elementView.getChildren().get(1);
            for (Object child : compartmentView.getChildren()) {
                Property propertyImpl;
                CSSShapeImpl shape;
                if (!(child instanceof CSSShapeImpl) || !((shape = (CSSShapeImpl)child).getElement() instanceof Property) || (propertyImpl = (Property)shape.getElement()) == null || !property.getQualifiedName().equals(propertyImpl.getQualifiedName())) continue;
                EList shapeChildren = shape.getChildren();
                for (Object childView : shapeChildren) {
                    IGraphicalEditPart ep = (IGraphicalEditPart)this.getEditPartFromView((View)childView);
                    if (!(ep instanceof FlowPortAffixedNodeEditPart) && !(ep instanceof PortAffixedNodeEditPart) || role != ep.resolveSemanticElement()) continue;
                    logger.debug((Object)("\nPort found in part, view = " + ep));
                    return ep;
                }
            }
        } else {
            EList elementChildren = elementView.getChildren();
            for (Object childView : elementChildren) {
                IGraphicalEditPart ep = (IGraphicalEditPart)this.getEditPartFromView((View)childView);
                if (!(ep instanceof FlowPortAffixedNodeEditPart) && !(ep instanceof PortAffixedNodeEditPart) || role != ep.resolveSemanticElement()) continue;
                logger.debug((Object)("\nPort found in main elemement, view = " + ep));
                return ep;
            }
        }
        return null;
    }

    private org.eclipse.gef.commands.Command getShowLinkCommand(EditPart sourceEP, EditPart targetEP, Connector connector) {
        String semanticHint = "link_uml_connector";
        EObjectAdapter mySemanticAdapter = new EObjectAdapter((EObject)connector){

            public Object getAdapter(java.lang.Class adapter) {
                if (IElementType.class.equals((Object)adapter)) {
                    return UMLElementTypes.Connector_Edge;
                }
                return super.getAdapter(adapter);
            }
        };
        CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)mySemanticAdapter, semanticHint, -1, false, ((GraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
        CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(viewDescriptor);
        ccr.setType((Object)"connection start");
        ccr.setSourceEditPart(sourceEP);
        sourceEP.getCommand((Request)ccr);
        ccr.setTargetEditPart(targetEP);
        ccr.setType((Object)"connection end");
        return targetEP.getCommand((Request)ccr);
    }

    public void drawConnectors(IGraphicalEditPart elementEP, EList<Connector> connectors) {
        View elementView = elementEP.getNotationView();
        CompoundCommand compoundCommand = new CompoundCommand("Restore A Related Link");
        for (Connector connector : connectors) {
            org.eclipse.gef.commands.Command cmd;
            ConnectorEnd targetEnd;
            EditPart sourceEP = null;
            EditPart targetEP = null;
            ConnectorEnd sourceEnd = (ConnectorEnd)connector.getEnds().get(0);
            if (sourceEnd != null) {
                sourceEP = this.getPortEditPart((Port)sourceEnd.getRole(), sourceEnd.getPartWithPort(), elementView);
            }
            if ((targetEnd = (ConnectorEnd)connector.getEnds().get(1)) != null) {
                targetEP = this.getPortEditPart((Port)targetEnd.getRole(), targetEnd.getPartWithPort(), elementView);
            }
            if (sourceEP == null || targetEP == null || (cmd = this.getShowLinkCommand(sourceEP, targetEP, connector)) == null || !cmd.canExecute()) continue;
            compoundCommand.add(cmd);
        }
        TransactionalEditingDomain domain = elementEP.getEditingDomain();
        domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper((org.eclipse.gef.commands.Command)compoundCommand));
    }

    public void populateDiagram(Diagram diagram, boolean sortedPorts) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        DiagramEditPart diagramEP = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
        this.setHost((IGraphicalEditPart)diagramEP);
        this.sortedPorts = sortedPorts;
        IGraphicalEditPart selectedElementEP = (IGraphicalEditPart)diagramEP.getChildren().get(0);
        this.selectedElements = new ArrayList();
        this.selectedElements.add(selectedElementEP);
        this.initAction();
        this.buildInitialSelection();
        this.buildSelection();
        if (this.selection.size() > 0) {
            this.buildShowHideElementsList(this.selection.toArray());
            org.eclipse.gef.commands.Command command = this.getActionCommand();
            TransactionalEditingDomain domain = ((IGraphicalEditPart)this.selectedElements.get(0)).getEditingDomain();
            domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper(command));
            this.resizeElements((IGraphicalEditPart)diagramEP);
            this.drawAllComponentInstancesPorts(selectedElementEP);
            this.drawConnectors(selectedElementEP, (EList<Connector>)((Class)selectedElementEP.resolveSemanticElement()).getOwnedConnectors());
        }
    }

    public void setHost(IGraphicalEditPart diagramEP) {
        this.host = diagramEP;
    }

    private CompoundCommand drawMissingPorts(IGraphicalEditPart elementEP, EList<Port> missingPorts) {
        CompoundCommand command = new CompoundCommand("Draw Missing Ports Commands");
        View compartmentView = elementEP.getNotationView();
        for (Port port : missingPorts) {
            ShowHideElementsRequest request = new ShowHideElementsRequest(compartmentView, (EObject)port);
            request.setLocation(new Point(missingPorts.indexOf((Object)port) * 40, 10000));
            org.eclipse.gef.commands.Command cmd = elementEP.getCommand((Request)request);
            if (cmd == null || !cmd.canExecute()) continue;
            command.add(cmd);
        }
        return command;
    }

    private IGraphicalEditPart getComponentInstanceEditPart(IGraphicalEditPart owner, Property componentInstance) {
        List compartmentChildrenEP = ((EditPart)owner.getChildren().get(1)).getChildren();
        for (Object childEP : compartmentChildrenEP) {
            EObject semanticElement;
            if (!(childEP instanceof IGraphicalEditPart) || (semanticElement = ((IGraphicalEditPart)childEP).resolveSemanticElement()) != componentInstance) continue;
            return (IGraphicalEditPart)childEP;
        }
        return null;
    }

    private void drawMissingComponentsPorts(IGraphicalEditPart mainElementEP, EList<Property> missingComponentInstances) {
        CompoundCommand command = new CompoundCommand("Draw Component Instances Ports Commands");
        for (Property componentInstance : missingComponentInstances) {
            command.add((org.eclipse.gef.commands.Command)this.drawComponentInstancePorts(this.getComponentInstanceEditPart(mainElementEP, componentInstance)));
        }
        TransactionalEditingDomain domain = mainElementEP.getEditingDomain();
        domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper((org.eclipse.gef.commands.Command)command));
    }

    private void adjustMissingPortsLabels(IGraphicalEditPart elementEP, final EList<Port> missingPorts) {
        Map elements = elementEP.getViewer().getEditPartRegistry();
        final Object[] editParts = elements.values().toArray();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)elementEP.getNotationView());
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                int i = 0;
                while (i < editParts.length) {
                    Port port;
                    LocationImpl layout;
                    CSSDecorationNodeImpl view;
                    if (editParts[i] instanceof FlowPortAffixedLabelNameEditPart) {
                        FlowPortAffixedLabelNameEditPart labelEditPart = (FlowPortAffixedLabelNameEditPart)editParts[i];
                        view = (CSSDecorationNodeImpl)labelEditPart.getNotationView();
                        layout = (LocationImpl)view.getLayoutConstraint();
                        port = (Port)((FlowPortAffixedLabelNameEditPart)editParts[i]).resolveSemanticElement();
                        if (missingPorts.contains((Object)port)) {
                            layout.setY(layout.getY() - 20);
                        }
                    } else if (editParts[i] instanceof PortAffixedLabelNameEditPart) {
                        PortAffixedLabelNameEditPart editPart = (PortAffixedLabelNameEditPart)editParts[i];
                        view = (CSSDecorationNodeImpl)editPart.getNotationView();
                        layout = (LocationImpl)view.getLayoutConstraint();
                        port = (Port)((PortAffixedLabelNameEditPart)editParts[i]).resolveSemanticElement();
                        if (missingPorts.contains((Object)port)) {
                            layout.setY(layout.getY() - 20);
                        }
                    }
                    ++i;
                }
            }
        });
    }

    private boolean drawUpdatedComponentInstancesPorts(IGraphicalEditPart mainElementEP, EList<Property> displayedComponentInstances, EList<Port> displayedPorts) {
        CompoundCommand command = new CompoundCommand("Draw Component Instances Ports Commands");
        BasicEList totalMissingComponentPorts = new BasicEList();
        for (Property componentInstance : displayedComponentInstances) {
            Class component = (Class)componentInstance.getType();
            EList existingComponentPorts = component.getOwnedPorts();
            BasicEList missingComponentPorts = new BasicEList();
            for (Port port : existingComponentPorts) {
                if (displayedPorts.contains((Object)port)) {
                    logger.debug((Object)"port already present in diagram");
                    continue;
                }
                logger.debug((Object)("port is not present in diagram: " + port));
                missingComponentPorts.add((Object)port);
                totalMissingComponentPorts.add((Object)port);
            }
            if (missingComponentPorts.size() <= 0) continue;
            command.add((org.eclipse.gef.commands.Command)this.drawMissingPorts(this.getComponentInstanceEditPart(mainElementEP, componentInstance), (EList<Port>)missingComponentPorts));
        }
        TransactionalEditingDomain domain = mainElementEP.getEditingDomain();
        domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper((org.eclipse.gef.commands.Command)command));
        this.adjustMissingPortsLabels(mainElementEP, (EList<Port>)totalMissingComponentPorts);
        return command.size() > 0;
    }

    private boolean drawUpdatedMainComponentPorts(IGraphicalEditPart mainElementEP, EList<Port> displayedPorts) {
        CompoundCommand command = new CompoundCommand("Draw Component Instances Ports Commands");
        EList existingMainComponentPorts = ((Class)mainElementEP.resolveSemanticElement()).getOwnedPorts();
        BasicEList missingMainComponentPorts = new BasicEList();
        for (Port port : existingMainComponentPorts) {
            if (displayedPorts.contains((Object)port)) {
                logger.debug((Object)"port already present in diagram");
                continue;
            }
            logger.debug((Object)("port is not present in diagram: " + port));
            missingMainComponentPorts.add((Object)port);
        }
        if (missingMainComponentPorts.size() > 0) {
            command.add((org.eclipse.gef.commands.Command)this.drawMissingPorts(mainElementEP, (EList<Port>)missingMainComponentPorts));
            TransactionalEditingDomain domain = mainElementEP.getEditingDomain();
            domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper((org.eclipse.gef.commands.Command)command));
            this.adjustMissingPortsLabels(mainElementEP, (EList<Port>)missingMainComponentPorts);
        }
        return command.size() > 0;
    }

    public boolean refreshDiagram(IGraphicalEditPart diagramEditPart) {
        boolean isDiagramChanged = false;
        IGraphicalEditPart mainElementEP = (IGraphicalEditPart)diagramEditPart.getChildren().get(0);
        Class mainElement = (Class)mainElementEP.resolveSemanticElement();
        Map elements = diagramEditPart.getViewer().getEditPartRegistry();
        Object[] editParts = elements.values().toArray();
        BasicEList displayedComponentInstances = new BasicEList();
        BasicEList displayedConnectors = new BasicEList();
        BasicEList displayedPorts = new BasicEList();
        int i = 0;
        while (i < editParts.length) {
            if (editParts[i] instanceof BlockPropertyCompositeEditPart) {
                displayedComponentInstances.add((Object)((Property)((BlockPropertyCompositeEditPart)editParts[i]).resolveSemanticElement()));
            } else if (editParts[i] instanceof ConnectorEditPart) {
                displayedConnectors.add((Object)((Connector)((ConnectorEditPart)editParts[i]).resolveSemanticElement()));
            } else if (editParts[i] instanceof FlowPortAffixedNodeEditPart) {
                displayedPorts.add((Object)((Port)((FlowPortAffixedNodeEditPart)editParts[i]).resolveSemanticElement()));
            }
            ++i;
        }
        this.sortedPorts = true;
        if (this.drawUpdatedMainComponentPorts(mainElementEP, (EList<Port>)displayedPorts)) {
            isDiagramChanged = true;
        }
        if (this.drawUpdatedComponentInstancesPorts(mainElementEP, (EList<Property>)displayedComponentInstances, (EList<Port>)displayedPorts)) {
            isDiagramChanged = true;
        }
        BasicEList existingComponentInstances = new BasicEList((Collection)this.entityUtil.getSubComponentsInstances(mainElement));
        BasicEList missingComponentInstances = new BasicEList();
        for (Property property : existingComponentInstances) {
            if (displayedComponentInstances.contains((Object)property)) {
                logger.debug((Object)"component instance already present in diagram");
                continue;
            }
            logger.debug((Object)("component instance is not present in diagram: " + property));
            missingComponentInstances.add((Object)property);
        }
        this.selectedElements = new ArrayList();
        this.selectedElements.add(mainElementEP);
        this.host = diagramEditPart;
        this.initAction();
        this.buildInitialSelection();
        this.buildSelection();
        if (this.selection.size() > 0) {
            this.buildShowHideElementsList(this.selection.toArray());
            CompoundCommand command = (CompoundCommand)this.getActionCommand();
            if (command.size() > 0) {
                isDiagramChanged = true;
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagramEditPart.getNotationView());
                domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper((org.eclipse.gef.commands.Command)command));
            }
        }
        this.resizeMissingComponentInstances(mainElementEP, (EList<Property>)missingComponentInstances);
        this.drawMissingComponentsPorts(mainElementEP, (EList<Property>)missingComponentInstances);
        EList existingConnectors = mainElement.getOwnedConnectors();
        BasicEList missingConnectors = new BasicEList();
        for (Connector connector : existingConnectors) {
            if (displayedConnectors.contains((Object)connector)) {
                logger.debug((Object)"connector already present in diagram");
                continue;
            }
            logger.debug((Object)("connector is not present in diagram: " + connector));
            missingConnectors.add((Object)connector);
        }
        if (missingConnectors.size() > 0) {
            isDiagramChanged = true;
            this.drawConnectors(mainElementEP, (EList<Connector>)missingConnectors);
        }
        return isDiagramChanged;
    }
}

