/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeSetConfigurationRegistry;
import org.eclipse.papyrus.uml.profile.types.generator.ui.internal.Activator;
import org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards.GeneratorWizardModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

class BaseElementTypeSetBlock {
    private static final String DIAGRAM = "diagram";
    private static final String SUPPRESS_SEMANTIC_SUPERTYPES = "suppressSemanticSupertypes";
    private static final String UML_ELEMENT_TYPE_SET = "org.eclipse.papyrus.uml.service.types.UMLElementTypeSet";
    private static final String CONTEXT_ID = "org.eclipse.papyrus.infra.services.edit.TypeContext";
    private final GeneratorWizardModel model;
    private final BiMap<String, ElementTypeSetConfiguration> elementTypeSets;

    public BaseElementTypeSetBlock(GeneratorWizardModel model) {
        this.model = model;
        this.elementTypeSets = HashBiMap.create((Map)((Map)ElementTypeSetConfigurationRegistry.getInstance().getElementTypeSetConfigurations().get(CONTEXT_ID)));
    }

    public void createControl(Composite parent) {
        new Label(parent, 0).setText("Base element types set:");
        ComboViewer combo = new ComboViewer(new Combo(parent, 12));
        combo.setLabelProvider((IBaseLabelProvider)new DiagramListLabelProvider((Control)parent));
        combo.getControl().setLayoutData((Object)new GridData(768));
        combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        combo.setInput((Object)BaseElementTypeSetBlock.getOrdering().sortedCopy((Iterable)this.elementTypeSets.values()));
        final Button suppressSemanticSuperElementTypes = new Button(parent, 32);
        suppressSemanticSuperElementTypes.setLayoutData((Object)new GridData(4, -1, false, false, 2, 1));
        suppressSemanticSuperElementTypes.setText("Suppress semantic parent in diagram-specific element types");
        suppressSemanticSuperElementTypes.setSelection(this.model.getDialogSettings().getBoolean(SUPPRESS_SEMANTIC_SUPERTYPES));
        ElementTypeSetConfiguration initialSelection = this.getInitialSelection();
        if (initialSelection != null) {
            combo.setSelection((ISelection)new StructuredSelection((Object)initialSelection));
            this.elementTypeSetSelectionChanged((IStructuredSelection)combo.getSelection());
        }
        combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BaseElementTypeSetBlock.this.elementTypeSetSelectionChanged((IStructuredSelection)event.getSelection());
                suppressSemanticSuperElementTypes.setEnabled(!BaseElementTypeSetBlock.UML_ELEMENT_TYPE_SET.equals(BaseElementTypeSetBlock.this.model.getSelectedElementTypeSet()));
                BaseElementTypeSetBlock.this.model.validatePage();
            }
        });
        this.setSuppressSemanticSupertypes(suppressSemanticSuperElementTypes.getSelection());
        suppressSemanticSuperElementTypes.setEnabled(!UML_ELEMENT_TYPE_SET.equals(this.model.getSelectedElementTypeSet()));
        suppressSemanticSuperElementTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseElementTypeSetBlock.this.setSuppressSemanticSupertypes(suppressSemanticSuperElementTypes.getSelection());
            }
        });
    }

    void elementTypeSetSelectionChanged(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            this.setElementTypeSet(null);
        } else {
            this.setElementTypeSet((ElementTypeSetConfiguration)selection.getFirstElement());
        }
    }

    void setElementTypeSet(ElementTypeSetConfiguration elementTypeSet) {
        this.model.setSelectedElementTypeSet(elementTypeSet == null ? null : (String)this.elementTypeSets.inverse().get((Object)elementTypeSet));
    }

    void setSuppressSemanticSupertypes(boolean suppress) {
        this.model.setSuppressSemanticSuperElementTypes(suppress);
    }

    void save() {
        this.model.getDialogSettings().put(DIAGRAM, this.model.getSelectedElementTypeSet());
        this.model.getDialogSettings().put(SUPPRESS_SEMANTIC_SUPERTYPES, this.model.isSuppressSemanticSuperElementTypes());
    }

    private ElementTypeSetConfiguration getInitialSelection() {
        ElementTypeSetConfiguration result = null;
        String id = this.model.getDialogSettings().get(DIAGRAM);
        if (id != null) {
            result = (ElementTypeSetConfiguration)this.elementTypeSets.get((Object)id);
        }
        if (result == null) {
            result = (ElementTypeSetConfiguration)this.elementTypeSets.get((Object)UML_ELEMENT_TYPE_SET);
        }
        return result;
    }

    static String getName(ElementTypeSetConfiguration elementTypeSet) {
        String result = elementTypeSet.getName();
        if (Strings.isNullOrEmpty((String)result)) {
            URI uri = elementTypeSet.eResource().getURI();
            result = uri.trimFileExtension().lastSegment();
        }
        return result;
    }

    private static Function<ElementTypeSetConfiguration, String> getNameFunction() {
        return new Function<ElementTypeSetConfiguration, String>(){

            public String apply(ElementTypeSetConfiguration input) {
                return BaseElementTypeSetBlock.getName(input);
            }
        };
    }

    static String getLocation(ElementTypeSetConfiguration elementTypeSet) {
        URI uri = elementTypeSet.eResource().getURI();
        String result = uri.isPlatformResource() ? uri.trimSegments(1).toPlatformString(true) : (uri.isPlatformPlugin() ? uri.segment(1) : uri.toString());
        return result;
    }

    private static Function<ElementTypeSetConfiguration, String> getLocationFunction() {
        return new Function<ElementTypeSetConfiguration, String>(){

            public String apply(ElementTypeSetConfiguration input) {
                return BaseElementTypeSetBlock.getLocation(input);
            }
        };
    }

    static Ordering<ElementTypeSetConfiguration> getOrdering() {
        Ordering strings = Ordering.from((Comparator)Policy.getComparator());
        return strings.onResultOf(BaseElementTypeSetBlock.getNameFunction()).compound((Comparator)strings.onResultOf(BaseElementTypeSetBlock.getLocationFunction()));
    }

    private static class DiagramListLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private ResourceManager images;

        DiagramListLabelProvider(Control owner) {
            this.images = new LocalResourceManager(JFaceResources.getResources(), owner);
        }

        public StyledString getStyledText(Object element) {
            ElementTypeSetConfiguration elementTypeSet = (ElementTypeSetConfiguration)element;
            return new StyledString(BaseElementTypeSetBlock.getName(elementTypeSet)).append(NLS.bind((String)" - {0}", (Object)BaseElementTypeSetBlock.getLocation(elementTypeSet)), StyledString.QUALIFIER_STYLER);
        }

        public String getText(Object element) {
            ElementTypeSetConfiguration elementTypeSet = (ElementTypeSetConfiguration)element;
            return NLS.bind((String)"{0} - {1}", (Object)BaseElementTypeSetBlock.getName(elementTypeSet), (Object)BaseElementTypeSetBlock.getLocation(elementTypeSet));
        }

        public Image getImage(Object element) {
            Image result = null;
            ElementTypeSetConfiguration set = (ElementTypeSetConfiguration)element;
            URI uri = set.eResource().getURI();
            if (uri.isPlatformPlugin()) {
                result = (Image)this.images.get((DeviceResourceDescriptor)Activator.getInstance().getIcon("obj16/plugin.gif"));
            } else if (uri.isPlatformResource()) {
                result = (Image)this.images.get((DeviceResourceDescriptor)Activator.getInstance().getIcon("obj16/project.png"));
            }
            return result;
        }
    }
}

