/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOFeatureType;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping3;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.AbstractMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractBasicListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.IMappingConstants;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.IDBSchemaTransaction;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.spi.db.ddl.InternalDBIndex;
import org.eclipse.net4j.util.lifecycle.IDeactivateable;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHorizontalClassMapping
implements IClassMapping,
IMappingConstants,
IDeactivateable {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractHorizontalClassMapping.class);
    private EClass eClass;
    private IDBTable table;
    private AbstractHorizontalMappingStrategy mappingStrategy;
    private List<ITypeMapping> valueMappings;
    private List<IListMapping> listMappings;
    private Map<EStructuralFeature, IDBField> listSizeFields;
    private Map<EStructuralFeature, IDBField> unsettableFields;
    private String sqlSelectForHandle;
    private String sqlSelectForChangeSet;

    public AbstractHorizontalClassMapping(AbstractHorizontalMappingStrategy mappingStrategy, EClass eClass) {
        this.mappingStrategy = mappingStrategy;
        this.eClass = eClass;
        this.initTable();
        this.initFields();
        this.initSQLStrings();
    }

    private void initTable() {
        String tableName = this.mappingStrategy.getTableName((ENamedElement)this.eClass);
        DBType idType = this.mappingStrategy.getStore().getIDHandler().getDBType();
        int idLength = this.mappingStrategy.getStore().getIDColumnLength();
        IDBDatabase database = this.mappingStrategy.getStore().getDatabase();
        this.table = database.getSchema().getTable(tableName);
        if (this.table == null) {
            IDBSchemaTransaction schemaTransaction = database.getSchemaTransaction();
            IDBSchema workingCopy = schemaTransaction.getWorkingCopy();
            this.table = workingCopy.addTable(tableName);
            this.table.addField("CDO_ID", idType, idLength, true);
            this.table.addField("CDO_VERSION", DBType.INTEGER, true);
            IDBField branchField = this.addBranchField(this.table);
            this.table.addField("CDO_CREATED", DBType.BIGINT, true);
            this.table.addField("CDO_REVISED", DBType.BIGINT, true);
            this.table.addField("CDO_RESOURCE", idType, idLength, true);
            this.table.addField("CDO_CONTAINER", idType, idLength, true);
            this.table.addField("CDO_FEATURE", DBType.INTEGER, true);
            IDBIndex primaryKey = this.table.addIndex(IDBIndex.Type.PRIMARY_KEY, new String[]{"CDO_ID", "CDO_VERSION"});
            if (branchField != null) {
                primaryKey.addIndexField(branchField);
            }
            this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{"CDO_REVISED"});
        }
    }

    private void initFields() {
        EStructuralFeature[] allPersistentFeatures = CDOModelUtil.getClassInfo((EClass)this.eClass).getAllPersistentFeatures();
        if (allPersistentFeatures == null) {
            this.valueMappings = Collections.emptyList();
            this.listMappings = Collections.emptyList();
        } else {
            String fieldName;
            EStructuralFeature feature;
            this.valueMappings = new ArrayList<ITypeMapping>();
            this.listMappings = new ArrayList<IListMapping>();
            boolean hasUnsettableFeatures = false;
            EStructuralFeature[] eStructuralFeatureArray = allPersistentFeatures;
            int n = allPersistentFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                IDBField field;
                Object mapping;
                feature = eStructuralFeatureArray[n2];
                fieldName = this.mappingStrategy.getFieldName(feature);
                if (feature.isMany()) {
                    mapping = null;
                    mapping = FeatureMapUtil.isFeatureMap((EStructuralFeature)feature) ? this.mappingStrategy.createFeatureMapMapping(this.eClass, feature) : this.mappingStrategy.createListMapping(this.eClass, feature);
                    if (mapping instanceof IListMapping3) {
                        ((IListMapping3)mapping).setClassMapping(this);
                    }
                    this.listMappings.add((IListMapping)mapping);
                    if (this.listSizeFields == null) {
                        this.listSizeFields = new LinkedHashMap<EStructuralFeature, IDBField>();
                    }
                    if ((field = this.table.getField(fieldName)) == null) {
                        field = this.table.addField(fieldName, DBType.INTEGER);
                    }
                    this.listSizeFields.put(feature, field);
                } else {
                    mapping = this.mappingStrategy.createValueMapping(feature);
                    field = this.table.getField(fieldName);
                    if (field == null) {
                        mapping.createDBField(this.table, fieldName);
                    } else {
                        mapping.setDBField(this.table, fieldName);
                    }
                    this.valueMappings.add((ITypeMapping)mapping);
                    Set<CDOFeatureType> forceIndexes = AbstractMappingStrategy.getForceIndexes(this.mappingStrategy);
                    if (CDOFeatureType.matchesCombination((EStructuralFeature)feature, forceIndexes)) {
                        if (field == null) {
                            field = this.table.getField(fieldName);
                        }
                        if (!this.table.hasIndexFor(new IDBField[]{field})) {
                            InternalDBIndex index = (InternalDBIndex)this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{field});
                            index.setOptional(true);
                        }
                    }
                    if (feature.isUnsettable()) {
                        hasUnsettableFeatures = true;
                    }
                }
                ++n2;
            }
            if (hasUnsettableFeatures) {
                this.unsettableFields = new LinkedHashMap<EStructuralFeature, IDBField>();
                eStructuralFeatureArray = allPersistentFeatures;
                n = allPersistentFeatures.length;
                n2 = 0;
                while (n2 < n) {
                    feature = eStructuralFeatureArray[n2];
                    if (!feature.isMany() && feature.isUnsettable()) {
                        fieldName = this.mappingStrategy.getUnsettableFieldName(feature);
                        IDBField field = this.table.getField(fieldName);
                        if (field == null) {
                            field = this.table.addField(fieldName, DBType.BOOLEAN);
                        }
                        this.unsettableFields.put(feature, field);
                    }
                    ++n2;
                }
            }
        }
    }

    private void initSQLStrings() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append("CDO_ID");
        builder.append(", ");
        builder.append("CDO_VERSION");
        builder.append(" FROM ");
        builder.append(this.table);
        this.sqlSelectForHandle = builder.toString();
        builder = new StringBuilder("SELECT DISTINCT ");
        builder.append("CDO_ID");
        builder.append(" FROM ");
        builder.append(this.table);
        builder.append(" WHERE ");
        this.sqlSelectForChangeSet = builder.toString();
    }

    protected IDBField addBranchField(IDBTable table) {
        return null;
    }

    protected final boolean readValuesFromStatement(PreparedStatement stmt, InternalCDORevision revision, IDBStoreAccessor accessor) {
        ResultSet resultSet;
        block5: {
            block6: {
                resultSet = null;
                try {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Executing Query: {0}", new Object[]{stmt.toString()});
                    }
                    stmt.setMaxRows(1);
                    resultSet = stmt.executeQuery();
                    IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
                    if (this.readValuesFromResultSet(resultSet, idHandler, revision, false)) break block5;
                    if (!TRACER.isEnabled()) break block6;
                    TRACER.format("Resultset was empty", new Object[0]);
                }
                catch (SQLException ex) {
                    try {
                        throw new DBException((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        DBUtil.close(resultSet);
                        throw throwable;
                    }
                }
            }
            DBUtil.close((ResultSet)resultSet);
            return false;
        }
        DBUtil.close((ResultSet)resultSet);
        return true;
    }

    protected final boolean readValuesFromResultSet(ResultSet resultSet, IIDHandler idHandler, InternalCDORevision revision, boolean forUnit) {
        try {
            if (resultSet.next()) {
                IDBField field;
                EStructuralFeature feature;
                long timeStamp = resultSet.getLong("CDO_CREATED");
                CDOBranchPoint branchPoint = revision.getBranch().getPoint(timeStamp);
                if (forUnit) {
                    revision.setID(idHandler.getCDOID(resultSet, "CDO_ID"));
                }
                revision.setBranchPoint(branchPoint);
                revision.setVersion(resultSet.getInt("CDO_VERSION"));
                revision.setRevised(resultSet.getLong("CDO_REVISED"));
                revision.setResourceID(idHandler.getCDOID(resultSet, "CDO_RESOURCE"));
                revision.setContainerID((Object)idHandler.getCDOID(resultSet, "CDO_CONTAINER"));
                revision.setContainingFeatureID(resultSet.getInt("CDO_FEATURE"));
                for (ITypeMapping iTypeMapping : this.valueMappings) {
                    feature = iTypeMapping.getFeature();
                    if (feature.isUnsettable() && !resultSet.getBoolean((field = this.unsettableFields.get(feature)).getName())) {
                        revision.setValue(feature, null);
                        continue;
                    }
                    iTypeMapping.readValueToRevision(resultSet, revision);
                }
                if (this.listSizeFields != null) {
                    for (Map.Entry entry : this.listSizeFields.entrySet()) {
                        feature = (EStructuralFeature)entry.getKey();
                        field = (IDBField)entry.getValue();
                        int size = resultSet.getInt(field.getName());
                        CDOList list = revision.getList(feature, size);
                        int i = 0;
                        while (i < size) {
                            list.add(InternalCDOList.UNINITIALIZED);
                            ++i;
                        }
                        if (list.size() == size) continue;
                        Assert.isTrue((boolean)false);
                    }
                }
                return true;
            }
            return false;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected final void readLists(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        for (IListMapping listMapping : this.listMappings) {
            listMapping.readValues(accessor, revision, listChunk);
        }
    }

    protected final IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    @Override
    public final EClass getEClass() {
        return this.eClass;
    }

    protected final Map<EStructuralFeature, IDBField> getUnsettableFields() {
        return this.unsettableFields;
    }

    protected final Map<EStructuralFeature, IDBField> getListSizeFields() {
        return this.listSizeFields;
    }

    @Override
    public final List<ITypeMapping> getValueMappings() {
        return this.valueMappings;
    }

    public final ITypeMapping getValueMapping(EStructuralFeature feature) {
        for (ITypeMapping mapping : this.valueMappings) {
            if (mapping.getFeature() != feature) continue;
            return mapping;
        }
        return null;
    }

    @Override
    public final List<IListMapping> getListMappings() {
        return this.listMappings;
    }

    @Override
    public final IListMapping getListMapping(EStructuralFeature feature) {
        for (IListMapping mapping : this.listMappings) {
            if (mapping.getFeature() != feature) continue;
            return mapping;
        }
        throw new IllegalArgumentException("List mapping for feature " + feature + " does not exist");
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    @Override
    public List<IDBTable> getDBTables() {
        ArrayList<IDBTable> tables = new ArrayList<IDBTable>();
        tables.add(this.table);
        for (IListMapping listMapping : this.listMappings) {
            tables.addAll(listMapping.getDBTables());
        }
        return tables;
    }

    public String toString() {
        return MessageFormat.format("{0}[{1} -> {2}]", this.getClass().getSimpleName(), this.eClass, this.table);
    }

    protected void checkDuplicateResources(IDBStoreAccessor accessor, CDORevision revision) throws IllegalStateException {
        String name;
        CDOID folderID = (CDOID)revision.data().getContainerID();
        CDOID existingID = accessor.readResourceID(folderID, name = (String)revision.data().get((EStructuralFeature)EresourcePackage.eINSTANCE.getCDOResourceNode_Name(), 0), revision.getBranch().getHead());
        if (existingID != null && !existingID.equals(revision.getID())) {
            throw new IllegalStateException("Duplicate resource node in folder " + folderID + ": " + name);
        }
    }

    protected void writeLists(IDBStoreAccessor accessor, InternalCDORevision revision) {
        for (IListMapping listMapping : this.listMappings) {
            listMapping.writeValues(accessor, revision);
        }
    }

    @Override
    public void writeRevision(IDBStoreAccessor accessor, InternalCDORevision revision, boolean mapType, boolean revise, OMMonitor monitor) {
        boolean duplicateResourcesCheckNeeded = revision.isResourceNode() && this.mappingStrategy.getStore().getRepository().getRootResourceID() != null;
        monitor.begin((double)(duplicateResourcesCheckNeeded ? 10 : 9));
        OMMonitor.Async async = null;
        try {
            try {
                async = monitor.forkAsync();
                CDOID id = revision.getID();
                if (mapType) {
                    long timeStamp = revision.getTimeStamp();
                    this.mappingStrategy.putObjectType(accessor, timeStamp, id, this.eClass);
                } else if (revise) {
                    long revised = revision.getTimeStamp() - 1L;
                    this.reviseOldRevision(accessor, id, (CDOBranch)revision.getBranch(), revised);
                    for (IListMapping mapping : this.getListMappings()) {
                        mapping.objectDetached(accessor, id, revised);
                    }
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            if (duplicateResourcesCheckNeeded) {
                try {
                    async = monitor.forkAsync();
                    this.checkDuplicateResources(accessor, (CDORevision)revision);
                }
                finally {
                    if (async != null) {
                        async.stop();
                    }
                }
            }
            try {
                async = monitor.forkAsync();
                this.writeValues(accessor, revision);
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                if (this.listMappings != null) {
                    async = monitor.forkAsync(7.0);
                    this.writeLists(accessor, revision);
                } else {
                    monitor.worked(7.0);
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void handleRevisions(IDBStoreAccessor accessor, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        IRepository repository = accessor.getStore().getRepository();
        CDORevisionManager revisionManager = repository.getRevisionManager();
        CDOBranchManager branchManager = repository.getBranchManager();
        StringBuilder builder = new StringBuilder(this.sqlSelectForHandle);
        int timeParameters = 0;
        if (timeStamp != -1L) {
            if (exactTime) {
                if (timeStamp != 0L) {
                    builder.append(" WHERE ");
                    builder.append("CDO_CREATED");
                    builder.append("=?");
                    timeParameters = 1;
                }
            } else {
                builder.append(" WHERE ");
                if (timeStamp != 0L) {
                    builder.append("CDO_CREATED");
                    builder.append("<=?");
                    builder.append(" AND (");
                    builder.append("CDO_REVISED");
                    builder.append(">=? OR ");
                    builder.append("CDO_REVISED");
                    builder.append("=0)");
                    timeParameters = 2;
                } else {
                    builder.append("CDO_REVISED");
                    builder.append("=0");
                }
            }
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(builder.toString(), IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        try {
            try {
                int i = 0;
                while (i < timeParameters) {
                    stmt.setLong(i + 1, timeStamp);
                    ++i;
                }
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    InternalCDORevision revision;
                    CDOID id = idHandler.getCDOID((ResultSet)resultSet, 1);
                    int version = resultSet.getInt(2);
                    if (version < 1 || handler.handleRevision((CDORevision)(revision = (InternalCDORevision)revisionManager.getRevisionByVersion(id, branchManager.getMainBranch().getVersion(version), -1, true)))) {
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    @Override
    public Set<CDOID> readChangeSet(IDBStoreAccessor accessor, CDOChangeSetSegment[] segments) {
        HashSet<CDOID> hashSet;
        StringBuilder builder = new StringBuilder(this.sqlSelectForChangeSet);
        boolean isFirst = true;
        int i = 0;
        while (i < segments.length) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(" OR ");
            }
            builder.append("CDO_CREATED");
            builder.append(">=?");
            builder.append(" AND (");
            builder.append("CDO_REVISED");
            builder.append("<=? OR ");
            builder.append("CDO_REVISED");
            builder.append("=0)");
            ++i;
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(builder.toString(), IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        HashSet<CDOID> result = new HashSet<CDOID>();
        try {
            int column = 1;
            CDOChangeSetSegment[] cDOChangeSetSegmentArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                CDOChangeSetSegment segment = cDOChangeSetSegmentArray[n2];
                stmt.setLong(column++, segment.getTimeStamp());
                stmt.setLong(column++, segment.getEndTime());
                ++n2;
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                CDOID id = idHandler.getCDOID((ResultSet)resultSet, 1);
                result.add(id);
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return hashSet;
    }

    @Override
    public void detachObject(IDBStoreAccessor accessor, CDOID id, int version, CDOBranch branch, long timeStamp, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin((double)(1 + this.listMappings.size()));
        try {
            if (version >= 1) {
                this.reviseOldRevision(accessor, id, branch, timeStamp - 1L);
            }
            this.detachAttributes(accessor, id, version, branch, timeStamp, monitor.fork());
            for (IListMapping mapping : this.getListMappings()) {
                try {
                    async = monitor.forkAsync();
                    mapping.objectDetached(accessor, id, timeStamp);
                }
                finally {
                    if (async != null) {
                        async.stop();
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public void rawDelete(IDBStoreAccessor accessor, CDOID id, int version, CDOBranch branch, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin((double)(1 + this.listMappings.size()));
        try {
            this.rawDeleteAttributes(accessor, id, branch, version, monitor.fork());
            for (IListMapping mapping : this.getListMappings()) {
                if (mapping instanceof AbstractBasicListTableMapping) {
                    try {
                        async = monitor.forkAsync();
                        AbstractBasicListTableMapping m = (AbstractBasicListTableMapping)mapping;
                        m.rawDeleted(accessor, id, branch, version);
                        continue;
                    }
                    finally {
                        if (async != null) {
                            async.stop();
                        }
                    }
                }
                throw new UnsupportedOperationException("rawDeleted() is not supported by " + mapping.getClass().getName());
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract void rawDeleteAttributes(IDBStoreAccessor var1, CDOID var2, CDOBranch var3, int var4, OMMonitor var5);

    @Override
    public final boolean queryXRefs(IDBStoreAccessor accessor, IStoreAccessor.QueryXRefsContext context, String idString) {
        boolean more;
        String tableName = this.table.getName();
        List refs = (List)context.getSourceCandidates().get(this.eClass);
        ArrayList<EReference> scalarRefs = new ArrayList<EReference>();
        for (EReference ref : refs) {
            if (ref.isMany()) {
                String where;
                IListMapping listMapping = this.getListMapping((EStructuralFeature)ref);
                boolean more2 = listMapping.queryXRefs(accessor, tableName, where = this.getListXRefsWhere(context), context, idString);
                if (more2) continue;
                return false;
            }
            scalarRefs.add(ref);
        }
        return scalarRefs.isEmpty() || (more = this.queryScalarXRefs(accessor, scalarRefs, context, idString));
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean queryScalarXRefs(IDBStoreAccessor accessor, List<EReference> scalarRefs, IStoreAccessor.QueryXRefsContext context, String idString) {
        IDBResultSet resultSet;
        IDBPreparedStatement stmt;
        String tableName = this.table.getName();
        String where = this.getListXRefsWhere(context);
        for (EReference ref : scalarRefs) {
            ITypeMapping valueMapping = this.getValueMapping((EStructuralFeature)ref);
            String valueField = valueMapping.getField().getName();
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT ");
            builder.append("CDO_ID");
            builder.append(", ");
            builder.append(valueField);
            builder.append(" FROM ");
            builder.append(tableName);
            builder.append(" WHERE ");
            builder.append("CDO_VERSION");
            builder.append(">0 AND ");
            builder.append(where);
            builder.append(" AND ");
            builder.append(valueField);
            builder.append(" IN ");
            builder.append(idString);
            String sql = builder.toString();
            if (TRACER.isEnabled()) {
                TRACER.format("Query XRefs (attributes): {0}", new Object[]{sql});
            }
            IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
            stmt = accessor.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
            resultSet = null;
            resultSet = stmt.executeQuery();
            boolean bl = true;
            while (true) {
                if (!bl || (bl = false) || !true) {
                    CDOID sourceID = idHandler.getCDOID((ResultSet)resultSet, 1);
                    CDOID targetID = idHandler.getCDOID((ResultSet)resultSet, 2);
                    boolean more = context.addXRef(targetID, sourceID, ref, 0);
                    if (TRACER.isEnabled()) {
                        TRACER.format("  add XRef to context: src={0}, tgt={1}, idx=0", new Object[]{sourceID, targetID});
                    }
                    if (!more) {
                        if (!TRACER.isEnabled()) return false;
                        TRACER.format("  result limit reached. Ignoring further results.", new Object[0]);
                        return false;
                    }
                }
                if (resultSet.next()) continue;
                break;
            }
            {
                continue;
                catch (SQLException ex) {}
                throw new DBException((Throwable)ex);
                return true;
            }
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    protected abstract String getListXRefsWhere(IStoreAccessor.QueryXRefsContext var1);

    protected abstract void detachAttributes(IDBStoreAccessor var1, CDOID var2, int var3, CDOBranch var4, long var5, OMMonitor var7);

    protected abstract void reviseOldRevision(IDBStoreAccessor var1, CDOID var2, CDOBranch var3, long var4);

    protected abstract void writeValues(IDBStoreAccessor var1, InternalCDORevision var2);

    public Exception deactivate() {
        return null;
    }

    protected static void appendTypeMappingNames(StringBuilder builder, Collection<ITypeMapping> typeMappings) {
        if (typeMappings != null) {
            for (ITypeMapping typeMapping : typeMappings) {
                builder.append(", ");
                builder.append(typeMapping.getField());
            }
        }
    }

    protected static void appendFieldNames(StringBuilder builder, Map<EStructuralFeature, IDBField> fields) {
        if (fields != null) {
            for (IDBField field : fields.values()) {
                builder.append(", ");
                builder.append(field);
            }
        }
    }

    protected static void appendTypeMappingParameters(StringBuilder builder, Collection<ITypeMapping> typeMappings) {
        if (typeMappings != null) {
            int i = 0;
            while (i < typeMappings.size()) {
                builder.append(", ?");
                ++i;
            }
        }
    }

    protected static void appendFieldParameters(StringBuilder builder, Map<EStructuralFeature, IDBField> fields) {
        if (fields != null) {
            int i = 0;
            while (i < fields.size()) {
                builder.append(", ?");
                ++i;
            }
        }
    }
}

