/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ast.utils;

import eu.fbk.eclipse.standardtools.ast.ASTElements.AssignStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Assignable;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Atom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.BinaryProposition;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Context;
import eu.fbk.eclipse.standardtools.ast.ASTElements.FullyQualifiedSymbol;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SelfAtom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Symbol;
import eu.fbk.eclipse.standardtools.utils.core.utils.SysMLElementExtractor;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class AstElementExtractor {
    public static final Logger logger = Logger.getLogger(AstElementExtractor.class);
    private SysMLElementExtractor sysMLExtractor;

    public AstElementExtractor(SysMLElementExtractor sysMLExtractor) {
        this.sysMLExtractor = sysMLExtractor;
    }

    public Object getInferredSysMLSymbolType(Symbol o) throws Exception {
        EObject eContainer = o.eContainer();
        if (eContainer instanceof AssignStatement) {
            logger.debug((Object)"it is inside an assignment");
            Assignable ids = ((AssignStatement)eContainer).getLhs();
            return this.retrieveSysMLType(ids);
        }
        if (eContainer instanceof BinaryProposition) {
            logger.debug((Object)"it is inside a BinaryProposition");
            FullyQualifiedSymbol ids = null;
            if (((BinaryProposition)eContainer).getLeft() instanceof FullyQualifiedSymbol) {
                ids = (FullyQualifiedSymbol)((BinaryProposition)eContainer).getLeft();
                Object idsType = this.retrieveSysMLType(ids);
                return idsType;
            }
            if (((BinaryProposition)eContainer).getRight() instanceof FullyQualifiedSymbol) {
                ids = (FullyQualifiedSymbol)((BinaryProposition)eContainer).getRight();
                Object idsType = this.retrieveSysMLType(ids);
                return idsType;
            }
        }
        return null;
    }

    public String returnEnumTypeName(Symbol o) throws Exception {
        Object enumElem;
        String literal = o.getAtom().getName();
        if (this.sysMLExtractor.isEnumLiteral(literal, enumElem = this.getInferredSysMLSymbolType(o))) {
            return this.sysMLExtractor.getEnumTypeName(enumElem);
        }
        return null;
    }

    public Object retrieveSysMLType(FullyQualifiedSymbol ids) throws Exception {
        Object type = this.getSysMLContextType(ids.getCtx());
        if (!(ids.getAtom() instanceof SelfAtom)) {
            type = this.sysMLExtractor.getAttributeOrOperationType(ids.getAtom().getName(), type);
        }
        if (type == null) {
            throw new Exception("Type not found for " + ids.getAtom().getName());
        }
        return type;
    }

    public String retrieveSysMLTypeName(FullyQualifiedSymbol ids) throws Exception {
        return this.sysMLExtractor.getElementName(this.retrieveSysMLType(ids));
    }

    public Object getSysMLContextType(Context context) throws Exception {
        Object type = null;
        if (!context.getAtoms().isEmpty()) {
            for (Atom id : context.getAtoms()) {
                type = this.getSysMLAtomType(id, type);
            }
        } else {
            type = this.sysMLExtractor.getCurrBlock();
        }
        if (type == null) {
            String idsStr = "";
            for (Atom id : context.getAtoms()) {
                idsStr = idsStr.concat(String.valueOf(id.getName()) + " - ");
            }
            throw new Exception("Type not found for " + idsStr);
        }
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getSysMLAtomType(Atom id, Object type) throws Exception {
        Object currType = null;
        logger.trace((Object)("I'm finding the type of id: " + id + ", the curr block is: " + this.sysMLExtractor.getCurrBlock()));
        logger.trace((Object)"first element");
        if (id instanceof SelfAtom) {
            if (type != null) throw new Exception("selfAtom placed in a wrong position.");
            currType = this.sysMLExtractor.getCurrBlock();
        } else if (type == null) {
            logger.warn((Object)("getAttributeOrOperationType: " + id));
            currType = this.sysMLExtractor.getAttributeOrOperationType(id.getName());
        } else {
            logger.trace((Object)("not first element: " + id.getName()));
            currType = this.sysMLExtractor.getAttributeOrOperationType(id.getName(), type);
        }
        if (currType == null) {
            throw new Exception("type found for id: " + id.getName());
        }
        logger.trace((Object)("type found for id: " + id + ", is type: " + currType));
        return currType;
    }

    public String[] getAttributeMultiplicity(String attributeName) throws Exception {
        return this.sysMLExtractor.getAttributeMultiplicity(attributeName);
    }
}

