/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexedList<E>
implements List<E> {
    @Override
    public abstract E get(int var1);

    @Override
    public abstract int size();

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        int size = this.size();
        int i = 0;
        while (i < size) {
            if (this.get(i).equals(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        return 0;
    }

    @Override
    public int lastIndexOf(Object o) {
        return 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new IndexedIterator(null, null);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new IndexedListIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new IndexedListIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return null;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int i = 0;
        while (i < this.size()) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(this.get(i).toString());
            ++i;
        }
        builder.append("}");
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ArrayBacked<E>
    extends IndexedList<E> {
        protected abstract E[] getArray();

        @Override
        public E get(int i) {
            return this.getArray()[i];
        }

        @Override
        public int size() {
            return this.getArray().length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexedIterator
    implements Iterator<E> {
        int pos = 0;

        private IndexedIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos != IndexedList.this.size();
        }

        @Override
        public E next() {
            try {
                return IndexedList.this.get(this.pos++);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /* synthetic */ IndexedIterator(IndexedIterator indexedIterator, IndexedIterator indexedIterator2) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexedListIterator
    extends IndexedIterator
    implements ListIterator<E> {
        IndexedListIterator(int index) {
            this.pos = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.pos != 0;
        }

        @Override
        public E previous() {
            try {
                return IndexedList.this.get(--this.pos);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.pos;
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void set(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E o) {
            throw new UnsupportedOperationException();
        }
    }
}

