/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.xtextService.core.utils;

import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.xtextService.ui.type.Parameter;
import eu.fbk.eclipse.standardtools.xtextService.ui.type.Port;
import eu.fbk.tools.editor.contract.expression.validation.PortProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.ProposalProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class XtextElementsUtil {
    private AbstractSystemModel systemModel;
    private static XtextElementsUtil xTextElementsUtil;

    public static XtextElementsUtil getInstance(AbstractSystemModel systemModel) {
        if (xTextElementsUtil == null) {
            xTextElementsUtil = new XtextElementsUtil(systemModel);
        }
        return xTextElementsUtil;
    }

    public XtextElementsUtil(AbstractSystemModel systemModel) {
        this.systemModel = systemModel;
    }

    private ProposalProvider.VariableType getXTextVariableType(Object attribute) {
        Object type = this.systemModel.getPortType(attribute);
        return this.getXTextType(type);
    }

    private ProposalProvider.VariableType getXTextType(Object type) {
        if (this.systemModel.isBooleanType(type)) {
            return ProposalProvider.VariableType.BOOLEAN;
        }
        if (this.systemModel.isContinuousType(type)) {
            return ProposalProvider.VariableType.CONTINUOUS;
        }
        if (this.systemModel.isEnumType(type)) {
            return ProposalProvider.VariableType.ENUM;
        }
        if (this.systemModel.isEventType(type)) {
            return ProposalProvider.VariableType.EVENT;
        }
        if (this.systemModel.isIntType(type)) {
            return ProposalProvider.VariableType.INTEGER;
        }
        if (this.systemModel.isNumberType(type)) {
            return ProposalProvider.VariableType.NUMBER;
        }
        if (this.systemModel.isRealType(type)) {
            return ProposalProvider.VariableType.REAL;
        }
        if (this.systemModel.isWordType(type)) {
            return ProposalProvider.VariableType.WORD;
        }
        return null;
    }

    private ProposalProvider.VariableType getXTextPortType(Object port) {
        return this.getXTextVariableType(port);
    }

    private PortProposalProvider.PortDirection getXTextPortDirection(Object port) {
        if (this.systemModel.isInputPort(port)) {
            return PortProposalProvider.PortDirection.IN;
        }
        if (this.systemModel.isOutputPort(port)) {
            return PortProposalProvider.PortDirection.OUT;
        }
        if (this.systemModel.isInOutPort(port)) {
            return PortProposalProvider.PortDirection.IN_OUT;
        }
        return null;
    }

    private ProposalProvider.VariableType getXTextUninterpretedFunctionOutputType(Object uninterpretedFunction) {
        Object type = this.systemModel.getUninterpretedFunctionOutputType(uninterpretedFunction);
        return this.getXTextType(type);
    }

    public EList<Port> getXTextPortsFromComponent(Object component) {
        return this.getXTextPorts(this.systemModel.getNonStaticPorts(component));
    }

    public EList<Port> getXTextPorts(EList<?> ports) {
        if (ports != null && ports.size() != 0) {
            BasicEList xTextPorts = new BasicEList();
            for (Object port : ports) {
                String portName = this.systemModel.getPortName(port);
                PortProposalProvider.PortDirection portDirection = this.getXTextPortDirection(port);
                ProposalProvider.VariableType portType = this.getXTextPortType(port);
                xTextPorts.add((Object)new Port(portName, portDirection, portType));
            }
            return xTextPorts;
        }
        return null;
    }

    public EList<Parameter> getXTextParametersFromComponent(Object component) {
        EList<Parameter> parametersFromStaticPorts = this.getXTextParametersFromStaticPorts(this.systemModel.getStaticPorts(component));
        EList<Parameter> parametersFromUninterpretedFunctions = this.getXTextParametersFromUninterpretedFunctions(this.systemModel.getUninterpretedFunctions(component));
        if (parametersFromStaticPorts != null) {
            if (parametersFromUninterpretedFunctions != null) {
                parametersFromStaticPorts.addAll(parametersFromUninterpretedFunctions);
            }
            return parametersFromStaticPorts;
        }
        return parametersFromUninterpretedFunctions;
    }

    public EList<String> getXTextDefinesNamesFromComponent(Object component) {
        EList defines = this.systemModel.getDefines(component);
        if (defines != null) {
            BasicEList definesNames = new BasicEList();
            for (Object define : defines) {
                definesNames.add((Object)this.systemModel.getDefineName(define));
            }
            return definesNames;
        }
        return null;
    }

    public EList<Parameter> getXTextParametersFromStaticPorts(EList<?> staticPorts) {
        if (staticPorts != null && staticPorts.size() != 0) {
            BasicEList xTextParameters = new BasicEList();
            for (Object staticPort : staticPorts) {
                String staticPortName = this.systemModel.getPortName(staticPort);
                ProposalProvider.VariableType attributeType = this.getXTextVariableType(staticPort);
                xTextParameters.add((Object)new Parameter(staticPortName, attributeType, null));
            }
            return xTextParameters;
        }
        return null;
    }

    public EList<Parameter> getXTextParametersFromUninterpretedFunctions(EList<?> uninterpretedFunctions) {
        if (uninterpretedFunctions != null && uninterpretedFunctions.size() != 0) {
            BasicEList xTextParameters = new BasicEList();
            for (Object uninterpretedFunction : uninterpretedFunctions) {
                String uninterpretedFunctionName = this.systemModel.getUninterpretedFunctionName(uninterpretedFunction);
                ProposalProvider.VariableType uninterpretedFunctionOutputType = this.getXTextUninterpretedFunctionOutputType(uninterpretedFunction);
                List<ProposalProvider.VariableType> uninterpretedFunctionInputTypes = this.getXTextUninterpretedFunctionInputTypes(uninterpretedFunction);
                xTextParameters.add((Object)new Parameter(uninterpretedFunctionName, uninterpretedFunctionOutputType, uninterpretedFunctionInputTypes));
            }
            return xTextParameters;
        }
        return null;
    }

    private List<ProposalProvider.VariableType> getXTextUninterpretedFunctionInputTypes(Object uninterpretedFunction) {
        EList types = this.systemModel.getUninterpretedFunctionInputTypes(uninterpretedFunction);
        return this.getXTextTypes((List<?>)types);
    }

    private List<ProposalProvider.VariableType> getXTextTypes(List<?> types) {
        ArrayList<ProposalProvider.VariableType> xTextTypes = null;
        if (types != null && types.size() != 0) {
            xTextTypes = new ArrayList<ProposalProvider.VariableType>();
            for (Object type : types) {
                xTextTypes.add(this.getXTextType(type));
            }
        }
        return xTextTypes;
    }
}

