/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.xtextService.core.utils;

import com.google.inject.Injector;
import eu.fbk.eclipse.standardtools.utils.core.parser.ParseHelper;
import eu.fbk.tools.editor.basetype.baseType.Expression;
import eu.fbk.tools.editor.basetype.ui.internal.BasetypeActivator;
import eu.fbk.tools.editor.c.statement.statement.Statement;
import eu.fbk.tools.editor.c.statement.ui.internal.StatementActivator;
import eu.fbk.tools.editor.c.ui.internal.CActivator;
import eu.fbk.tools.editor.contract.constraint.Constraint.ui.internal.ConstraintActivator;
import eu.fbk.tools.editor.contract.constraint.constraint.PortConstraint;
import eu.fbk.tools.editor.contract.constraint.ui.ConstraintResourceProvider;
import eu.fbk.tools.editor.contract.contract.Contracts;
import eu.fbk.tools.editor.contract.expression.expression.BoundedExpression;
import eu.fbk.tools.editor.contract.expression.ui.ExpressionResourceProvider;
import eu.fbk.tools.editor.contract.expression.ui.internal.ExpressionActivator;
import eu.fbk.tools.editor.contract.ui.internal.ContractActivator;
import eu.fbk.tools.editor.nusmv.smv.Model;
import eu.fbk.tools.editor.nusmv.ui.internal.NusmvActivator;
import eu.fbk.tools.editor.oss.oss.OSS;
import eu.fbk.tools.editor.oss.ui.internal.OssActivator;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.StringInputStream;

public class XTextResourceUtil {
    private static XTextResourceUtil xTextResourceUtil;
    private Injector ossInjector;
    private Injector contractInjector;
    private Injector constraintInjector;
    private Injector expressionInjector;
    private Injector nuSMVInjector;
    private Injector baseTypeInjector;
    private Injector cleanCInjector;
    private Injector cleanCStatementInjector;
    private Injector cleanCExpressionInjector;

    public static XTextResourceUtil getInstance() {
        if (xTextResourceUtil == null) {
            xTextResourceUtil = new XTextResourceUtil();
        }
        return xTextResourceUtil;
    }

    public XtextResource createXTextExpressionResourceFromString(String objectText) throws IOException {
        XtextResource xTextResource = this.createXTextExpressionResource();
        xTextResource.load((InputStream)new StringInputStream(objectText), null);
        return xTextResource;
    }

    public XtextResource createXTextConstraintResourceFromString(String objectText) throws IOException {
        XtextResource xTextResource = this.createXTextConstraintResource();
        xTextResource.load((InputStream)new StringInputStream(objectText), null);
        return xTextResource;
    }

    public XtextResource createXTextCExpressionResourceFromString(String objectText) throws IOException {
        XtextResource xTextResource = this.createXTextConstraintResource();
        xTextResource.load((InputStream)new StringInputStream(objectText), null);
        return xTextResource;
    }

    public XtextResource createOSSResourceFromFile(String path) {
        XtextResourceSet resourceSet = (XtextResourceSet)this.getOssInjector().getInstance(XtextResourceSet.class);
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.FALSE);
        return (XtextResource)resourceSet.getResource(URI.createFileURI((String)path), true);
    }

    public XtextResource createNuXmvResourceFromFile(String path) {
        XtextResourceSet resourceSet = (XtextResourceSet)this.getNuSMVInjector().getInstance(XtextResourceSet.class);
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.FALSE);
        return (XtextResource)resourceSet.getResource(URI.createFileURI((String)path), true);
    }

    public Injector getOssInjector() {
        if (this.ossInjector == null) {
            this.ossInjector = OssActivator.getInstance().getInjector("eu.fbk.tools.editor.oss.Oss");
        }
        return this.ossInjector;
    }

    public Injector getContractInjector() {
        if (this.contractInjector == null) {
            this.contractInjector = ContractActivator.getInstance().getInjector("eu.fbk.tools.editor.contract.Contract");
        }
        return this.contractInjector;
    }

    public Injector getConstraintInjector() {
        if (this.constraintInjector == null) {
            this.constraintInjector = ConstraintActivator.getInstance().getInjector("eu.fbk.tools.editor.contract.constraint.Constraint");
        }
        return this.constraintInjector;
    }

    public Injector getExpressionInjector() {
        if (this.expressionInjector == null) {
            this.expressionInjector = ExpressionActivator.getInstance().getInjector("eu.fbk.tools.editor.contract.expression.Expression");
        }
        return this.expressionInjector;
    }

    public Injector getNuSMVInjector() {
        if (this.nuSMVInjector == null) {
            this.nuSMVInjector = NusmvActivator.getInstance().getInjector("eu.fbk.tools.editor.nusmv.NuSMV");
        }
        return this.nuSMVInjector;
    }

    public Injector getBaseTypeInjector() {
        if (this.baseTypeInjector == null) {
            this.baseTypeInjector = BasetypeActivator.getInstance().getInjector("eu.fbk.tools.editor.basetype.BaseType");
        }
        return this.baseTypeInjector;
    }

    public Injector getCleanCInjector() {
        if (this.cleanCInjector == null) {
            this.cleanCInjector = CActivator.getInstance().getInjector("eu.fbk.tools.editor.c.C");
        }
        return this.cleanCInjector;
    }

    public Injector getCleanCStatementInjector() {
        if (this.cleanCStatementInjector == null) {
            this.cleanCStatementInjector = StatementActivator.getInstance().getInjector("eu.fbk.tools.editor.c.statement.Statement");
        }
        return this.cleanCStatementInjector;
    }

    public Injector getCleanCExpressionInjector() {
        if (this.cleanCExpressionInjector == null) {
            this.cleanCExpressionInjector = eu.fbk.tools.editor.c.expression.ui.internal.ExpressionActivator.getInstance().getInjector("eu.fbk.tools.editor.c.expression.Expression");
        }
        return this.cleanCExpressionInjector;
    }

    public XtextResource createXTextConstraintResource() {
        ConstraintResourceProvider serviceProvider = (ConstraintResourceProvider)this.getConstraintInjector().getInstance(ConstraintResourceProvider.class);
        return serviceProvider.createResource();
    }

    public XtextResource createXTextCleanCExpressionResource() {
        ExpressionResourceProvider serviceProvider = (ExpressionResourceProvider)this.getCleanCExpressionInjector().getInstance(ExpressionResourceProvider.class);
        return serviceProvider.createResource();
    }

    public XtextResource createXTextExpressionResource() {
        ExpressionResourceProvider serviceProvider = (ExpressionResourceProvider)this.getExpressionInjector().getInstance(ExpressionResourceProvider.class);
        return serviceProvider.createResource();
    }

    public eu.fbk.tools.editor.c.expression.expression.Expression deserializeCleanCExpression(String expression) throws Exception {
        Injector injector = this.getCleanCExpressionInjector();
        ParseHelper exprParseHelper = (ParseHelper)injector.getInstance(ParseHelper.class);
        return (eu.fbk.tools.editor.c.expression.expression.Expression)exprParseHelper.parse((CharSequence)expression);
    }

    public Statement deserializeCleanCStatement(String statement) throws Exception {
        Injector injector = this.getCleanCStatementInjector();
        return (Statement)this.parse(injector, statement);
    }

    public Model deserializeSmvModel(String smvModel) throws Exception {
        Injector injector = this.getNuSMVInjector();
        return (Model)this.parse(injector, smvModel);
    }

    public EObject deserializeBaseType(String baseType) throws Exception {
        Injector injector = this.getBaseTypeInjector();
        return this.parse(injector, baseType);
    }

    public PortConstraint deserializeOCRAConstraint(String constraint) throws Exception {
        Injector injector = this.getConstraintInjector();
        return (PortConstraint)this.parse(injector, constraint);
    }

    public BoundedExpression deserializeOCRABoundedExpression(String expression) throws Exception {
        Injector injector = this.getExpressionInjector();
        return (BoundedExpression)this.parse(injector, expression);
    }

    public Expression deserializeBaseTypeExpression(String expression) throws Exception {
        Injector injector = this.getExpressionInjector();
        return (Expression)this.parse(injector, expression);
    }

    public Contracts deserializeContracts(String contracts) throws Exception {
        Injector injector = this.getContractInjector();
        return (Contracts)this.parse(injector, contracts);
    }

    public OSS deserializeOss(String ossModel) throws Exception {
        Injector injector = this.getOssInjector();
        return (OSS)this.parse(injector, ossModel);
    }

    private EObject parse(Injector injector, String string) throws Exception {
        ParseHelper exprParseHelper = (ParseHelper)injector.getInstance(ParseHelper.class);
        return exprParseHelper.parse((CharSequence)string);
    }
}

