/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.parsers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OperationTemplateParameter;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.UMLPackage;

public class TemplateParameterParser
implements IParser {
    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        UnexecutableCommand command = UnexecutableCommand.INSTANCE;
        EObject e = (EObject)element.getAdapter(EObject.class);
        if (e != null) {
            TemplateParameter templateParam = (TemplateParameter)e;
            if (newString.contains("<UNDEFINED>")) {
                return UnexecutableCommand.INSTANCE;
            }
            if (templateParam.getParameteredElement() instanceof NamedElement) {
                NamedElement namedElement = (NamedElement)templateParam.getParameteredElement();
                String name = newString.substring(0, newString.indexOf(":"));
                SetRequest request = new SetRequest((EObject)namedElement, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)name.trim());
                command = new SetValueCommand(request);
            }
        }
        return command;
    }

    public String getPrintString(IAdaptable element, int flags) {
        EObject e = (EObject)element.getAdapter(EObject.class);
        if (e != null) {
            TemplateParameter templateParam = (TemplateParameter)e;
            if (templateParam.getParameteredElement() == null) {
                return "<UNDEFINED>";
            }
            String out = "";
            if (templateParam.getParameteredElement() instanceof NamedElement) {
                NamedElement namedElement = (NamedElement)templateParam.getParameteredElement();
                out = String.valueOf(namedElement.getName()) + ": " + namedElement.eClass().getName();
            }
            if (templateParam instanceof OperationTemplateParameter) {
                if (templateParam.getParameteredElement() != null) {
                    Operation op = (Operation)templateParam.getParameteredElement();
                    out = this.displayOperation(op);
                }
            } else if (templateParam instanceof ClassifierTemplateParameter && !((ClassifierTemplateParameter)templateParam).getConstrainingClassifiers().isEmpty()) {
                out = String.valueOf(out) + ">";
                int i = 0;
                while (i < ((ClassifierTemplateParameter)templateParam).getConstrainingClassifiers().size()) {
                    out = String.valueOf(out) + ((Classifier)((ClassifierTemplateParameter)templateParam).getConstrainingClassifiers().get(i)).getName();
                    if (i < ((ClassifierTemplateParameter)templateParam).getConstrainingClassifiers().size() - 1) {
                        out = String.valueOf(out) + ", ";
                    }
                    ++i;
                }
            }
            if (templateParam.getDefault() instanceof Operation) {
                out = String.valueOf(out) + "=" + this.displayOperation((Operation)templateParam.getDefault());
            } else if (templateParam.getDefault() instanceof NamedElement) {
                out = String.valueOf(out) + "=" + ((NamedElement)templateParam.getDefault()).getName();
            }
            return out;
        }
        return "<UNDEFINED>";
    }

    protected String displayOperation(Operation op) {
        String out = String.valueOf(op.getName()) + "(";
        for (Parameter param : op.getOwnedParameters()) {
            out = String.valueOf(out) + param.getName();
            if (param.equals(op.getOwnedParameters().get(op.getOwnedParameters().size() - 1))) continue;
            out = String.valueOf(out) + ", ";
        }
        out = String.valueOf(out) + ")";
        return out;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return true;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

