/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.ui.services;

import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.services.OSSTranslatorServiceAPI;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.ui.utils.OCRATranslatorDialogUtil;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.xtextService.ui.services.RuntimeErrorService;
import eu.fbk.tools.editor.oss.oss.OSS;
import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;

public class OSSTranslatorServiceUI {
    private static final Logger logger = Logger.getLogger(OSSTranslatorServiceUI.class);
    private static OSSTranslatorServiceUI ocraTranslatorService;
    private OCRATranslatorDialogUtil ocraTranslatorDialogUtil = OCRATranslatorDialogUtil.getInstance();
    private RuntimeErrorService runtimeErrorService = RuntimeErrorService.getInstance();
    private OSSTranslatorServiceAPI ossTranslatorServiceAPI;

    public static OSSTranslatorServiceUI getInstance(AbstractSystemModel abstractSystemModel) {
        if (ocraTranslatorService == null) {
            ocraTranslatorService = new OSSTranslatorServiceUI(abstractSystemModel);
        }
        return ocraTranslatorService;
    }

    private OSSTranslatorServiceUI(AbstractSystemModel abstractSystemModel) {
        this.ossTranslatorServiceAPI = OSSTranslatorServiceAPI.getInstance(abstractSystemModel);
    }

    public File exportRootComponentToOssFile(Object umlSelectedComponent, Resource componentResource, int timeSpecification, boolean isAsyncCommunication, boolean usexTextValidation, boolean showPopups, String ossDirPath, IProgressMonitor monitor) throws Exception {
        logger.debug((Object)"exportRootComponentAsOssModel");
        OSS ocraModel = this.ossTranslatorServiceAPI.exportRootComponentToOssModel(umlSelectedComponent, timeSpecification, isAsyncCommunication, monitor);
        logger.debug((Object)"generateOssFileFromOssModel");
        String fileName = this.ossTranslatorServiceAPI.getFileName(umlSelectedComponent);
        File ossFile = this.exportOSSModelToOSSFile(ocraModel, componentResource, fileName, ossDirPath, usexTextValidation, showPopups, monitor);
        return ossFile;
    }

    public File exportOSSModelToOSSFile(Object ossModel, Resource componentResource, String fileName, String ossDirPath, boolean usexTextValidation, boolean showPopups, IProgressMonitor monitor) throws Exception {
        boolean isValid;
        File ossFile = this.ossTranslatorServiceAPI.exportOSSModelToOSSFile(ossModel, fileName, ossDirPath);
        if (showPopups) {
            this.ocraTranslatorDialogUtil.showMessage_ExportArchitectureDone(ossFile.getAbsolutePath());
        }
        if (!(isValid = this.runtimeErrorService.showOSSRuntimeErrors(ossFile, componentResource, usexTextValidation, showPopups, monitor))) {
            return null;
        }
        return ossFile;
    }
}

