/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.services;

import com.google.inject.Injector;
import eu.fbk.eclipse.standardtools.utils.core.parser.ParseHelper;
import eu.fbk.eclipse.standardtools.utils.core.utils.FileSystemUtil;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XTextResourceUtil;
import eu.fbk.tools.editor.oss.oss.OSS;
import java.io.File;

public class OSSModelFactory {
    public static OSSModelFactory ossModelFactory;
    private XTextResourceUtil xTextResourceUtil = XTextResourceUtil.getInstance();

    public static OSSModelFactory getInstance() {
        if (ossModelFactory == null) {
            ossModelFactory = new OSSModelFactory();
        }
        return ossModelFactory;
    }

    public OSS createOssModel(File ossFile) throws Exception {
        String ossDefinition = FileSystemUtil.getFileContent((File)ossFile);
        return this.createOssResource(ossDefinition);
    }

    public OSS createOssResource() throws Exception {
        String ossDefinition = "COMPONENT system";
        return this.createOssResource(ossDefinition);
    }

    private OSS createOssResource(String ossDefinition) throws Exception {
        Injector injector = this.xTextResourceUtil.getOssInjector();
        ParseHelper parseHelper = (ParseHelper)injector.getInstance(ParseHelper.class);
        OSS result = (OSS)parseHelper.parse((CharSequence)ossDefinition);
        return result;
    }
}

