/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.modelTranslators;

import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.exceptions.EmptyEnumTypeException;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.exceptions.NullTypeException;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.exceptions.UnexpectedTypeException;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.services.OSSModelFactory;
import eu.fbk.eclipse.standardtools.utils.core.exceptions.NoComponentException;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.core.utils.Pair;
import eu.fbk.eclipse.standardtools.utils.core.utils.StringArrayUtil;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XTextResourceUtil;
import eu.fbk.tools.editor.basetype.baseType.BaseTypeFactory;
import eu.fbk.tools.editor.basetype.baseType.EnumType;
import eu.fbk.tools.editor.basetype.baseType.EventType;
import eu.fbk.tools.editor.basetype.baseType.Expression;
import eu.fbk.tools.editor.basetype.baseType.FixedSizeArrayType;
import eu.fbk.tools.editor.basetype.baseType.Identifier;
import eu.fbk.tools.editor.basetype.baseType.IntegerLiteral;
import eu.fbk.tools.editor.basetype.baseType.RangeType;
import eu.fbk.tools.editor.basetype.baseType.SimpleType;
import eu.fbk.tools.editor.contract.constraint.constraint.PortConstraint;
import eu.fbk.tools.editor.contract.contract.Contract;
import eu.fbk.tools.editor.contract.contract.Contracts;
import eu.fbk.tools.editor.contract.expression.expression.ArrayIndex;
import eu.fbk.tools.editor.contract.expression.expression.ComponentId;
import eu.fbk.tools.editor.contract.expression.expression.ExpressionFactory;
import eu.fbk.tools.editor.contract.expression.expression.FullPortId;
import eu.fbk.tools.editor.contract.expression.expression.FullVariableId;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBound;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBounds;
import eu.fbk.tools.editor.contract.expression.expression.ParameterId;
import eu.fbk.tools.editor.contract.expression.expression.PortId;
import eu.fbk.tools.editor.contract.expression.expression.VariableId;
import eu.fbk.tools.editor.oss.oss.Assertion;
import eu.fbk.tools.editor.oss.oss.ComplexType;
import eu.fbk.tools.editor.oss.oss.Component;
import eu.fbk.tools.editor.oss.oss.Connection;
import eu.fbk.tools.editor.oss.oss.Define;
import eu.fbk.tools.editor.oss.oss.FormulaConstraint;
import eu.fbk.tools.editor.oss.oss.FullContractIdList;
import eu.fbk.tools.editor.oss.oss.InputPort;
import eu.fbk.tools.editor.oss.oss.Interface;
import eu.fbk.tools.editor.oss.oss.InterfaceInstance;
import eu.fbk.tools.editor.oss.oss.IterativeCondition;
import eu.fbk.tools.editor.oss.oss.OSS;
import eu.fbk.tools.editor.oss.oss.OssFactory;
import eu.fbk.tools.editor.oss.oss.OutputPort;
import eu.fbk.tools.editor.oss.oss.Parameter;
import eu.fbk.tools.editor.oss.oss.ParameterAssumptions;
import eu.fbk.tools.editor.oss.oss.ParameterizedArrayType;
import eu.fbk.tools.editor.oss.oss.Port;
import eu.fbk.tools.editor.oss.oss.RefinedBy;
import eu.fbk.tools.editor.oss.oss.Refinement;
import eu.fbk.tools.editor.oss.oss.RefinementInstance;
import eu.fbk.tools.editor.oss.oss.SubComponent;
import eu.fbk.tools.editor.oss.oss.SubComponentType;
import eu.fbk.tools.editor.oss.oss.SystemComponent;
import eu.fbk.tools.editor.oss.oss.TimeAnnotation;
import eu.fbk.tools.editor.oss.oss.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class GenericModelToOSSModelTranslator {
    private static final Logger logger = Logger.getLogger(GenericModelToOSSModelTranslator.class);
    private final String language = "OCRA";
    private final OssFactory ossFactory = OssFactory.eINSTANCE;
    private final ExpressionFactory expressionFactory = ExpressionFactory.eINSTANCE;
    private final BaseTypeFactory baseTypeFactory = BaseTypeFactory.eINSTANCE;
    private XTextResourceUtil xtextResourceUtil = XTextResourceUtil.getInstance();
    private final OSSModelFactory ossModelFactory = OSSModelFactory.getInstance();
    private AbstractSystemModel abstractSystemModel;
    private static GenericModelToOSSModelTranslator toolToOCRAModelTranslatorAbstr;

    public static GenericModelToOSSModelTranslator getInstance(AbstractSystemModel abstractSystemModel) {
        if (toolToOCRAModelTranslatorAbstr == null) {
            toolToOCRAModelTranslatorAbstr = new GenericModelToOSSModelTranslator(abstractSystemModel);
        }
        return toolToOCRAModelTranslatorAbstr;
    }

    private GenericModelToOSSModelTranslator(AbstractSystemModel abstractSystemModel) {
        this.abstractSystemModel = abstractSystemModel;
    }

    private OSS compileOssFileFromRootComponent(Object component, List<?> contracts, int timeSpecification, boolean isAsyncCommunication) throws Exception {
        OSS ocraOssFile = this.ossModelFactory.createOssResource();
        boolean isDiscreteTime = false;
        if (timeSpecification != 0) {
            TimeAnnotation ocraTimeAnnotation = this.ossFactory.createTimeAnnotation();
            switch (timeSpecification) {
                case 2: {
                    ocraTimeAnnotation.setValue("timed-domain");
                    break;
                }
                case 1: {
                    ocraTimeAnnotation.setValue("discrete-time");
                    isDiscreteTime = true;
                }
            }
            ocraOssFile.setAnnotation(ocraTimeAnnotation);
        }
        SystemComponent ocraSystem = this.ossFactory.createSystemComponent();
        ocraOssFile.setSystem(ocraSystem);
        ocraSystem.setType(this.abstractSystemModel.getComponentTypeName(component));
        Interface ocraInterface_ = this.ossFactory.createInterface();
        ocraSystem.setInterface(ocraInterface_);
        this.compileComponent(component, contracts, ocraInterface_);
        Refinement ocraRefinement = this.ossFactory.createRefinement();
        if (isAsyncCommunication && this.abstractSystemModel.isAsyncComponent(component)) {
            ocraRefinement.setType("ASYNC");
        }
        this.compileSubcomponents(component, ocraRefinement);
        this.compileConnections(component, ocraRefinement, isDiscreteTime);
        this.compilePortsConstraints(component, ocraRefinement);
        this.compileContractRefinements(component, ocraRefinement);
        this.compileRefinementAssertions(component, ocraRefinement);
        if (!ocraRefinement.getRefinements().isEmpty()) {
            ocraSystem.setRefinement(ocraRefinement);
        }
        if (isAsyncCommunication && this.abstractSystemModel.isAsyncComponent(component)) {
            this.handleManyToOneConnections(component, ocraRefinement, isDiscreteTime);
            this.handleChangeEvents(component, ocraRefinement, isDiscreteTime);
            this.handleTimeEvents(component, ocraRefinement, isDiscreteTime);
        }
        ArrayList<Component> ocraChildComponents = new ArrayList<Component>();
        this.compileSubComponent(component, contracts, ocraChildComponents, isDiscreteTime, isAsyncCommunication);
        ocraOssFile.getComponents().addAll(ocraChildComponents);
        return ocraOssFile;
    }

    private void handleTimeEvents(Object component, Refinement ocraRefinement, boolean isDiscreteTime) throws Exception {
        EList events = this.abstractSystemModel.getTimeEvents(component);
        for (Object event : events) {
            String period = this.abstractSystemModel.getTimeEventPeriod(event);
            String[] stringArray = this.abstractSystemModel.getSubComponentsName(component);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String subcomponentName = stringArray[n2];
                Object subComponent = this.abstractSystemModel.getSubComponent(component, subcomponentName);
                if (this.abstractSystemModel.isSubComponentTriggeredByEvent(subComponent, event)) {
                    FormulaConstraint formulaConstraint = this.createTimeEventConstraint(subcomponentName, period, isDiscreteTime);
                    RefinementInstance ocraRefInstance = this.ossFactory.createRefinementInstance();
                    ocraRefInstance.setFormula(formulaConstraint);
                    ocraRefinement.getRefinements().add((Object)ocraRefInstance);
                }
                ++n2;
            }
        }
    }

    private void handleChangeEvents(Object component, Refinement ocraRefinement, boolean isDiscreteTime) throws Exception {
        EList events = this.abstractSystemModel.getChangeEvents(component);
        for (Object event : events) {
            String expression = this.abstractSystemModel.getChangeEventExpression(event);
            if (expression == null) continue;
            String[] stringArray = this.abstractSystemModel.getSubComponentsName(component);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String subcomponentName = stringArray[n2];
                Object subComponent = this.abstractSystemModel.getSubComponent(component, subcomponentName);
                if (this.abstractSystemModel.isSubComponentTriggeredByEvent(subComponent, event)) {
                    FormulaConstraint formulaConstraint = this.createChangeEventConstraint(subcomponentName, expression, isDiscreteTime);
                    RefinementInstance ocraRefInstance = this.ossFactory.createRefinementInstance();
                    ocraRefInstance.setFormula(formulaConstraint);
                    ocraRefinement.getRefinements().add((Object)ocraRefInstance);
                }
                ++n2;
            }
        }
    }

    private FormulaConstraint createTimeEventConstraint(String subcomponentName, String period, boolean isDiscreteTime) throws Exception {
        String expression;
        FormulaConstraint formulaConstraint = this.ossFactory.createFormulaConstraint();
        if (isDiscreteTime) {
            int intPeriod = Integer.valueOf(period);
            String previousPeriod = String.valueOf(intPeriod - 1);
            expression = "F [ 0 , " + previousPeriod + "] ( not " + subcomponentName + ".stutter ) and always ( ( not " + subcomponentName + ".stutter) " + "implies X (" + subcomponentName + ".stutter U [ " + previousPeriod + " , " + previousPeriod + "] ( not " + subcomponentName + ".stutter ) ) ) ) ;";
        } else {
            expression = "always (time_until(next(true) and not " + subcomponentName + ".stutter) < " + period + "); ";
        }
        Expression boundExpr = this.stringToOcraExpression(expression);
        formulaConstraint.setConstraint(boundExpr);
        return formulaConstraint;
    }

    private FormulaConstraint createChangeEventConstraint(String subcomponentName, String changeExpr, boolean isDiscreteTime) throws Exception {
        FormulaConstraint formulaConstraint = this.ossFactory.createFormulaConstraint();
        String expression = isDiscreteTime ? "always ((" + changeExpr + ") implies then (!" + subcomponentName + ".stutter))" : "always (" + changeExpr + ") implies (!" + subcomponentName + ".stutter and next(true))";
        Expression boundExpr = this.stringToOcraExpression(expression);
        formulaConstraint.setConstraint(boundExpr);
        return formulaConstraint;
    }

    private void compileRefinementAssertions(Object component, Refinement ocraRefinement) throws Exception {
        ArrayList<RefinementInstance> ocraRefInstances = new ArrayList<RefinementInstance>();
        EList refinementAssertions = this.abstractSystemModel.getRefinementAssertions(component);
        if (refinementAssertions != null) {
            for (Object refinementAssertion : refinementAssertions) {
                RefinementInstance ocraRefInstance = this.ossFactory.createRefinementInstance();
                Assertion ocraRefinementAssertion = this.ossFactory.createAssertion();
                this.compileRefinementAssertionExpression(ocraRefinementAssertion, refinementAssertion);
                ocraRefInstance.setAssertion(ocraRefinementAssertion);
                ocraRefInstances.add(ocraRefInstance);
            }
        }
        ocraRefinement.getRefinements().addAll(ocraRefInstances);
    }

    public OSS exportRootComponentAsOssModel(Object rootComponent, int timeSpecification, boolean isAsyncCommunication, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Export system model as Oss Model", 1);
        logger.debug((Object)"beginTask: Export system model as Oss Model ");
        if (rootComponent == null) {
            throw new NoComponentException();
        }
        logger.debug((Object)"getContractsOfComponent");
        EList contracts = this.abstractSystemModel.getContractsOfComponent(rootComponent);
        logger.debug((Object)"compileOssFileFromRootComponent");
        OSS ocraModel = this.compileOssFileFromRootComponent(rootComponent, (List<?>)contracts, timeSpecification, isAsyncCommunication);
        logger.debug((Object)"compileOssFileFromRootComponent done");
        monitor.done();
        logger.debug((Object)"done: Export system model as Oss Model ");
        return ocraModel;
    }

    public String getFileName(Object component) {
        return this.abstractSystemModel.getComponentName(component);
    }

    private void compileOutputports(List<InterfaceInstance> ocraPorts, EList<?> outputPorts, String componentName) throws Exception {
        for (Object outputPort : outputPorts) {
            OutputPort ocraOutputPort = this.ossFactory.createOutputPort();
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setVariable((Variable)ocraOutputPort);
            ocraPorts.add(interfaceInstance);
            String portName = this.abstractSystemModel.getPortName(outputPort);
            PortId varId = this.expressionFactory.createPortId();
            varId.setName(portName);
            ocraOutputPort.setId((VariableId)varId);
            this.compilePortType(outputPort, componentName, portName, (Port)ocraOutputPort);
        }
    }

    private FullPortId createFullPortId(Pair<String, String> portInfo) {
        FullPortId ocraPortId = this.expressionFactory.createFullPortId();
        PortId varId = this.expressionFactory.createPortId();
        varId.setName((String)portInfo.getRight());
        ocraPortId.setId((VariableId)varId);
        if (portInfo.getLeft() != null) {
            ComponentId componentName = this.expressionFactory.createComponentId();
            componentName.setName((String)portInfo.getLeft());
            ocraPortId.getFullComponentIds().add((Object)componentName);
        }
        return ocraPortId;
    }

    private void compileInterfaceAssertions(List<InterfaceInstance> ocraInterfaceAssertions, EList<?> interfaceAssertions) throws Exception {
        for (Object interfaceAssertion : interfaceAssertions) {
            Assertion ocraInterfaceAssertion = this.ossFactory.createAssertion();
            this.compileInterfaceAssertionExpression(ocraInterfaceAssertion, interfaceAssertion);
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setAssertion(ocraInterfaceAssertion);
            ocraInterfaceAssertions.add(interfaceInstance);
        }
    }

    private void compileInterfaceAssertionExpression(Assertion ocraInterfaceAssertion, Object interfaceAssertion) throws Exception {
        String intAssertionName = this.abstractSystemModel.getInterfaceAssertionName(interfaceAssertion);
        ocraInterfaceAssertion.setName(intAssertionName);
        String assertionBody = this.abstractSystemModel.getInterfaceAssertionBody(interfaceAssertion, "OCRA");
        ocraInterfaceAssertion.setConstraint(this.stringToOcraExpression(assertionBody));
    }

    private void compileRefinementAssertionExpression(Assertion ocraRefinementAssertion, Object refinementAssertion) throws Exception {
        String refAssertionName = this.abstractSystemModel.getRefinementAssertionName(refinementAssertion);
        ocraRefinementAssertion.setName(refAssertionName);
        ocraRefinementAssertion.setConstraint(this.stringToOcraExpression(this.abstractSystemModel.getRefinementAssertionBody(refinementAssertion, "OCRA")));
    }

    private void compileInputPorts(List<InterfaceInstance> ocraPorts, EList<?> inputPorts, String componentName) throws Exception {
        for (Object inputPort : inputPorts) {
            InputPort ocraInputPort = this.ossFactory.createInputPort();
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setVariable((Variable)ocraInputPort);
            ocraPorts.add(interfaceInstance);
            String portName = this.abstractSystemModel.getPortName(inputPort);
            PortId portId = this.expressionFactory.createPortId();
            portId.setName(portName);
            ocraInputPort.setId((VariableId)portId);
            this.compilePortType(inputPort, componentName, portName, (Port)ocraInputPort);
        }
    }

    private void compileGenericPorts(List<InterfaceInstance> ocraPorts, EList<?> genericPorts, String componentName) throws Exception {
        logger.debug((Object)"For the moment, generic ports (with inout type) are converted in input ports");
        for (Object genericPort : genericPorts) {
            InputPort ocraGenericPort = this.ossFactory.createInputPort();
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setVariable((Variable)ocraGenericPort);
            ocraPorts.add(interfaceInstance);
            String portName = this.abstractSystemModel.getPortName(genericPort);
            PortId varId = this.expressionFactory.createPortId();
            varId.setName(portName);
            ocraGenericPort.setId((VariableId)varId);
            this.compilePortType(genericPort, componentName, portName, (Port)ocraGenericPort);
        }
    }

    private void compileStaticPorts(List<InterfaceInstance> ocraParameters, EList<?> staticPorts, String componentName) throws Exception {
        for (Object staticPort : staticPorts) {
            Parameter ocraParameter = this.ossFactory.createParameter();
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setVariable((Variable)ocraParameter);
            ocraParameters.add(interfaceInstance);
            String staticPortName = this.abstractSystemModel.getPortName(staticPort);
            ParameterId varId = this.expressionFactory.createParameterId();
            varId.setName(staticPortName);
            ocraParameter.setId((VariableId)varId);
            this.compileStaticPortType(staticPort, componentName, staticPortName, ocraParameter);
        }
    }

    private void compileDefines(List<InterfaceInstance> ocraDefines, EList<?> defines) throws Exception {
        for (Object define : defines) {
            Define ocraDefine = this.ossFactory.createDefine();
            this.compileDefineExpression(ocraDefine, define);
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setDefine(ocraDefine);
            ocraDefines.add(interfaceInstance);
        }
    }

    private void compileDefineExpression(Define ocraDefine, Object define) throws Exception {
        String defineName = this.abstractSystemModel.getInterfaceAssertionName(define);
        ocraDefine.setName(defineName);
        String defineBody = this.abstractSystemModel.getInterfaceAssertionBody(define, "OCRA");
        ocraDefine.setConstraint(this.stringToOcraExpression(defineBody));
    }

    private void compileUninterpretedFunctions(List<InterfaceInstance> ocraParameters, EList<?> uninterpretedFunctions, String componentName) throws Exception {
        for (Object uninterpretedFunction : uninterpretedFunctions) {
            Parameter ocraParameter = this.ossFactory.createParameter();
            InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
            interfaceInstance.setVariable((Variable)ocraParameter);
            ocraParameters.add(interfaceInstance);
            Object outputType = this.abstractSystemModel.getUninterpretedFunctionOutputType(uninterpretedFunction);
            EList inputTypes = this.abstractSystemModel.getUninterpretedFunctionInputTypes(uninterpretedFunction);
            String[] outputMultiplicity = this.abstractSystemModel.getUninterpretedFunctionOutputMultiplicity(uninterpretedFunction);
            EList inputMultiplicities = this.abstractSystemModel.getUninterpretedFunctionInputMultiplicities(uninterpretedFunction);
            String uninterpretedFunctionName = this.abstractSystemModel.getUninterpretedFunctionName(uninterpretedFunction);
            ParameterId varId = this.expressionFactory.createParameterId();
            varId.setName(uninterpretedFunctionName);
            ocraParameter.setId((VariableId)varId);
            this.compileUninterpretedFunctionType(outputType, outputMultiplicity, componentName, uninterpretedFunctionName, ocraParameter);
            this.compileUninterpretedFunctionParameters(inputTypes, (EList<String[]>)inputMultiplicities, componentName, uninterpretedFunctionName, ocraParameter);
        }
    }

    private void compileComponent(Object component, List<?> contracts, Interface ocraInterface_) throws Exception {
        EList parameters;
        EList outputPorts;
        EList genericPorts;
        String componentName = this.abstractSystemModel.getComponentName(component);
        ArrayList<InterfaceInstance> ocraPorts = new ArrayList<InterfaceInstance>();
        EList inputPorts = this.abstractSystemModel.getNonStaticInputPorts(component);
        if (inputPorts != null && inputPorts.size() != 0) {
            this.compileInputPorts(ocraPorts, inputPorts, componentName);
        }
        if ((genericPorts = this.abstractSystemModel.getNonStaticGenericPorts(component)) != null && genericPorts.size() != 0) {
            this.compileGenericPorts(ocraPorts, genericPorts, componentName);
        }
        if ((outputPorts = this.abstractSystemModel.getNonStaticOutputPorts(component)) != null && outputPorts.size() != 0) {
            this.compileOutputports(ocraPorts, outputPorts, componentName);
        }
        if ((parameters = this.abstractSystemModel.getStaticPorts(component)) != null && parameters.size() != 0) {
            this.compileStaticPorts(ocraPorts, parameters, componentName);
        }
        ocraInterface_.getInterfaces().addAll(ocraPorts);
        ArrayList<InterfaceInstance> ocraDefines = new ArrayList<InterfaceInstance>();
        EList defines = this.abstractSystemModel.getDefines(component);
        if (defines != null && defines.size() != 0) {
            this.compileDefines(ocraDefines, defines);
        }
        ocraInterface_.getInterfaces().addAll(ocraDefines);
        ArrayList<InterfaceInstance> ocraParameters = new ArrayList<InterfaceInstance>();
        EList uninterpretedFunctions = this.abstractSystemModel.getUninterpretedFunctions(component);
        if (uninterpretedFunctions != null && uninterpretedFunctions.size() != 0) {
            this.compileUninterpretedFunctions(ocraParameters, uninterpretedFunctions, componentName);
        }
        ocraInterface_.getInterfaces().addAll(ocraParameters);
        ArrayList<InterfaceInstance> ocraInterfaceAssertions = new ArrayList<InterfaceInstance>();
        EList interfaceAssertions = this.abstractSystemModel.getInterfaceAssertions(component);
        if (interfaceAssertions != null && interfaceAssertions.size() != 0) {
            this.compileInterfaceAssertions(ocraInterfaceAssertions, interfaceAssertions);
        }
        ocraInterface_.getInterfaces().addAll(ocraInterfaceAssertions);
        this.compileParameterAssumptions(component, ocraInterface_);
        ArrayList<InterfaceInstance> ocraContractsToAdd = new ArrayList<InterfaceInstance>();
        ArrayList<Contract> ossContracts = new ArrayList<Contract>(this.getOSSContractDefinitions(component));
        if (ossContracts != null && !ossContracts.isEmpty()) {
            int i = 0;
            while (i < ossContracts.size()) {
                Contract ocraContract = (Contract)ossContracts.get(i);
                InterfaceInstance interfaceInstance = this.ossFactory.createInterfaceInstance();
                interfaceInstance.setContract(ocraContract);
                ocraContractsToAdd.add(interfaceInstance);
                ++i;
            }
            ocraInterface_.getInterfaces().addAll(ocraContractsToAdd);
        }
    }

    private void compileParameterAssumptions(Object component, Interface ocraInterface) throws Exception {
        ArrayList<InterfaceInstance> ocraInterfaceInstances = new ArrayList<InterfaceInstance>();
        EList parameterAssumptions = this.abstractSystemModel.getParameterAssumptions(component);
        if (parameterAssumptions != null) {
            for (Object parameterAssumption : parameterAssumptions) {
                InterfaceInstance ocraIterfaceInstance = this.ossFactory.createInterfaceInstance();
                ParameterAssumptions ocraParameterAssumptions = this.ossFactory.createParameterAssumptions();
                this.compileParameterAssumptionsExpression(ocraParameterAssumptions, parameterAssumption);
                ocraIterfaceInstance.setParameterAssumptions(ocraParameterAssumptions);
                ocraInterfaceInstances.add(ocraIterfaceInstance);
            }
        }
        ocraInterface.getInterfaces().addAll(ocraInterfaceInstances);
    }

    private void compileParameterAssumptionsExpression(ParameterAssumptions ocraParameterAssumptions, Object parameterAssumption) throws Exception {
        String parameterAssumptionsText = this.abstractSystemModel.getParameterAssumptionsBody(parameterAssumption, "OCRA");
        logger.debug((Object)("getParameterAssumptionsBody: " + parameterAssumptionsText));
        ocraParameterAssumptions.setConstraint(this.stringToOcraExpression(parameterAssumptionsText));
    }

    private List<String> getOSSContractsNames(Object component) throws Exception {
        List<Contract> ossContracts = this.getOSSContractDefinitions(component);
        ArrayList<String> ossContractsNames = null;
        if (ossContracts != null && !ossContracts.isEmpty()) {
            ossContractsNames = new ArrayList<String>();
            for (Contract ossContract : ossContracts) {
                ossContractsNames.add(ossContract.getName());
            }
        }
        return ossContractsNames;
    }

    private List<Contract> getOSSContractDefinitions(Object component) throws Exception {
        String contractsInStr = this.abstractSystemModel.getContractDefinitionsText(component);
        return this.stringToOSSContracts(contractsInStr);
    }

    private EList<Contract> stringToOSSContracts(String contractDefinitions) throws Exception {
        if (contractDefinitions == null || contractDefinitions.isEmpty()) {
            return new BasicEList();
        }
        Contracts result = this.xtextResourceUtil.deserializeContracts(contractDefinitions);
        return result.getContracts();
    }

    private PortConstraint stringToOcraConstraint(String constraint) throws Exception {
        if (constraint == null || constraint.isEmpty()) {
            return null;
        }
        PortConstraint result = this.xtextResourceUtil.deserializeOCRAConstraint(constraint);
        return result;
    }

    private Expression stringToOcraExpression(String ocraInterfaceAssertionText) throws Exception {
        if (ocraInterfaceAssertionText == null || ocraInterfaceAssertionText.isEmpty()) {
            return null;
        }
        Expression result = this.xtextResourceUtil.deserializeBaseTypeExpression(ocraInterfaceAssertionText);
        return result;
    }

    private ArrayList<Object> getAllContractInstancesFromRefinementsOfConstracts(List<?> parentContracts) throws Exception {
        HashSet<Object> contractInstancesOfAllSubComponentsSet = new HashSet<Object>();
        if (parentContracts != null) {
            for (Object parentContract : parentContracts) {
                for (Object contractRefinement : this.abstractSystemModel.getContractRefinements(parentContract)) {
                    contractInstancesOfAllSubComponentsSet.add(this.abstractSystemModel.getContractInstanceOfContractRefinement(contractRefinement));
                }
            }
        }
        ArrayList<Object> contractInstancesOfAllSubComponentsList = new ArrayList<Object>(contractInstancesOfAllSubComponentsSet);
        return contractInstancesOfAllSubComponentsList;
    }

    private void compileSubComponent(Object parentComponent, List<?> parentContracts, List<Component> ocraChildComponents, boolean isDiscreteTime, boolean isAsyncCommunication) throws Exception {
        EList subComponents = this.abstractSystemModel.getSubComponentsInstances(parentComponent);
        if (subComponents.isEmpty()) {
            return;
        }
        ArrayList<Object> contractInstancesOfAllSubComponentsList = this.getAllContractInstancesFromRefinementsOfConstracts(parentContracts);
        for (Object subComponent : subComponents) {
            Component ocraChildComponent = this.ossFactory.createComponent();
            String componentInstanceTypeName = this.abstractSystemModel.getComponentInstanceTypeName(subComponent);
            if (!this.isValidName(componentInstanceTypeName)) {
                throw new Exception("The component's name '" + componentInstanceTypeName + "' contains invalid characters (e.g. '-').");
            }
            ocraChildComponent.setType(componentInstanceTypeName);
            List<Object> contractInstancesOfSubComponent = this.getContractInstancesOfComponent(subComponent, contractInstancesOfAllSubComponentsList);
            Interface ocraInterface_ = this.ossFactory.createInterface();
            ocraChildComponent.setInterface(ocraInterface_);
            this.compileComponent(subComponent, contractInstancesOfSubComponent, ocraInterface_);
            Refinement ocraSubComponentRefinement = this.ossFactory.createRefinement();
            if (isAsyncCommunication && this.abstractSystemModel.isAsyncComponent(subComponent)) {
                ocraSubComponentRefinement.setType("ASYNC");
            }
            this.compileSubcomponents(subComponent, ocraSubComponentRefinement);
            this.compileConnections(subComponent, ocraSubComponentRefinement, isDiscreteTime);
            this.compilePortsConstraints(subComponent, ocraSubComponentRefinement);
            this.compileContractRefinements(subComponent, ocraSubComponentRefinement);
            this.compileRefinementAssertions(subComponent, ocraSubComponentRefinement);
            if (!ocraSubComponentRefinement.getRefinements().isEmpty()) {
                ocraChildComponent.setRefinement(ocraSubComponentRefinement);
            }
            if (!this.contains(ocraChildComponents, ocraChildComponent)) {
                ocraChildComponents.add(ocraChildComponent);
            }
            if (isAsyncCommunication && this.abstractSystemModel.isAsyncComponent(subComponent)) {
                this.handleManyToOneConnections(subComponent, ocraSubComponentRefinement, isDiscreteTime);
                this.handleChangeEvents(subComponent, ocraSubComponentRefinement, isDiscreteTime);
                this.handleTimeEvents(subComponent, ocraSubComponentRefinement, isDiscreteTime);
            }
            this.compileSubComponent(subComponent, contractInstancesOfSubComponent, ocraChildComponents, isDiscreteTime, isAsyncCommunication);
        }
    }

    private boolean isValidName(String componentInstanceTypeName) {
        return !componentInstanceTypeName.contains("-");
    }

    private boolean contains(List<Component> components, Component component) {
        for (Component currComponent : components) {
            if (currComponent.getType().compareTo(component.getType()) != 0) continue;
            return true;
        }
        return false;
    }

    private void compilePortType(Object port, String componentName, String portName, Port ocraPort) throws Exception {
        Object type = this.abstractSystemModel.getPortType(port);
        SimpleType simplePortType = this.getTypeOfPort(type, componentName, portName);
        String[] portMultiplicityBoundariesAsExpressions = this.abstractSystemModel.getPortMultiplicityBoundaries(port);
        ocraPort.setType(this.createComplexType(simplePortType, portMultiplicityBoundariesAsExpressions, portName, componentName));
    }

    private ComplexType createComplexType(SimpleType simplePortType, String[] portMultiplicityBoundariesAsExpressions, String elementName, String componentName) throws Exception {
        ComplexType complexType = this.ossFactory.createComplexType();
        if (StringArrayUtil.isUndefined((String[])portMultiplicityBoundariesAsExpressions)) {
            logger.debug((Object)"isMultiplicityUndefined");
            complexType.setComplexType((EObject)simplePortType);
        } else if (StringArrayUtil.isSameValues((String[])portMultiplicityBoundariesAsExpressions)) {
            if (StringArrayUtil.isInteger((String)portMultiplicityBoundariesAsExpressions[1])) {
                FixedSizeArrayType arrayType = this.baseTypeFactory.createFixedSizeArrayType();
                arrayType.setType(simplePortType);
                IntegerLiteral integerLiteralMulitplicity = this.baseTypeFactory.createIntegerLiteral();
                integerLiteralMulitplicity.setValue(String.valueOf(portMultiplicityBoundariesAsExpressions[1]));
                arrayType.setNumber((EObject)integerLiteralMulitplicity);
                complexType.setComplexType((EObject)arrayType);
            } else {
                ParameterizedArrayType arrayType = this.ossFactory.createParameterizedArrayType();
                arrayType.setType(simplePortType);
                Expression expr = this.stringToOcraExpression(portMultiplicityBoundariesAsExpressions[1]);
                arrayType.setNumber(expr);
                complexType.setComplexType((EObject)arrayType);
            }
        } else if (StringArrayUtil.isZeroNumber((String)portMultiplicityBoundariesAsExpressions[0]) && StringArrayUtil.isInteger((String)portMultiplicityBoundariesAsExpressions[1])) {
            FixedSizeArrayType arrayType = this.baseTypeFactory.createFixedSizeArrayType();
            arrayType.setType(simplePortType);
            IntegerLiteral integerLiteralMulitplicity = this.baseTypeFactory.createIntegerLiteral();
            integerLiteralMulitplicity.setValue(String.valueOf(Integer.parseInt(portMultiplicityBoundariesAsExpressions[1]) + 1));
            arrayType.setNumber((EObject)integerLiteralMulitplicity);
            complexType.setComplexType((EObject)arrayType);
        } else {
            throw new Exception("The element \"" + elementName + "\" of the component\"" + componentName + "\" cannot have different upper and lower values defined as expression.");
        }
        return complexType;
    }

    private void compileStaticPortType(Object parameter, String componentName, String portName, Parameter ocraParameter) throws Exception {
        Object type = this.abstractSystemModel.getPortType(parameter);
        String[] portMultiplicityBoundariesAsExpressions = this.abstractSystemModel.getPortMultiplicityBoundaries(parameter);
        SimpleType simplePortType = this.getTypeOfPort(type, componentName, portName);
        ComplexType complexType = this.createComplexType(simplePortType, portMultiplicityBoundariesAsExpressions, portName, componentName);
        ocraParameter.setType(complexType);
    }

    private void compileUninterpretedFunctionType(Object outputType, String[] multiplicity, String componentName, String uninterpretedFunctionName, Parameter ocraParameter) throws Exception {
        SimpleType simpleUninterpretedFunctionType = this.getTypeOfUninterpretedFunction(outputType, componentName, uninterpretedFunctionName);
        ComplexType complexUninterpretedFunctionType = this.createComplexType(simpleUninterpretedFunctionType, multiplicity, uninterpretedFunctionName, componentName);
        ocraParameter.setType(complexUninterpretedFunctionType);
    }

    private void compileUninterpretedFunctionParameters(EList<?> inputTypes, EList<String[]> inputMultiplicities, String componentName, String uninterpretedFunctionName, Parameter ocraParameter) throws Exception {
        if (inputTypes != null && inputTypes.size() > 0) {
            int i = 0;
            while (i < inputTypes.size()) {
                SimpleType simpleType = this.getTypeOfUninterpretedFunction(inputTypes.get(i), componentName, uninterpretedFunctionName);
                ComplexType complexUninterpretedFunctionType = this.createComplexType(simpleType, (String[])inputMultiplicities.get(i), uninterpretedFunctionName, componentName);
                ocraParameter.getParameters().add((Object)complexUninterpretedFunctionType);
                ++i;
            }
        }
    }

    private SimpleType getTypeOfPort(Object type, String componentName, String portName) throws Exception {
        try {
            return this.getSimpleType(type);
        }
        catch (EmptyEnumTypeException emptyEnumTypeException) {
            throw new Exception("In block \"" + componentName + "\", the port \"" + portName + "\" has one input type with an enumerator with zero values.");
        }
        catch (UnexpectedTypeException unexpectedTypeException) {
            logger.error((Object)"Unexpected parameter type ");
            throw new Exception("In block \"" + componentName + "\", the port \"" + portName + "\" has one parameter with unexpected type.");
        }
        catch (NullTypeException nullTypeException) {
            throw new Exception("In block \"" + componentName + "\", the port \"" + portName + "\" has one parameter with type == null.");
        }
    }

    private SimpleType getSimpleType(Object type) throws EmptyEnumTypeException, UnexpectedTypeException, NullTypeException {
        if (type == null) {
            throw new NullTypeException();
        }
        if (this.abstractSystemModel.isIntType(type)) {
            return this.baseTypeFactory.createIntegerType();
        }
        if (this.abstractSystemModel.isBooleanType(type)) {
            return this.baseTypeFactory.createBooleanType();
        }
        if (this.abstractSystemModel.isRealType(type)) {
            return this.baseTypeFactory.createRealType();
        }
        if (this.abstractSystemModel.isContinuousType(type)) {
            return this.baseTypeFactory.createContinuousType();
        }
        if (this.abstractSystemModel.isRangeType(type)) {
            RangeType rangeType = this.baseTypeFactory.createRangeType();
            String[] bounds = this.abstractSystemModel.getLowerUpperBoundsForRangeType(type);
            IntegerLiteral lowerBound = this.baseTypeFactory.createIntegerLiteral();
            lowerBound.setValue(bounds[0]);
            IntegerLiteral upperBound = this.baseTypeFactory.createIntegerLiteral();
            upperBound.setValue(bounds[1]);
            rangeType.setLowerBound((EObject)lowerBound);
            rangeType.setUpperBound((EObject)upperBound);
            return rangeType;
        }
        if (this.abstractSystemModel.isEnumType(type)) {
            EnumType enumType = this.baseTypeFactory.createEnumType();
            ArrayList<Identifier> enumValues = new ArrayList<Identifier>();
            String[] stringArray = this.abstractSystemModel.getValuesForEnumeratorType(type);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String enumValue = stringArray[n2];
                Identifier idLiteral = this.baseTypeFactory.createIdentifier();
                idLiteral.setValue(enumValue);
                enumValues.add(idLiteral);
                ++n2;
            }
            if (enumValues.isEmpty()) {
                throw new EmptyEnumTypeException();
            }
            enumType.getValues().addAll(enumValues);
            return enumType;
        }
        if (this.abstractSystemModel.isEventType(type)) {
            EventType eventType = this.baseTypeFactory.createEventType();
            return eventType;
        }
        throw new UnexpectedTypeException();
    }

    private SimpleType getTypeOfUninterpretedFunction(Object type, String componentName, String uninterpretedFunctionName) throws Exception {
        try {
            return this.getSimpleType(type);
        }
        catch (EmptyEnumTypeException emptyEnumTypeException) {
            throw new Exception("In block \"" + componentName + "\", the uninterpreted function \"" + uninterpretedFunctionName + "\" has one input type with an enumerator with zero values.");
        }
        catch (UnexpectedTypeException unexpectedTypeException) {
            logger.error((Object)"Unexpected parameter type ");
            throw new Exception("In block \"" + componentName + "\", the uninterpreted function \"" + uninterpretedFunctionName + "\" has one parameter with unexpected type.");
        }
        catch (NullTypeException nullTypeException) {
            throw new Exception("In block \"" + componentName + "\", the uninterpreted function \"" + uninterpretedFunctionName + "\" has one parameter with type == null.");
        }
    }

    private void compileSubcomponents(Object component, Refinement ocraRefinement) throws Exception {
        ArrayList<RefinementInstance> ocraRefInstances = new ArrayList<RefinementInstance>();
        EList children = this.abstractSystemModel.getSubComponentsInstances(component);
        if (children != null) {
            for (Object childComponentInstance : children) {
                RefinementInstance ocraRefInstance = this.ossFactory.createRefinementInstance();
                SubComponent ocraSubComponent = this.createSubComponent(childComponentInstance);
                ocraRefInstance.setSubcomponent(ocraSubComponent);
                ocraRefInstances.add(ocraRefInstance);
            }
        }
        ocraRefinement.getRefinements().addAll(ocraRefInstances);
    }

    private SubComponent createSubComponent(Object childComponentInstance) throws Exception {
        SubComponent ocraSubComponent = this.ossFactory.createSubComponent();
        SubComponentType ocraSubComponentType = this.ossFactory.createSubComponentType();
        String subCompNameStr = this.abstractSystemModel.getComponentInstanceName(childComponentInstance);
        String subCompTypeStr = this.abstractSystemModel.getComponentInstanceTypeName(childComponentInstance);
        String[] componentInstanceMultiplicityBoundaries = this.abstractSystemModel.getComponentInstanceMultiplicityBoundaries(childComponentInstance);
        logger.debug((Object)"createSubComponent");
        logger.debug((Object)("subCompNameStr: " + subCompNameStr));
        logger.debug((Object)("subCompTypeStr: " + subCompTypeStr));
        logger.debug((Object)("componentInstanceMultiplicityBoundaries: " + componentInstanceMultiplicityBoundaries[0] + " " + componentInstanceMultiplicityBoundaries[1]));
        ComponentId fullSubComponentId = this.expressionFactory.createComponentId();
        fullSubComponentId.setName(subCompNameStr);
        ocraSubComponent.setName(fullSubComponentId);
        ocraSubComponent.setType(ocraSubComponentType);
        if (StringArrayUtil.isUndefined((String[])componentInstanceMultiplicityBoundaries)) {
            logger.debug((Object)"isMultiplicityUndefined");
            ocraSubComponentType.setComponentTypeName(subCompTypeStr);
        } else if (StringArrayUtil.isSameValues((String[])componentInstanceMultiplicityBoundaries)) {
            logger.debug((Object)"isFixedSizeOfInstances");
            ocraSubComponentType.setArrayComponentTypeName(subCompTypeStr);
            ocraSubComponentType.setArraySize(this.stringToOcraExpression(componentInstanceMultiplicityBoundaries[1]));
        } else if (StringArrayUtil.isDifferentValues((String[])componentInstanceMultiplicityBoundaries)) {
            throw new Exception("The sub-component\"" + subCompNameStr + "\" cannot have different upper and lower values.");
        }
        return ocraSubComponent;
    }

    private void compileConnections(Object component, Refinement ocraRefinement, boolean isDiscreteTime) throws Exception {
        ArrayList<RefinementInstance> ocraRefInstances = new ArrayList<RefinementInstance>();
        ArrayList ocraRefInstancesFormulaConstraints = new ArrayList();
        EList connections = this.abstractSystemModel.getConnectionsPorts(component);
        if (connections != null) {
            for (Object connection : connections) {
                Object sourceConnector = this.abstractSystemModel.getConnectorSource(connection);
                Pair<String, String> ocraConstraintPortId = this.createFullPortIdFromConnector(sourceConnector, component);
                Object targetConnector = this.abstractSystemModel.getConnectorTarget(connection);
                Pair<String, String> ocraPortId = this.createFullPortIdFromConnector(targetConnector, component);
                Connection ocraConnection = this.ossFactory.createConnection();
                ocraConnection.setVariable((FullVariableId)this.createFullPortId(ocraPortId));
                ocraConnection.setConstraint((Expression)this.createFullPortId(ocraConstraintPortId));
                RefinementInstance ocraRefInstance = this.ossFactory.createRefinementInstance();
                ocraRefInstance.setConnection(ocraConnection);
                ocraRefInstances.add(ocraRefInstance);
            }
        }
        ocraRefinement.getRefinements().addAll(ocraRefInstances);
        ocraRefinement.getRefinements().addAll(ocraRefInstancesFormulaConstraints);
    }

    private void handleManyToOneConnections(Object component, Refinement ocraRefinement, boolean isDiscreteTime) throws Exception {
        ArrayList<RefinementInstance> ocraRefInstancesFormulaConstraints = new ArrayList<RefinementInstance>();
        EList refinementInstances = ocraRefinement.getRefinements();
        if (refinementInstances != null) {
            HashMap targetToSourceConnectionsMap = new HashMap();
            for (RefinementInstance refinementInstance : refinementInstances) {
                if (refinementInstance.getConnection() == null) continue;
                Connection connection = refinementInstance.getConnection();
                FullVariableId targetConnector = connection.getVariable();
                String targetComponentName = "";
                if (!targetConnector.getFullComponentIds().isEmpty()) {
                    targetComponentName = ((ComponentId)targetConnector.getFullComponentIds().get(0)).getName();
                }
                Pair ocraTargetPair = new Pair((Object)targetComponentName, (Object)targetConnector.getId().getName());
                if (!(connection.getConstraint() instanceof FullVariableId) || ((FullVariableId)connection.getConstraint()).getFullComponentIds().isEmpty()) continue;
                if (!targetToSourceConnectionsMap.containsKey(ocraTargetPair)) {
                    ArrayList<RefinementInstance> ports = new ArrayList<RefinementInstance>();
                    ports.add(refinementInstance);
                    targetToSourceConnectionsMap.put(ocraTargetPair, ports);
                    continue;
                }
                ((List)targetToSourceConnectionsMap.get(ocraTargetPair)).add(refinementInstance);
            }
            for (Map.Entry entry : targetToSourceConnectionsMap.entrySet()) {
                Pair targetPort = (Pair)entry.getKey();
                if (((List)entry.getValue()).size() == 1) continue;
                FormulaConstraint formulaConstraint = this.createAsyncWriteConstraint((Pair<String, String>)targetPort, (List)entry.getValue(), isDiscreteTime);
                RefinementInstance ocraRefInstance = this.ossFactory.createRefinementInstance();
                ocraRefInstance.setFormula(formulaConstraint);
                ocraRefInstancesFormulaConstraints.add(ocraRefInstance);
                refinementInstances.removeAll((Collection)entry.getValue());
            }
        }
        ocraRefinement.getRefinements().addAll(ocraRefInstancesFormulaConstraints);
    }

    private FormulaConstraint createAsyncWriteConstraint(Pair<String, String> targetPort, List<RefinementInstance> list, boolean isDiscreteTime) throws Exception {
        Pair<String, String> originPort;
        FormulaConstraint formulaConstraint = this.ossFactory.createFormulaConstraint();
        String expr = "always(";
        if (!isDiscreteTime) {
            expr = String.valueOf(expr) + "X TRUE implies ";
        }
        expr = String.valueOf(expr) + "(";
        boolean isFirstPort = true;
        for (RefinementInstance refinementInstance : list) {
            originPort = this.getPairPort(refinementInstance);
            if (((String)originPort.getLeft()).isEmpty()) continue;
            if (!isFirstPort) {
                expr = String.valueOf(expr) + " or ";
            }
            expr = String.valueOf(expr) + "! " + (String)originPort.getLeft() + ".stutter and next(" + this.pairToString(targetPort) + ") = next(" + this.pairToString(originPort) + ")";
            isFirstPort = false;
        }
        expr = String.valueOf(expr) + ")";
        expr = String.valueOf(expr) + " or (";
        isFirstPort = true;
        for (RefinementInstance refinementInstance : list) {
            originPort = this.getPairPort(refinementInstance);
            if (((String)originPort.getLeft()).isEmpty()) continue;
            if (!isFirstPort) {
                expr = String.valueOf(expr) + " and ";
            }
            expr = String.valueOf(expr) + (String)originPort.getLeft() + ".stutter ";
            isFirstPort = false;
        }
        expr = String.valueOf(expr) + "& next(" + this.pairToString(targetPort) + ") = " + this.pairToString(targetPort) + " ";
        expr = String.valueOf(expr) + ")";
        expr = String.valueOf(expr) + ");";
        Expression boundExpr = this.stringToOcraExpression(expr);
        formulaConstraint.setConstraint(boundExpr);
        return formulaConstraint;
    }

    private Pair<String, String> getPairPort(RefinementInstance refinementInstance) {
        FullVariableId connector = (FullVariableId)refinementInstance.getConnection().getConstraint();
        String sourceComponentName = "";
        if (!connector.getFullComponentIds().isEmpty()) {
            sourceComponentName = ((ComponentId)connector.getFullComponentIds().get(0)).getName();
        }
        Pair ocraSourcePair = new Pair((Object)sourceComponentName, (Object)connector.getId().getName());
        return ocraSourcePair;
    }

    private String pairToString(Pair<String, String> pair) {
        return String.valueOf(!((String)pair.getLeft()).isEmpty() ? String.valueOf((String)pair.getLeft()) + "." : "") + (String)pair.getRight();
    }

    private Pair<String, String> createFullPortIdFromConnector(Object connector, Object component) {
        String portName = this.abstractSystemModel.getConnectorEndName(connector);
        String componentName = null;
        Object owner = this.abstractSystemModel.getConnectorEndOwner(connector);
        if (owner != component && owner != null) {
            componentName = this.abstractSystemModel.getComponentInstanceName(owner);
        }
        return new Pair(componentName, (Object)portName);
    }

    private void compilePortsConstraints(Object component, Refinement ocraRefinement) throws Exception {
        ArrayList<RefinementInstance> ocraRefInstances = new ArrayList<RefinementInstance>();
        EList formulaConstraints = this.abstractSystemModel.getFormulaConstraints(component);
        if (formulaConstraints != null) {
            for (Object constraint : formulaConstraints) {
                String strConstraint = this.abstractSystemModel.getFormulaConstraintText(constraint);
                PortConstraint portConstraint = this.stringToOcraConstraint(strConstraint);
                Expression constraintExpression = portConstraint.getConstraint();
                FullVariableId ocraPortId = portConstraint.getVariable();
                IterativeCondition iterCondition = portConstraint.getIterativeCondition();
                Connection ocraConnection = this.ossFactory.createConnection();
                ocraConnection.setConstraint(constraintExpression);
                ocraConnection.setVariable((FullVariableId)((FullPortId)ocraPortId));
                ocraConnection.setIterativeCondition(iterCondition);
                RefinementInstance ocraRefInstance = this.ossFactory.createRefinementInstance();
                ocraRefInstance.setConnection(ocraConnection);
                ocraRefInstances.add(ocraRefInstance);
            }
        }
        ocraRefinement.getRefinements().addAll(ocraRefInstances);
    }

    private void compileContractRefinements(Object component, Refinement ocraRefinement) throws Exception {
        List<String> ossContractsNames = this.getOSSContractsNames(component);
        if (ossContractsNames == null || ossContractsNames.isEmpty()) {
            return;
        }
        for (String ossContractName : ossContractsNames) {
            Object refinedContract = this.abstractSystemModel.getContract(component, ossContractName);
            if (refinedContract == null) {
                throw new Exception("The contract " + ossContractName + " is not found in the component " + this.abstractSystemModel.getComponentName(component));
            }
            EList contractRefinements = this.abstractSystemModel.getContractRefinements(refinedContract);
            if (contractRefinements == null || contractRefinements.isEmpty()) continue;
            RefinementInstance ocraRefInstance = this.ossFactory.createRefinementInstance();
            RefinedBy ocraRefinedBy = this.ossFactory.createRefinedBy();
            ocraRefinedBy.setName(ossContractName);
            for (Object contractRefinement : contractRefinements) {
                EList componentsOfContractRefinement = this.abstractSystemModel.getComponentInstancesOfContractRefinement(contractRefinement);
                if (componentsOfContractRefinement == null || componentsOfContractRefinement.isEmpty()) {
                    throw new Exception("The refinement of the contract " + ossContractName + " of the element " + this.abstractSystemModel.getComponentName(component) + " has no components related to the contract instance");
                }
                ArrayList<String> componentInstancesNames = new ArrayList<String>();
                for (Object componentInstance : componentsOfContractRefinement) {
                    componentInstancesNames.add(this.abstractSystemModel.getComponentInstanceName(componentInstance));
                }
                Object contractInstanceOfContractRefinement = this.abstractSystemModel.getContractInstanceOfContractRefinement(contractRefinement);
                if (contractInstanceOfContractRefinement == null) {
                    throw new Exception("The refinement " + this.abstractSystemModel.getContractRefinementName(contractRefinement) + " of the element " + this.abstractSystemModel.getComponentName(component) + " has the contract instance == null");
                }
                String contractInstanceName = this.abstractSystemModel.getContractInstanceName(contractInstanceOfContractRefinement);
                String[] componentInstanceRange = this.abstractSystemModel.getComponentInstanceRangeOfContractRefinement(contractRefinement);
                FullContractIdList ocraContractId = this.createFullContractIdList(contractInstanceName, componentInstancesNames, componentInstanceRange);
                ocraRefinedBy.getFullContractIds().add((Object)ocraContractId);
            }
            ocraRefInstance.setRefinedby(ocraRefinedBy);
            ocraRefinement.getRefinements().add((Object)ocraRefInstance);
        }
    }

    private FullContractIdList createFullContractIdList(String contractInstanceName, List<String> componentInstancesNames, String[] componentInstanceRange) throws Exception {
        FullContractIdList ocraContractId = this.ossFactory.createFullContractIdList();
        ocraContractId.setName(contractInstanceName);
        int i = 0;
        while (i < componentInstancesNames.size()) {
            ArrayIndex arrayIndex;
            String componentInstanceName = componentInstancesNames.get(i);
            boolean isLastComponentInstance = i == componentInstancesNames.size() - 1;
            ComponentId componentName = this.expressionFactory.createComponentId();
            componentName.setName(componentInstanceName);
            if (StringArrayUtil.isSameValues((String[])componentInstanceRange)) {
                logger.debug((Object)"isFixedSizeOfInstances");
                Expression singleIndex = this.stringToOcraExpression(componentInstanceRange[1]);
                arrayIndex = this.expressionFactory.createArrayIndex();
                arrayIndex.setIndex(singleIndex);
                componentName.getIndexes().add((Object)arrayIndex);
            } else if (isLastComponentInstance && StringArrayUtil.isDifferentValues((String[])componentInstanceRange)) {
                logger.debug((Object)("isBoundedNumberOfInstances = " + componentInstanceRange[0] + " - " + componentInstanceRange[1]));
                Expression iteratorIndex = this.stringToOcraExpression("i");
                arrayIndex = this.expressionFactory.createArrayIndex();
                arrayIndex.setIndex(iteratorIndex);
                Expression lowerExpr = this.stringToOcraExpression(componentInstanceRange[0]);
                Expression upperExpr = this.stringToOcraExpression(componentInstanceRange[1]);
                IteratorBounds iteratorBounds = this.expressionFactory.createIteratorBounds();
                IteratorBound iterator = this.expressionFactory.createIteratorBound();
                iterator.setLowerBound(lowerExpr);
                iterator.setUpperBound(upperExpr);
                iterator.setLeftOperator("<=");
                iterator.setRightOperator("<=");
                iterator.setName("i");
                iteratorBounds.getBounds().add((Object)iterator);
                ocraContractId.getIteratorBounds().add((Object)iteratorBounds);
                componentName.getIndexes().add((Object)arrayIndex);
            }
            ocraContractId.getFullComponentIds().add((Object)componentName);
            ++i;
        }
        return ocraContractId;
    }

    private List<Object> getContractInstancesOfComponent(Object component, List<Object> contracts) throws Exception {
        ArrayList<Object> contractsOfComponent = new ArrayList<Object>();
        for (Object contract : contracts) {
            if (!this.abstractSystemModel.isContractInstanceOwnerEqualToComponent(contract, component)) continue;
            contractsOfComponent.add(contract);
        }
        return contractsOfComponent;
    }
}

