/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.ui.services;

import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.services.K2TranslatorServiceAPI;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;

public class K2ExportServiceUI {
    private static K2ExportServiceUI instance;
    private K2TranslatorServiceAPI k2TranslatorServiceAPI;
    private DialogUtil dialogUtil = DialogUtil.getInstance();

    public static K2ExportServiceUI getInstance(AbstractSystemModel abstractSystemModel, AbstractStateMachineModel abstractStateMachineModel) {
        if (instance == null) {
            instance = new K2ExportServiceUI(abstractSystemModel, abstractStateMachineModel);
        }
        return instance;
    }

    public K2ExportServiceUI(AbstractSystemModel abstractSystemModel, AbstractStateMachineModel abstractStateMachineModel) {
        this.k2TranslatorServiceAPI = K2TranslatorServiceAPI.getInstance(abstractSystemModel, abstractStateMachineModel);
    }

    public String exportSingleBlock(Object umlSelectedComponent, boolean showPopups, String fileName, String selectedDirectory, IProgressMonitor monitor) throws Exception {
        try {
            this.k2TranslatorServiceAPI.exportBlockToK2File(umlSelectedComponent, selectedDirectory, fileName, null, monitor);
        }
        catch (Exception e) {
            if (showPopups) {
                this.dialogUtil.showMessage_ExceptionError(e);
            }
            e.printStackTrace();
            return null;
        }
        if (showPopups) {
            this.dialogUtil.showMessage_ExportBehaviourDone(selectedDirectory, "k2");
        }
        return String.valueOf(selectedDirectory) + File.separator + fileName + ".k2";
    }
}

