/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.stateMachineModelTranslator.visitors.ast2Python;

import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.utils.PythonUtil;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ASTElement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AbsOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AdditionOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AndLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AndOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AssertStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.AssignStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Assignable;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Atom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Attribute;
import eu.fbk.eclipse.standardtools.ast.ASTElements.BinaryArithmeticOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.BinaryBitwiseOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.BinaryProposition;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Boolean;
import eu.fbk.eclipse.standardtools.ast.ASTElements.CaseStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.CastExpression;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ComplementOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstHexadecimal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstInteger;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstOctal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ConstReal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Context;
import eu.fbk.eclipse.standardtools.ast.ASTElements.CountOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.DeclarationStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.DivisionOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ElementOfList;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Equal;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Event;
import eu.fbk.eclipse.standardtools.ast.ASTElements.EventCall;
import eu.fbk.eclipse.standardtools.ast.ASTElements.EventRecept;
import eu.fbk.eclipse.standardtools.ast.ASTElements.FalsePredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForAllPredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForAllStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ForStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.FullyQualifiedSymbol;
import eu.fbk.eclipse.standardtools.ast.ASTElements.GreaterEqualThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.GreaterThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ITEStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ITStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ImpliesLogicOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.InputPort;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Integer;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LeftShiftOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LessEqualThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LessThan;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LocalAtom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.LocalVariable;
import eu.fbk.eclipse.standardtools.ast.ASTElements.MaxOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.MinOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ModuleOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.MultiplicationOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NegativeOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NotEqual;
import eu.fbk.eclipse.standardtools.ast.ASTElements.NotLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.OrLogicOP;
import eu.fbk.eclipse.standardtools.ast.ASTElements.OrOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.OutputPort;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Parameter;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ParameterList;
import eu.fbk.eclipse.standardtools.ast.ASTElements.ParameterListIterator;
import eu.fbk.eclipse.standardtools.ast.ASTElements.PositiveOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Predicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Real;
import eu.fbk.eclipse.standardtools.ast.ASTElements.RigthShiftOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SelfAtom;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SetLiteral;
import eu.fbk.eclipse.standardtools.ast.ASTElements.StateLiteral;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SubComponent;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SubtractionOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.SwitchCaseStatement;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Symbol;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TransitionEffect;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TransitionGuard;
import eu.fbk.eclipse.standardtools.ast.ASTElements.TruePredicate;
import eu.fbk.eclipse.standardtools.ast.ASTElements.UnaryArithmeticOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.UnaryBitwiseOp;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Variable;
import eu.fbk.eclipse.standardtools.ast.ASTElements.Void;
import eu.fbk.eclipse.standardtools.ast.ASTElements.XorOp;
import eu.fbk.eclipse.standardtools.ast.utils.AstElementExtractor;
import eu.fbk.eclipse.standardtools.ast.utils.AstUtils;
import eu.fbk.eclipse.standardtools.ast.visitors.ast.CachedAstVisitorAction;
import eu.fbk.eclipse.standardtools.utils.core.utils.SysMLElementExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;

public class ASTToPython
extends CachedAstVisitorAction {
    private EMap<EObject, java.lang.Integer> objectIndentation;
    private PythonUtil pyUtil = new PythonUtil();
    private HashMap<EObject, String> tempVarsDeclCache = new HashMap();
    private AstElementExtractor astExtractor;
    private SysMLElementExtractor sysMLExtractor;

    public ASTToPython(SysMLElementExtractor SysMLExtractor, EMap<EObject, java.lang.Integer> objectIndentation) {
        this.objectIndentation = objectIndentation;
        this.astExtractor = new AstElementExtractor(SysMLExtractor);
        this.sysMLExtractor = SysMLExtractor;
    }

    private String getIndentationAsStr(EObject o) throws Exception {
        if (!this.objectIndentation.containsKey((Object)o)) {
            throw new Exception("Error in ASTToPython -- Unable to find the object: " + o.toString());
        }
        int num_indentation = (java.lang.Integer)this.objectIndentation.get((Object)o);
        return this.pyUtil.getIndentationAsStr(num_indentation);
    }

    public void action(SelfAtom o) throws Exception {
        this.action((Atom)o);
    }

    public void action(Attribute o) throws Exception {
        this.action((Atom)o);
    }

    public void action(Context o) throws Exception {
        String ctxPyStr = "";
        for (Atom atom : o.getAtoms()) {
            String atomPyStr = (String)this.getOutputObject((EObject)atom);
            if (atom instanceof Attribute || atom instanceof ParameterList) {
                atomPyStr = this.pyUtil.createPythonGetterCall(atomPyStr, null);
            }
            ctxPyStr = this.pyUtil.createDotExpr(ctxPyStr, atomPyStr);
        }
        this.putOutputObject((EObject)o, ctxPyStr);
    }

    public void action(ConstInteger o) throws Exception {
        this.putOutputObject((EObject)o, String.valueOf(o.getValue()));
    }

    public void action(SetLiteral o) throws Exception {
        Object enumElem;
        String literal = (String)this.getOutputObject((EObject)o.getAtom());
        if (!this.sysMLExtractor.isEnumLiteral(literal, enumElem = this.astExtractor.getInferredSysMLSymbolType((Symbol)o))) {
            throw new Exception("The enum type of '" + literal + "' is null");
        }
        String enumType = this.sysMLExtractor.getEnumTypeName(enumElem);
        String res = this.pyUtil.createDotExpr(enumType, literal);
        res = this.pyUtil.createDotExpr("self", res);
        this.putOutputObject((EObject)o, res);
    }

    public void action(Parameter o) throws Exception {
        this.action((FullyQualifiedSymbol)o);
    }

    public void action(Variable o) throws Exception {
        this.action((FullyQualifiedSymbol)o);
    }

    public void action(TruePredicate o) throws Exception {
        this.putOutputObject((EObject)o, "True");
    }

    public void action(FalsePredicate o) throws Exception {
        this.putOutputObject((EObject)o, "False");
    }

    public void action(NotLogicOP o) throws Exception {
        String expr = (String)this.getOutputObject((EObject)o.getExpr());
        String notExpr = this.pyUtil.createNotProposition(expr);
        this.putOutputObject((EObject)o, notExpr);
    }

    public void action(ImpliesLogicOp o) throws Exception {
        String rightExpr;
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String res = rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        if (!(o.getLeft() instanceof TruePredicate)) {
            res = this.pyUtil.createImpliesStatement(leftExpr, rightExpr);
        }
        this.putOutputObject((EObject)o, res);
    }

    public void action(AndLogicOP o) throws Exception {
        String res = "";
        for (Predicate operand : o.getOperands()) {
            String operandSrt = (String)this.getOutputObject((EObject)operand);
            res = this.pyUtil.createLogicAndProposition(res, operandSrt);
        }
        res = this.pyUtil.createExprInParens(res);
        this.putOutputObject((EObject)o, res);
    }

    public void action(OrLogicOP o) throws Exception {
        String res = "";
        for (Predicate operand : o.getOperands()) {
            String operandSrt = (String)this.getOutputObject((EObject)operand);
            res = this.pyUtil.createInclOrProposition(res, operandSrt);
        }
        res = this.pyUtil.createExprInParens(res);
        this.putOutputObject((EObject)o, res);
    }

    public void action(Equal o) throws Exception {
        this.action((BinaryProposition)o, "==");
    }

    public void action(LessThan o) throws Exception {
        this.action((BinaryProposition)o, "<");
    }

    public void action(LessEqualThan o) throws Exception {
        this.action((BinaryProposition)o, "<=");
    }

    public void action(GreaterThan o) throws Exception {
        this.action((BinaryProposition)o, ">");
    }

    public void action(GreaterEqualThan o) throws Exception {
        this.action((BinaryProposition)o, ">=");
    }

    public void action(AssignStatement o) throws Exception {
        String res;
        Assignable ass = o.getLhs();
        String atomPyStr = (String)this.getOutputObject((EObject)ass.getAtom());
        String ctxPyStr = (String)this.getOutputObject((EObject)ass.getCtx());
        String right = (String)this.getOutputObject((EObject)o.getRhs());
        if (AstUtils.isSetter((FullyQualifiedSymbol)ass)) {
            ArrayList<String> argExprs = new ArrayList<String>();
            argExprs.add(right);
            String setter = this.pyUtil.createPythonSetterCall(atomPyStr, argExprs);
            res = this.pyUtil.createDotExpr(ctxPyStr, setter);
        } else {
            String fqsPyStr = this.pyUtil.createDotExpr(ctxPyStr, atomPyStr);
            res = this.pyUtil.createAssignmentExpr(fqsPyStr, "=", right);
        }
        this.putOutputObject((EObject)o, res);
    }

    public void action(TransitionGuard o) throws Exception {
        String exprStr = (String)this.getOutputObject((EObject)o.getGuard());
        String res = this.getAndCleanDeclVariable((EObject)o.getGuard());
        res = String.valueOf(res) + this.pyUtil.createReturnStmt(exprStr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(TransitionEffect o) throws Exception {
        boolean addComment = false;
        String res = this.processListOfStmt(o.getStatements(), (EObject)o, addComment);
        if (res.equals("")) {
            res = "pass";
        }
        String declVar = this.getAndCleanDeclVariable((EObject)o);
        res = String.valueOf(declVar) + res;
        this.putOutputObject((EObject)o, res);
    }

    public void action(ConstReal o) throws Exception {
        this.putOutputObject((EObject)o, String.valueOf(o.getValue()));
    }

    public void action(ConstHexadecimal o) throws Exception {
        this.putOutputObject((EObject)o, String.valueOf(o.getValue()));
    }

    public void action(ConstOctal o) throws Exception {
        this.putOutputObject((EObject)o, String.valueOf(o.getValue()));
    }

    public void action(NotEqual o) throws Exception {
        this.action((BinaryProposition)o, "!=");
    }

    public void action(PositiveOp o) throws Exception {
        this.action((UnaryArithmeticOp)o, "+", false);
    }

    public void action(NegativeOp o) throws Exception {
        this.action((UnaryArithmeticOp)o, "-", false);
    }

    public void action(AbsOp o) throws Exception {
        this.action((UnaryArithmeticOp)o, "abs", true);
    }

    public void action(CountOp o) throws Exception {
        this.throwUnsupportedException("CountOp");
    }

    public void action(MinOp o) throws Exception {
        this.action((BinaryArithmeticOp)o, "min", true);
    }

    public void action(MaxOp o) throws Exception {
        this.action((BinaryArithmeticOp)o, "max", true);
    }

    public void action(AdditionOp o) throws Exception {
        this.action((BinaryArithmeticOp)o, "+");
    }

    public void action(SubtractionOp o) throws Exception {
        this.action((BinaryArithmeticOp)o, "-");
    }

    public void action(MultiplicationOp o) throws Exception {
        this.action((BinaryArithmeticOp)o, "*");
    }

    public void action(DivisionOp o) throws Exception {
        this.action((BinaryArithmeticOp)o, "/");
    }

    public void action(ModuleOp o) throws Exception {
        this.action((BinaryArithmeticOp)o, "%");
    }

    public void action(ComplementOp o) throws Exception {
        this.action((UnaryBitwiseOp)o, "~");
    }

    public void action(LeftShiftOp o) throws Exception {
        this.action((BinaryBitwiseOp)o, "<<");
    }

    public void action(RigthShiftOp o) throws Exception {
        this.action((BinaryBitwiseOp)o, ">>");
    }

    public void action(AndOp o) throws Exception {
        this.action((BinaryBitwiseOp)o, "&");
    }

    public void action(OrOp o) throws Exception {
        this.action((BinaryBitwiseOp)o, "|");
    }

    public void action(XorOp o) throws Exception {
        this.throwUnsupportedException("XorOp");
    }

    public void action(InputPort o) throws Exception {
        this.action((FullyQualifiedSymbol)o);
    }

    public void action(OutputPort o) throws Exception {
        this.action((FullyQualifiedSymbol)o);
    }

    public void action(SubComponent o) throws Exception {
        this.throwUnsupportedException("SubComponent");
    }

    public void action(Event o) throws Exception {
        this.throwUnsupportedException("Event");
    }

    public void action(EventCall o) throws Exception {
        this.throwUnsupportedException("EventCall");
    }

    public void action(EventRecept o) throws Exception {
        this.throwUnsupportedException("EventRecept");
    }

    public void action(ITStatement o) throws Exception {
        boolean addComments = false;
        String thenStr = this.processListOfStmt(o.getThen(), (EObject)o, addComments);
        if (o.getCondition() instanceof TruePredicate) {
            this.putOutputObject((EObject)o, thenStr);
        } else {
            String condStr = (String)this.getOutputObject((EObject)o.getCondition());
            String res = this.pyUtil.createIfThenStatement(condStr, thenStr);
            this.putOutputObject((EObject)o, res);
        }
    }

    public void action(ITEStatement o) throws Exception {
        String condStr = (String)this.getOutputObject((EObject)o.getCondition());
        boolean addComments = false;
        String thenStr = this.processListOfStmt(o.getThen(), (EObject)o, addComments);
        String elseStr = this.processListOfStmt(o.getElseStmt(), (EObject)o, addComments);
        String res = this.pyUtil.createIfThenElseStatement(condStr, thenStr, elseStr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(AssertStatement o) throws Exception {
        String condStr = (String)this.getOutputObject((EObject)o.getCondition());
        String res = this.pyUtil.createAssert(condStr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(ForAllPredicate o) throws Exception {
        this.throwUnsupportedException("ForAllPredicate");
    }

    public void action(CastExpression o) throws Exception {
        String exprStr = (String)this.getOutputObject((EObject)o.getExpression());
        String typeStr = (String)this.getOutputObject((EObject)o.getTypeSpecifier());
        String res = this.pyUtil.createCast(typeStr, exprStr);
        this.putOutputObject((EObject)o, res);
    }

    public void action(ElementOfList o) throws Exception {
        String index = (String)this.getOutputObject((EObject)o.getIndex());
        String res = this.pyUtil.createElementOfArray(o.getName(), index);
        this.putOutputObject((EObject)o, res);
    }

    public void action(LocalVariable o) throws Exception {
        this.action((FullyQualifiedSymbol)o);
    }

    public void action(DeclarationStatement o) throws Exception {
        String left = (String)this.getOutputObject((EObject)o.getVariable());
        String right = (String)this.getOutputObject((EObject)o.getRhs());
        String res = this.pyUtil.createAssignmentExpr(left, "=", right);
        this.putOutputObject((EObject)o, res);
    }

    public void action(LocalAtom o) throws Exception {
    }

    public void action(ForStatement o) throws Exception {
        this.throwUnsupportedException("ForStatement");
    }

    public void action(ForAllStatement o) throws Exception {
        String res = "";
        String itId = (String)this.getOutputObject((EObject)o.getIter());
        String listId = (String)this.getOutputObject((EObject)o.getList());
        String exprStmt = (String)this.getOutputObject((EObject)o.getStatement());
        res = this.pyUtil.createAllStatement(exprStmt, itId, listId);
        String declVar = this.getAndCleanDeclVariable((EObject)o);
        res = String.valueOf(declVar) + res;
        this.putOutputObject((EObject)o, res);
    }

    public void action(SwitchCaseStatement o) throws Exception {
        this.throwUnsupportedException("SwitchCaseStatement");
    }

    public void action(CaseStatement o) throws Exception {
        this.throwUnsupportedException("CaseStatement");
    }

    public void action(ParameterListIterator o) throws Exception {
        this.action((Atom)o);
    }

    public void action(ParameterList o) throws Exception {
        String atomPyStr = this.pyUtil.createPythonSelfGetterCall(o.getName(), null);
        this.putOutputObject((EObject)o, atomPyStr);
    }

    private void action(Atom o) throws Exception {
        if (o instanceof SelfAtom) {
            this.putOutputObject((EObject)o, "self");
        } else {
            this.putOutputObject((EObject)o, o.getName());
        }
    }

    private void action(FullyQualifiedSymbol o) throws Exception {
        String atomPyStr = (String)this.getOutputObject((EObject)o.getAtom());
        String ctxPyStr = (String)this.getOutputObject((EObject)o.getCtx());
        if (AstUtils.isGetter((FullyQualifiedSymbol)o, (boolean)true)) {
            atomPyStr = this.pyUtil.createPythonGetterCall(atomPyStr, null);
        }
        String fqsPyStr = this.pyUtil.createDotExpr(ctxPyStr, atomPyStr);
        this.putOutputObject((EObject)o, fqsPyStr);
    }

    private void action(BinaryProposition o, String operator) throws Exception {
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        String res = this.pyUtil.createBinaryProposition(leftExpr, operator, rightExpr);
        this.putOutputObject((EObject)o, res);
    }

    private void action(BinaryArithmeticOp o, String operator, boolean isFunction) throws Exception {
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        String res = "";
        res = !isFunction ? this.pyUtil.createBinaryArithmeticOp(leftExpr, operator, rightExpr) : this.pyUtil.createOperationCallWithArgs(operator, leftExpr, rightExpr);
        this.putOutputObject((EObject)o, res);
    }

    private void action(BinaryArithmeticOp o, String operator) throws Exception {
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        String res = this.pyUtil.createBinaryArithmeticOp(leftExpr, operator, rightExpr);
        this.putOutputObject((EObject)o, res);
    }

    private void action(UnaryBitwiseOp o, String operator) throws Exception {
        String expr = (String)this.getOutputObject((EObject)o.getExpr());
        String res = this.pyUtil.createUnaryBitwiseOp(expr, operator);
        this.putOutputObject((EObject)o, res);
    }

    private void action(UnaryArithmeticOp o, String operator, boolean isFunction) throws Exception {
        String expr = (String)this.getOutputObject((EObject)o.getExpr());
        String res = "";
        res = !isFunction ? this.pyUtil.createUnaryArithmeticOp(expr, operator) : this.pyUtil.createOperationCallWithArgs(operator, expr);
        this.putOutputObject((EObject)o, res);
    }

    private void action(BinaryBitwiseOp o, String operator) throws Exception {
        String leftExpr = (String)this.getOutputObject((EObject)o.getLeft());
        String rightExpr = (String)this.getOutputObject((EObject)o.getRight());
        String res = this.pyUtil.createBinaryBitwiseOp(leftExpr, operator, rightExpr);
        this.putOutputObject((EObject)o, res);
    }

    private String processListOfStmt(EList<?> stmtList, EObject o, boolean addComments) throws Exception {
        ArrayList<String> stmtStrList = new ArrayList<String>();
        for (Object stmt : stmtList) {
            String stmtStr = this.getOutputObject((ASTElement)stmt, addComments);
            stmtStrList.add(stmtStr);
        }
        return this.pyUtil.createStatementListWithNl(stmtStrList);
    }

    private String getOutputObject(ASTElement astElement, boolean addComment) throws Exception {
        String strObj = (String)this.getOutputObject((EObject)astElement);
        return addComment ? this.addCommentToText(strObj, astElement) : strObj;
    }

    private String addCommentToText(String text, ASTElement astElement) throws Exception {
        String sourceText = this.getText(astElement);
        sourceText = sourceText != null ? sourceText.replaceAll("(?m)^", "#  ") : "# testo non presente ";
        text = String.valueOf(sourceText) + "\n" + text;
        return text;
    }

    private String getText(ASTElement astElement) {
        if (astElement.getText() == null) {
            return "";
        }
        return this.removeEmptyLines(astElement.getText(), true);
    }

    public String removeEmptyLines(String text, boolean trim) {
        String outputText = text.replaceAll("(?m)^(\r\n|\r|\n)", "");
        if (trim) {
            outputText = StringUtils.chomp((String)outputText).trim();
        }
        return outputText;
    }

    private String getAndCleanDeclVariable(EObject node) {
        if (this.tempVarsDeclCache.containsKey(node)) {
            String res = this.tempVarsDeclCache.get(node);
            this.tempVarsDeclCache.put(node, "");
            return res;
        }
        return "";
    }

    private void setDeclVariables(EObject node, String[] declVars) throws Exception {
        String declVarsStr = String.valueOf(String.join((CharSequence)"\n", declVars)) + "\n";
        if (this.tempVarsDeclCache.containsKey(node)) {
            String prevDecl = this.tempVarsDeclCache.get(node);
            this.tempVarsDeclCache.put(node, String.valueOf(prevDecl) + declVarsStr);
        } else {
            this.tempVarsDeclCache.put(node, declVarsStr);
        }
    }

    public void action(StateLiteral o) throws Exception {
        this.throwUnsupportedException("StateLiteral");
    }

    private void throwUnsupportedException(String unsupClass) throws Exception {
        throw new Exception(String.valueOf(unsupClass) + " not supported in Python.");
    }

    public void action(Boolean o) throws Exception {
        this.putOutputObject((EObject)o, "bool");
    }

    public void action(Real o) throws Exception {
        this.putOutputObject((EObject)o, "float");
    }

    public void action(Void o) throws Exception {
        this.putOutputObject((EObject)o, "");
    }

    public void action(Integer o) throws Exception {
        this.putOutputObject((EObject)o, "int");
    }

    public Object getOutputObject(EObject inputObject) throws Exception {
        String inputOjbStr = (String)super.getOutputObject(inputObject);
        String indentation = this.getIndentationAsStr(inputObject);
        return String.valueOf(indentation) + inputOjbStr.replace("\n", "\n" + indentation);
    }
}

