/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.nattable.handler.AbstractMergeHandler;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.ui.handlers.HandlerUtil;

public class MergeColumnsHandler
extends AbstractMergeHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        CompositeCommand mergeCommand = new CompositeCommand("Merge/UnMerge the cells in all the columns");
        TransactionalEditingDomain tableDomain = this.getTableEditingDomain();
        String commandId = event.getCommand().getId();
        boolean isMerged = HandlerUtil.toggleCommandState((Command)event.getCommand());
        AbstractHeaderAxisConfiguration columnHeaderUsedInTable = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisConfigurationUsedInTable(this.getTable());
        BooleanValueStyle mergeColumns = (BooleanValueStyle)columnHeaderUsedInTable.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeColumns");
        if (mergeColumns != null) {
            if (mergeColumns.isBooleanValue()) {
                SetRequest mergeColumnRequest = new SetRequest(tableDomain, (EObject)mergeColumns, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)false);
                SetValueCommand mergeColumnCommand = new SetValueCommand(mergeColumnRequest);
                mergeCommand.add((IUndoableOperation)mergeColumnCommand);
            } else {
                SetRequest mergeColumnRequest = new SetRequest(tableDomain, (EObject)mergeColumns, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)true);
                SetValueCommand mergeColumnCommand = new SetValueCommand(mergeColumnRequest);
                mergeCommand.add((IUndoableOperation)mergeColumnCommand);
            }
        } else {
            if (columnHeaderUsedInTable instanceof TableHeaderAxisConfiguration) {
                columnHeaderUsedInTable = HeaderAxisConfigurationManagementUtils.transformToLocalHeaderConfiguration((TableHeaderAxisConfiguration)columnHeaderUsedInTable);
                EReference localHeaderFeature = NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration();
                SetRequest initLocalColumnHeaderAxis = new SetRequest(tableDomain, (EObject)this.getTable(), (EStructuralFeature)localHeaderFeature, (Object)columnHeaderUsedInTable);
                IElementEditService localColumnHeaderAxisProvider = ElementEditServiceUtils.getCommandProvider((Object)this.getTable());
                mergeCommand.add((IUndoableOperation)localColumnHeaderAxisProvider.getEditCommand((IEditCommandRequest)initLocalColumnHeaderAxis));
            }
            mergeColumns = NattablestyleFactory.eINSTANCE.createBooleanValueStyle();
            mergeColumns.setBooleanValue(true);
            mergeColumns.setName("mergeColumns");
            SetRequest mergeColumnRequest = new SetRequest(tableDomain, (EObject)columnHeaderUsedInTable, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)mergeColumns);
            SetValueCommand mergeColumnCommand = new SetValueCommand(mergeColumnRequest);
            mergeCommand.add((IUndoableOperation)mergeColumnCommand);
        }
        if (!isMerged) {
            this.updateTableSpanBooleans(commandId, mergeCommand);
        }
        this.executeMergeCommands(mergeCommand, tableDomain);
        return null;
    }
}

