/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;

public class TestCaseCleaner {
    private static final Class<?> ROOT_CLASS = TestCase.class;
    private final TestCase target;

    public TestCaseCleaner(TestCase target) {
        this.target = target;
    }

    public void clearAllFields() throws IllegalAccessException {
        Class<?> current = this.target.getClass();
        while (current != ROOT_CLASS) {
            this.clearFieldsFrom(current);
            current = current.getSuperclass();
        }
    }

    private void clearFieldsFrom(Class<?> klass) {
        Field[] fieldArray = klass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            boolean isReference = !field.getType().isPrimitive();
            try {
                boolean isSet;
                field.setAccessible(true);
                boolean bl = isSet = field.get(this.target) != null;
                if (isReference && isSet) {
                    this.clearField(field);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++n2;
        }
    }

    private void clearField(Field field) throws IllegalAccessException {
        boolean isFinal = Modifier.isFinal(field.getModifiers());
        if (!isFinal) {
            field.set(this.target, null);
        }
    }
}

