/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.checkers.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;
import org.polarsys.chess.checkers.core.checkerManager.Checker;
import org.polarsys.chess.checkers.core.checkerManager.CheckerMessage;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;

public class StateStatus
extends Checker {
    private Package systemViewPackage;
    protected static final Logger logger = Logger.getLogger(StateStatus.class);
    private final EntityUtil entityUtil = EntityUtil.getInstance();
    private static final String checkerName = "StateStatus";

    public StateStatus() {
        super(checkerName, StateStatus.getTags());
    }

    public StateStatus(int priority) {
        super(checkerName, StateStatus.getTags(), priority);
    }

    public StateStatus(Set<String> tags) {
        super(checkerName, tags);
    }

    public StateStatus(Set<String> tags, int priority) {
        super(checkerName, tags, priority);
    }

    private static Set<String> getTags() {
        HashSet<String> tags = new HashSet<String>();
        tags.add("fast");
        tags.add("errors");
        tags.add("state machine");
        return tags;
    }

    @Override
    public List<CheckerMessage> check(IProgressMonitor monitor) throws Exception {
        ArrayList<CheckerMessage> messages = new ArrayList<CheckerMessage>();
        Collection<Class> blocks = null;
        blocks = this.getBlocks(this.systemViewPackage);
        monitor.beginTask(this.unifiedName, blocks.size());
        for (Class block : blocks) {
            messages.addAll(this.checkForDeadStates(block));
            messages.addAll(this.checkForUnreachableStates(block));
            if (monitor.isCanceled()) {
                throw new Exception("Checker interrupted");
            }
            monitor.worked(1);
        }
        return messages;
    }

    protected Collection<Class> getBlocks(Package systemViewPackage) {
        try {
            return EntityUtil.getInstance().getAllClasses(systemViewPackage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected List<CheckerMessage> checkForDeadStates(Class block) {
        ArrayList<CheckerMessage> errors = new ArrayList<CheckerMessage>();
        Set stateMachines = this.entityUtil.getNominalStateMachines(block);
        if (stateMachines.isEmpty()) {
            logger.error((Object)("No state machines are present in block " + block.getName()));
        }
        for (StateMachine stateMachine : stateMachines) {
            if (stateMachine == null) continue;
            String stateMachineName = stateMachine.getName();
            Region region = stateMachine.getRegion(null);
            if (region == null) {
                logger.error((Object)("State machine " + stateMachineName + " of block " + block.getName() + " is not valid"));
                continue;
            }
            if (this.entityUtil.getIntermediateStates(stateMachine).size() <= 1) continue;
            EList states = this.entityUtil.getStates(stateMachine);
            ArrayList<String> deadStates = new ArrayList<String>(1);
            for (Vertex state : states) {
                if (this.entityUtil.isFinalState(state)) continue;
                boolean dead = true;
                EList outgoingTransitions = this.entityUtil.getOutgoingTransitions(state);
                for (Transition transition : outgoingTransitions) {
                    if (this.entityUtil.getTransitionNextState(transition) == state) continue;
                    dead = false;
                    break;
                }
                if (!dead) continue;
                String msg = this.deadMsg(state, block);
                errors.add(this.createMessage(msg, 2, (EObject)state, this.unifiedName));
                deadStates.add(state.getName());
            }
            if (deadStates.size() == 0) {
                logger.debug((Object)("State machine " + stateMachineName + ": all states are valid"));
                continue;
            }
            logger.error((Object)("State machine " + stateMachineName + ": the following states are dead: " + String.join((CharSequence)", ", deadStates)));
        }
        return errors;
    }

    private List<CheckerMessage> checkForUnreachableStates(Class block) {
        ArrayList<CheckerMessage> errors = new ArrayList<CheckerMessage>();
        Set stateMachines = this.entityUtil.getNominalStateMachines(block);
        if (stateMachines.isEmpty()) {
            logger.error((Object)("No state machines are present in block " + block.getName()));
        }
        for (StateMachine stateMachine : stateMachines) {
            if (stateMachine == null) continue;
            String stateMachineName = stateMachine.getName();
            Region region = stateMachine.getRegion(null);
            if (region == null) {
                logger.error((Object)("State machine " + stateMachineName + " of block " + block.getName() + " is not valid"));
                continue;
            }
            EList states = this.entityUtil.getIntermediateStates(stateMachine);
            ArrayList<String> unreachableStates = new ArrayList<String>(1);
            for (Vertex state : states) {
                boolean unreachable = true;
                EList incomingTransitions = this.entityUtil.getIncomingTransitions(state);
                for (Transition transition : incomingTransitions) {
                    if (this.entityUtil.getTransitionSourceState(transition) == state) continue;
                    unreachable = false;
                    break;
                }
                if (!unreachable) continue;
                String msg = this.unreachableMsg(state, block);
                errors.add(this.createMessage(msg, 2, (EObject)state, this.unifiedName));
                unreachableStates.add(state.getName());
            }
            if (unreachableStates.size() == 0) {
                logger.debug((Object)("State machine " + stateMachineName + ": all states are valid"));
                continue;
            }
            logger.error((Object)("State machine " + stateMachineName + ": the following states are not reachable: " + String.join((CharSequence)", ", unreachableStates)));
        }
        return errors;
    }

    protected CheckerMessage createMessage(String msg, int severity, EObject state, String unifiedName) {
        return new CheckerMessage(msg, severity, state, unifiedName);
    }

    protected String deadMsg(Vertex state, Class block) {
        return "The state '" + state.getName() + "' of block '" + block.getName() + "' does not have any transitions to other states";
    }

    protected String unreachableMsg(Vertex state, Class block) {
        return "The state '" + state.getName() + "' of block '" + block.getName() + "' is never reachable";
    }

    @Override
    public void init() throws Exception {
        this.systemViewPackage = EntityUtil.getInstance().getCurrentSystemView();
    }

    @Override
    public void initSync(Package systemViewPackage) throws Exception {
        this.systemViewPackage = systemViewPackage;
    }
}

