/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.ICloudFoundryOperation;
import org.eclipse.cft.server.core.internal.debug.ApplicationDebugLauncher;
import org.eclipse.cft.server.core.internal.debug.CloudFoundryDebugDelegate;
import org.eclipse.cft.server.ui.internal.actions.EditorAction;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryApplicationsEditorPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class DebugApplicationEditorAction
extends EditorAction {
    protected final CloudFoundryApplicationModule appModule;
    protected final CloudFoundryServer cloudServer;
    protected final int appInstance;
    protected final int remoteDebugPort;
    protected final ApplicationDebugLauncher launcher;

    public DebugApplicationEditorAction(CloudFoundryApplicationsEditorPage editorPage, CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int appInstance, int remoteDebugPort, ApplicationDebugLauncher launcher) {
        super(editorPage, EditorAction.RefreshArea.DETAIL);
        this.appModule = appModule;
        this.cloudServer = cloudServer;
        this.appInstance = appInstance;
        this.launcher = launcher;
        this.remoteDebugPort = remoteDebugPort;
    }

    public DebugApplicationEditorAction(CloudFoundryApplicationsEditorPage editorPage, CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, int appInstance, ApplicationDebugLauncher launcher) {
        this(editorPage, appModule, cloudServer, appInstance, CloudFoundryDebugDelegate.DEFAULT_REMOTE_PORT, launcher);
    }

    @Override
    public ICloudFoundryOperation getOperation(IProgressMonitor monitor) throws CoreException {
        return new ICloudFoundryOperation(){

            public void run(IProgressMonitor monitor) throws CoreException {
                DebugApplicationEditorAction.this.launcher.launch(DebugApplicationEditorAction.this.appModule, DebugApplicationEditorAction.this.cloudServer, DebugApplicationEditorAction.this.appInstance, DebugApplicationEditorAction.this.remoteDebugPort);
            }
        };
    }

    @Override
    public String getJobName() {
        return String.valueOf(this.getOperationLabel()) + " - " + this.appModule.getDeployedApplicationName();
    }

    protected String getOperationLabel() {
        return "Connecting to debugger";
    }
}

