/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.IASDAddCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddMessageCommand;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;

public class W11AddMessageCommand
extends W11TopLevelElementCommand
implements IASDAddCommand {
    private String newName;
    private Message message;

    public W11AddMessageCommand(Definition definition) {
        super(Messages._UI_ACTION_ADD_MESSAGE, definition);
    }

    public void setNewMessageName(String newName) {
        this.newName = newName;
    }

    @Override
    public void execute() {
        try {
            this.beginRecording(this.definition.getElement());
            super.execute();
            if (this.newName == null || this.newName.equals("")) {
                this.newName = NameUtil.buildUniqueMessageName(this.definition, "NewMessage");
            }
            AddMessageCommand command = new AddMessageCommand(this.definition, this.newName, true);
            command.run();
            this.message = (Message)command.getWSDLElement();
            this.formatChild(this.message.getElement());
        }
        finally {
            this.endRecording(this.definition.getElement());
        }
    }

    public Message getNewMessage() {
        return this.message;
    }

    @Override
    public Object getNewlyAddedComponent() {
        return this.message;
    }
}

