/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsController;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerManager;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaEEArtifactClassOperation;
import org.eclipse.jst.j2ee.internal.web.operations.CreateWebClassTemplateModel;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public abstract class NewWebClassOperation
extends NewJavaEEArtifactClassOperation {
    private static final String JST_WEB_XDOCLET_VERSION = "1.2.3";
    protected static final String WEB_PLUGIN = "WEB_PLUGIN";

    public NewWebClassOperation(IDataModel dataModel) {
        super(dataModel);
    }

    protected void generateUsingTemplates(IProgressMonitor monitor, IPackageFragment fragment) throws WFTWrappedException, CoreException {
        String source;
        CreateWebClassTemplateModel tempModel = this.createTemplateModel();
        IProject project = this.getTargetProject();
        try {
            source = this.generateTemplateSource(WebPlugin.getPlugin(), tempModel, this.getTemplateFile(), this.getTemplateImplementation(), monitor);
        }
        catch (Exception e) {
            throw new WFTWrappedException((Throwable)e);
        }
        if (fragment != null) {
            String javaFileName = String.valueOf(tempModel.getClassName()) + ".java";
            ICompilationUnit cu = fragment.getCompilationUnit(javaFileName);
            if (cu == null || !cu.exists()) {
                cu = fragment.createCompilationUnit(javaFileName, source, true, monitor);
            }
            IFile aFile = (IFile)cu.getResource();
            AnnotationsController controller = AnnotationsControllerManager.INSTANCE.getAnnotationsController(project);
            if (controller != null) {
                controller.process((IResource)aFile);
            }
        }
        try {
            this.installXDocletFacetIfNecessary(monitor, project);
        }
        catch (Exception e) {
            throw new WFTWrappedException((Throwable)e);
        }
    }

    private void installXDocletFacet(IProgressMonitor monitor, IProject project) throws CoreException, ExecutionException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        Set fixedFacets = facetedProject.getFixedProjectFacets();
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetInstallDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_ID", (Object)"jst.web.xdoclet");
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project.getName());
        dm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)JST_WEB_XDOCLET_VERSION);
        IDataModel fdm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
        fdm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project.getName());
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)fdm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        map.add(dm);
        fdm.getDefaultOperation().execute(monitor, null);
        facetedProject.setFixedProjectFacets(fixedFacets);
    }

    private void installXDocletFacetIfNecessary(IProgressMonitor monitor, IProject project) throws CoreException, ExecutionException {
        if (!this.model.getBooleanProperty("IAnnotationsDataModel.useAnnotations")) {
            return;
        }
        AnnotationsControllerManager.Descriptor descriptor = AnnotationsControllerManager.INSTANCE.getDescriptor(this.getTargetComponent().getProject());
        if (descriptor != null) {
            return;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (!facetedProject.hasProjectFacet(WebFacetUtils.WEB_XDOCLET_FACET)) {
            return;
        }
        this.installXDocletFacet(monitor, project);
    }

    protected abstract CreateWebClassTemplateModel createTemplateModel();

    protected abstract String getTemplateFile();

    protected abstract Object getTemplateImplementation();

    private IVirtualComponent getTargetComponent() {
        return ComponentCore.createComponent((IProject)this.getTargetProject());
    }
}

