/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.Logger;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletEjbAntProjectBuilder;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletPreferenceStore;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletWebAntProjectBuilder;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.util.AntLauncherUtility;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public abstract class XDocletAntProjectBuilder {
    protected URL templateUrl;
    XDocletPreferenceStore preferenceStore = null;
    IProject project;
    IResource resource;
    Properties properties;

    private XDocletPreferenceStore initPreferenceStore(IProject project) {
        if (this.preferenceStore == null) {
            this.preferenceStore = XDocletPreferenceStore.forProject(project);
        }
        return this.preferenceStore;
    }

    protected String asClassPath(IJavaProject project) throws CoreException {
        String[] cp = this.createClassPath(project);
        StringBuffer buf = new StringBuffer(256);
        int i = 0;
        while (i < cp.length) {
            String string = cp[i];
            buf.append(string);
            if (i != cp.length - 1) {
                buf.append(File.pathSeparatorChar);
            }
            ++i;
        }
        return buf.toString();
    }

    protected String[] createClassPath(IJavaProject project) throws CoreException {
        String[] cp = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
        return cp;
    }

    public void buildUsingAnt(final IResource beanClass, IProgressMonitor monitor) throws CoreException {
        this.initPreferenceStore(beanClass.getProject());
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor aMonitor) throws CoreException {
                IJavaProject javaProject = JavaCore.create((IProject)beanClass.getProject());
                try {
                    IPackageFragmentRoot packageFragmentRoot = XDocletAntProjectBuilder.this.getPackageFragmentRootOrFirst(beanClass);
                    String beanPath = XDocletAntProjectBuilder.this.constructAnnotatedClassList(packageFragmentRoot, beanClass);
                    Properties properties = XDocletAntProjectBuilder.this.createAntBuildProperties(beanClass, javaProject, packageFragmentRoot, beanPath);
                    XDocletAntProjectBuilder.this.setProperties(properties);
                    HashMap templates = XDocletAntProjectBuilder.this.createTemplates(beanPath);
                    AntLauncherUtility antLauncher = new AntLauncherUtility(XDocletAntProjectBuilder.this.templateUrl, beanClass.getParent().getLocation(), properties, templates);
                    antLauncher.setUseLauncher(true);
                    antLauncher.launch(XDocletAntProjectBuilder.this.getTaskName(), aMonitor);
                    XDocletAntProjectBuilder.this.refreshProjects(beanClass.getProject(), aMonitor);
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null, 1, monitor);
    }

    private IPackageFragmentRoot getPackageFragmentRootOrFirst(IResource beanClass) throws JavaModelException {
        try {
            ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)((IFile)beanClass));
            return this.getPackageFragmentRoot(compilationUnit);
        }
        catch (RuntimeException runtimeException) {
            IContainer container = J2EEProjectUtilities.getSourceFolderOrFirst((IProject)beanClass.getProject(), (String)"ejbModule");
            return JavaCore.create((IProject)beanClass.getProject()).findPackageFragmentRoot(container.getFullPath());
        }
    }

    protected abstract String getTaskName();

    protected abstract void refreshProjects(IProject var1, IProgressMonitor var2) throws CoreException;

    protected abstract HashMap createTemplates(String var1);

    protected abstract Properties createAntBuildProperties(IResource var1, IJavaProject var2, IPackageFragmentRoot var3, String var4);

    protected abstract String constructAnnotatedClassList(IPackageFragmentRoot var1, IResource var2);

    protected IPath makeRelativeTo(IPath path, IPackageFragmentRoot root) {
        if (root == null) {
            return path;
        }
        try {
            IPath rpath = root.getCorrespondingResource().getProjectRelativePath();
            if (rpath.isPrefixOf(path)) {
                return path.removeFirstSegments(rpath.matchingFirstSegments(path));
            }
        }
        catch (JavaModelException e) {
            Logger.logException(e);
        }
        return path;
    }

    protected IPackageFragmentRoot getPackageFragmentRoot(ICompilationUnit res) {
        ICompilationUnit current = res;
        do {
            if (!(current instanceof IPackageFragmentRoot)) continue;
            return (IPackageFragmentRoot)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    protected IPath getJavaProjectOutputContainer(IJavaProject proj) throws JavaModelException {
        IPath path = proj.getOutputLocation();
        if (path == null) {
            return null;
        }
        if (path.segmentCount() == 1) {
            return path;
        }
        return proj.getProject().getFolder(path.removeFirstSegments(1)).getProjectRelativePath();
    }

    public XDocletPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public static class Factory {
        public static XDocletAntProjectBuilder newInstance(IResource resource) {
            IVirtualResource[] vResources = ComponentCore.createResources((IResource)resource);
            XDocletAntProjectBuilder antProjectBuilder = null;
            if (vResources.length == 0) {
                return null;
            }
            if (J2EEProjectUtilities.isEJBProject((IProject)vResources[0].getComponent().getProject())) {
                antProjectBuilder = new XDocletEjbAntProjectBuilder();
            } else if (J2EEProjectUtilities.isDynamicWebProject((IProject)vResources[0].getComponent().getProject())) {
                antProjectBuilder = new XDocletWebAntProjectBuilder();
            }
            antProjectBuilder.setProject(vResources[0].getComponent().getProject());
            antProjectBuilder.setResource(resource);
            return antProjectBuilder;
        }
    }
}

