/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AbstractJavaBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class StandardJavaBreakpointEditor
extends AbstractJavaBreakpointEditor {
    private IJavaBreakpoint fBreakpoint;
    private Button fHitCountButton;
    private Text fHitCountText;
    private Button fSuspendThread;
    private Button fSuspendVM;
    protected Button fTriggerPointButton;
    public static final int PROP_HIT_COUNT_ENABLED = 4101;
    public static final int PROP_HIT_COUNT = 4102;
    public static final int PROP_SUSPEND_POLICY = 4103;
    public static final int PROP_TRIGGER_POINT = 4104;

    @Override
    public Control createControl(Composite parent) {
        this.createTriggerPointButton(parent);
        return this.createStandardControls(parent);
    }

    protected Button createCheckButton(Composite parent, String text) {
        return SWTFactory.createCheckButton((Composite)parent, (String)text, null, (boolean)false, (int)1);
    }

    protected void createTriggerPointButton(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)0, (int)0, (int)0);
        this.fTriggerPointButton = this.createCheckButton(composite, PropertyPageMessages.JavaBreakpointPage_12);
        this.fTriggerPointButton.setSelection(this.isTriggerPoint());
        this.fTriggerPointButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StandardJavaBreakpointEditor.this.setDirty(4104);
            }
        });
    }

    protected Control createStandardControls(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)4, (int)1, (int)0, (int)0, (int)0);
        this.fHitCountButton = SWTFactory.createCheckButton((Composite)composite, (String)this.processMnemonics(PropertyPageMessages.JavaBreakpointPage_4), null, (boolean)false, (int)1);
        this.fHitCountButton.setLayoutData((Object)new GridData());
        this.fHitCountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean enabled = StandardJavaBreakpointEditor.this.fHitCountButton.getSelection();
                StandardJavaBreakpointEditor.this.fHitCountText.setEnabled(enabled);
                if (enabled) {
                    StandardJavaBreakpointEditor.this.fHitCountText.setFocus();
                }
                StandardJavaBreakpointEditor.this.setDirty(4101);
            }
        });
        this.fHitCountText = SWTFactory.createSingleText((Composite)composite, (int)1);
        GridData gd = (GridData)this.fHitCountText.getLayoutData();
        gd.minimumWidth = 50;
        this.fHitCountText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StandardJavaBreakpointEditor.this.setDirty(4102);
            }
        });
        SWTFactory.createLabel((Composite)composite, (String)"", (int)1);
        Composite radios = SWTFactory.createComposite((Composite)composite, (Font)composite.getFont(), (int)2, (int)1, (int)768, (int)0, (int)0);
        this.fSuspendThread = SWTFactory.createRadioButton((Composite)radios, (String)this.processMnemonics(PropertyPageMessages.JavaBreakpointPage_7), (int)1);
        this.fSuspendThread.setLayoutData((Object)new GridData());
        this.fSuspendVM = SWTFactory.createRadioButton((Composite)radios, (String)this.processMnemonics(PropertyPageMessages.JavaBreakpointPage_8), (int)1);
        this.fSuspendVM.setLayoutData((Object)new GridData());
        this.fSuspendThread.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandardJavaBreakpointEditor.this.setDirty(4103);
            }
        });
        this.fSuspendVM.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandardJavaBreakpointEditor.this.setDirty(4103);
            }
        });
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StandardJavaBreakpointEditor.this.dispose();
            }
        });
        return composite;
    }

    @Override
    public void setInput(Object breakpoint) throws CoreException {
        try {
            this.suppressPropertyChanges(true);
            if (breakpoint instanceof IJavaBreakpoint) {
                this.setBreakpoint((IJavaBreakpoint)breakpoint);
            } else {
                this.setBreakpoint(null);
            }
        }
        finally {
            this.suppressPropertyChanges(false);
        }
    }

    @Override
    public Object getInput() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IJavaBreakpoint breakpoint) throws CoreException {
        this.fBreakpoint = breakpoint;
        boolean enabled = false;
        boolean hasHitCount = false;
        String text = "";
        boolean suspendThread = true;
        if (breakpoint != null) {
            enabled = true;
            int hitCount = breakpoint.getHitCount();
            if (hitCount > 0) {
                text = Integer.valueOf(hitCount).toString();
                hasHitCount = true;
            }
            suspendThread = breakpoint.getSuspendPolicy() == 2;
        }
        this.fHitCountButton.setEnabled(enabled);
        this.fHitCountButton.setSelection(enabled && hasHitCount);
        this.fHitCountText.setEnabled(hasHitCount);
        this.fHitCountText.setText(text);
        this.fSuspendThread.setEnabled(enabled);
        this.fSuspendVM.setEnabled(enabled);
        this.fSuspendThread.setSelection(suspendThread);
        this.fSuspendVM.setSelection(!suspendThread);
        this.fTriggerPointButton.setEnabled(enabled);
        this.fTriggerPointButton.setSelection(this.isTriggerPoint());
        this.setDirty(false);
    }

    protected IJavaBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void doSave() throws CoreException {
        if (this.fBreakpoint != null) {
            int suspendPolicy = 2;
            if (this.fSuspendVM.getSelection()) {
                suspendPolicy = 1;
            }
            this.fBreakpoint.setSuspendPolicy(suspendPolicy);
            int hitCount = -1;
            if (this.fHitCountButton.getSelection()) {
                try {
                    hitCount = Integer.parseInt(this.fHitCountText.getText());
                }
                catch (NumberFormatException e) {
                    throw new CoreException((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, PropertyPageMessages.JavaBreakpointPage_0, (Throwable)e));
                }
            }
            this.fBreakpoint.setHitCount(hitCount);
            this.storeTriggerPoint(this.fBreakpoint);
        }
        this.setDirty(false);
    }

    @Override
    public IStatus getStatus() {
        if (this.fHitCountButton.getSelection()) {
            String hitCountText = this.fHitCountText.getText();
            int hitCount = -1;
            try {
                hitCount = Integer.parseInt(hitCountText);
            }
            catch (NumberFormatException numberFormatException) {
                return new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, PropertyPageMessages.JavaBreakpointPage_0, null);
            }
            if (hitCount < 1) {
                return new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, PropertyPageMessages.JavaBreakpointPage_0, null);
            }
        }
        return Status.OK_STATUS;
    }

    protected Button createSusupendPropertyEditor(Composite parent, String text, final int propId) {
        Button button = new Button(parent, 32);
        button.setFont(parent.getFont());
        button.setText(text);
        GridData gd = new GridData(1);
        button.setLayoutData((Object)gd);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandardJavaBreakpointEditor.this.setDirty(propId);
            }
        });
        return button;
    }

    private boolean isTriggerPoint() {
        try {
            if (this.getBreakpoint() != null) {
                return this.getBreakpoint().isTriggerPoint();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void storeTriggerPoint(IJavaBreakpoint breakpoint) throws CoreException {
        boolean oldSelection = breakpoint.isTriggerPoint();
        if (oldSelection == this.fTriggerPointButton.getSelection()) {
            return;
        }
        breakpoint.setTriggerPoint(this.fTriggerPointButton.getSelection());
        DebugPlugin.getDefault().getBreakpointManager().refreshTriggerpointDisplay();
    }
}

