/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.api;

import java.util.Objects;
import org.eclipse.birt.core.data.IDimLevel;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;

public class DimLevel
implements Comparable,
IDimLevel {
    private String dimensionName;
    private String levelName;
    private String attrName;
    private String qualifiedName;

    public DimLevel(String dimensionName, String levelName) {
        this(dimensionName, levelName, null);
    }

    public DimLevel(String dimensionName, String levelName, String attrName) {
        this.dimensionName = dimensionName;
        this.levelName = levelName;
        this.attrName = attrName;
        this.setQualifiedName();
    }

    public DimLevel(ILevelDefinition levelDefn) {
        this.levelName = levelDefn.getName();
        this.dimensionName = levelDefn.getHierarchy().getDimension().getName();
        this.setQualifiedName();
    }

    private void setQualifiedName() {
        this.qualifiedName = OlapExpressionUtil.getAttrReference(this.dimensionName, this.levelName, this.attrName == null ? this.levelName : this.attrName);
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public String getAttrName() {
        return this.attrName;
    }

    public int hashCode() {
        return Objects.hash(this.dimensionName, this.levelName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DimLevel)) {
            return false;
        }
        DimLevel other = (DimLevel)obj;
        if (!Objects.equals(this.dimensionName, other.dimensionName)) {
            return false;
        }
        return Objects.equals(this.levelName, other.levelName);
    }

    public String toString() {
        return this.qualifiedName;
    }

    public int compareTo(Object obj) {
        if (obj == null || !(obj instanceof DimLevel)) {
            return -1;
        }
        DimLevel dimLevel = (DimLevel)obj;
        return this.toString().compareTo(dimLevel.toString());
    }
}

