/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.SimpleInstanceManager;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class ViewerWebApp {
    private ServiceRegistration<ContextHandler> serviceRegister;
    private Bundle bundle;
    private String webAppPath;
    private String contextPath;
    private String encoding;

    ViewerWebApp(Bundle bundle, String webAppPath, String contextPath, String encoding) {
        this.bundle = bundle;
        this.webAppPath = webAppPath;
        this.contextPath = contextPath;
        this.encoding = encoding;
    }

    public void start() throws IOException {
        WebAppContext webapp = new WebAppContext();
        WebXmlConfiguration servletsConfiguration = new WebXmlConfiguration();
        webapp.addConfiguration(new Configuration[]{servletsConfiguration});
        webapp.setAttribute(InstanceManager.class.getName(), (Object)new SimpleInstanceManager());
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("Web-ContextPath", this.contextPath);
        ((Dictionary)props).put("Jetty-WarResourcePath", this.getWebAppPath(this.bundle, this.webAppPath));
        ((Dictionary)props).put("managedServerName", "org.eclipse.birt.report.viewer.server");
        ((Dictionary)props).put("Jetty-WebXmlFilePath", "birt/WEB-INF/web-viewer.xml");
        URL url = this.bundle.getEntry(this.webAppPath);
        if (url != null) {
            webapp.setBaseResource(Resource.newResource((URL)url));
        }
        if (this.encoding != null) {
            System.setProperty("org.eclipse.jetty.util.UrlEncoding.charset", this.encoding);
            System.setProperty("org.eclipse.jetty.util.URI.charset", this.encoding);
        }
        this.bundle.getBundleContext().registerService(WebAppContext.class, (Object)webapp, props);
    }

    public void stop() {
        if (this.serviceRegister != null) {
            this.serviceRegister.unregister();
            this.serviceRegister = null;
        }
    }

    private String getWebAppPath(Bundle bundle, String path) throws IOException {
        URL url = bundle.getEntry(path);
        if (url != null) {
            URL fileUrl = FileLocator.toFileURL((URL)url);
            return fileUrl.getFile();
        }
        return path;
    }
}

