/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.designer.data.ui.util.DataSetExceptionHandler;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SessionHandle;

public class DataUtil {
    private static AggregationManager manager;
    private static Logger logger;

    static {
        logger = Logger.getLogger(DataUtil.class.getName());
    }

    public static AggregationManager getAggregationManager() throws BirtException {
        if (manager == null) {
            DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            manager = session.getAggregationManager();
            session.shutdown();
        }
        return manager;
    }

    private static IModelAdapter getModelAdapter() {
        IModelAdapter modelAdapter = null;
        try {
            DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            modelAdapter = session.getModelAdaptor();
            session.shutdown();
        }
        catch (BirtException e1) {
            logger.log(Level.WARNING, e1.getMessage(), e1);
        }
        return modelAdapter;
    }

    private static String getAdaptedExprText(IModelAdapter adapter, ComputedColumnHandle target) {
        ExpressionHandle eh = target.getExpressionProperty("expression");
        if (eh == null) {
            return null;
        }
        Expression expr = (Expression)eh.getValue();
        ScriptExpression scriptExpr = adapter.adaptExpression(expr);
        if (scriptExpr == null) {
            return null;
        }
        return scriptExpr.getText();
    }

    public static Set getReferencedBindings(ComputedColumnHandle target, List allHandleList) {
        IModelAdapter modelAdapter = DataUtil.getModelAdapter();
        return DataUtil.getReferencedBindings(target, allHandleList, new HashSet(), modelAdapter);
    }

    private static Set getReferencedBindings(ComputedColumnHandle target, List allHandleList, Set prohibitedSet, IModelAdapter modelAdapter) {
        HashSet<Object> result = new HashSet<Object>();
        if (target == null || allHandleList == null || allHandleList.size() == 0 || modelAdapter == null) {
            return result;
        }
        prohibitedSet.add(target.getName());
        String expr = DataUtil.getAdaptedExprText(modelAdapter, target);
        try {
            List referredBindings = ExpressionUtil.extractColumnExpressions((String)expr);
            int i = 0;
            while (i < referredBindings.size()) {
                IColumnBinding binding = (IColumnBinding)referredBindings.get(i);
                int j = 0;
                while (j < allHandleList.size()) {
                    ComputedColumnHandle handle = (ComputedColumnHandle)allHandleList.get(j);
                    if (handle.getName().equals(binding.getResultSetColumnName()) && !prohibitedSet.contains(binding.getResultSetColumnName())) {
                        result.add(handle);
                    }
                    ++j;
                }
                ++i;
            }
            HashSet temp = new HashSet();
            Iterator it = result.iterator();
            while (it.hasNext()) {
                HashSet newProhibitedSet = new HashSet(prohibitedSet);
                temp.addAll(DataUtil.getReferencedBindings((ComputedColumnHandle)it.next(), allHandleList, newProhibitedSet, modelAdapter));
            }
            result.addAll(temp);
        }
        catch (BirtException birtException) {
            // empty catch block
        }
        return result;
    }

    public static List getValidGroupKeyBindings(List availableHandles) {
        ArrayList<ComputedColumnHandle> result = new ArrayList<ComputedColumnHandle>();
        IModelAdapter modelAdapter = DataUtil.getModelAdapter();
        if (availableHandles == null || modelAdapter == null) {
            return result;
        }
        try {
            int i = 0;
            while (i < availableHandles.size()) {
                ComputedColumnHandle handle = (ComputedColumnHandle)availableHandles.get(i);
                ArrayList<String> originalNames = new ArrayList<String>();
                originalNames.add(handle.getName());
                if (DataUtil.acceptBinding(handle, availableHandles, originalNames, modelAdapter)) {
                    result.add(handle);
                }
                ++i;
            }
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }

    public static String getParamValue(DataSetHandle dataSetHandle, OdaDataSetParameterHandle paramDefn) throws DesignFileException {
        ModuleHandle moduleHandle = dataSetHandle.getModuleHandle();
        String designFileName = moduleHandle.getFileName();
        String reportConfigName = String.valueOf(designFileName.substring(0, designFileName.length() - "rptdesign".length())) + "rptconfig";
        File file = new File(reportConfigName);
        if (file.exists()) {
            String paraName = paramDefn.getParamName();
            ScalarParameterHandle parameterHandle = (ScalarParameterHandle)moduleHandle.findParameter(paraName);
            paraName = String.valueOf(paraName) + "_" + parameterHandle.getID();
            SessionHandle sessionHandle = new DesignEngine(null).newSessionHandle(ULocale.US);
            ReportDesignHandle rdHandle = sessionHandle.openDesign(reportConfigName);
            if (rdHandle != null) {
                Iterator configVars = rdHandle.configVariablesIterator();
                while (configVars != null && configVars.hasNext()) {
                    ConfigVariableHandle configVar = (ConfigVariableHandle)configVars.next();
                    if (configVar == null) continue;
                    String varName = DataUtil.prepareConfigVarName(configVar.getName());
                    String varValue = configVar.getValue();
                    if (varName == null || varValue == null) continue;
                    if (varName.equals(paraName)) {
                        String value = varValue;
                        if (DataUtil.isToBeConverted(parameterHandle.getDataType())) {
                            value = "\"" + JavascriptEvalUtil.transformToJsConstants((String)value) + "\"";
                        }
                        return value;
                    }
                    if (!DataUtil.isNullValue(varName, varValue, paraName)) continue;
                    return null;
                }
            }
        }
        return ExpressionUtil.createJSParameterExpression((String)paramDefn.getParamName());
    }

    private static boolean isToBeConverted(String type) {
        return type.equals("string") || type.equals("dateTime") || type.equals("time") || type.equals("date");
    }

    private static String prepareConfigVarName(String name) {
        int index = name.lastIndexOf("_");
        return name.substring(0, index);
    }

    private static boolean isNullValue(String varName, String varValue, String newParaName) {
        return varName.toLowerCase().startsWith("__isnull") && varValue.equals(newParaName);
    }

    private static boolean acceptBinding(ComputedColumnHandle binding, List bindings, List originalNames, IModelAdapter adapter) {
        try {
            String expr;
            if (binding.getAggregateFunction() == null && !ExpressionUtil.hasAggregation((String)(expr = DataUtil.getAdaptedExprText(adapter, binding)))) {
                List referredBindings = ExpressionUtil.extractColumnExpressions((String)expr);
                ArrayList<String> names = new ArrayList<String>();
                names.add(binding.getName());
                names.addAll(originalNames);
                if (DataUtil.acceptindirectReferredBindings(originalNames, bindings, referredBindings, adapter)) {
                    return true;
                }
            }
        }
        catch (BirtException birtException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean acceptindirectReferredBindings(List originalBindingName, List availableHandles, List referredBindings, IModelAdapter adapter) {
        try {
            ArrayList<ComputedColumnHandle> candidateBindings = new ArrayList<ComputedColumnHandle>();
            int i = 0;
            while (i < referredBindings.size()) {
                IColumnBinding cb = (IColumnBinding)referredBindings.get(i);
                int j = 0;
                while (j < availableHandles.size()) {
                    ComputedColumnHandle binding = (ComputedColumnHandle)availableHandles.get(j);
                    if (!originalBindingName.contains(binding.getName()) && binding.getName().equals(cb.getResultSetColumnName())) {
                        candidateBindings.add(binding);
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < candidateBindings.size()) {
                ComputedColumnHandle handle = (ComputedColumnHandle)candidateBindings.get(i);
                if (!DataUtil.acceptBinding(handle, availableHandles, originalBindingName, adapter)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getAggregationExpression(ComputedColumnHandle bindingColumn) {
        if (bindingColumn.getExpression() != null) {
            return bindingColumn.getExpression();
        }
        String functionName = bindingColumn.getAggregateFunction();
        if (functionName != null) {
            try {
                IAggrFunction function = DataUtil.getAggregationManager().getAggregation(DataAdapterUtil.adaptModelAggregationType((String)functionName));
                if (function != null) {
                    IParameterDefn[] iParameterDefnArray = function.getParameterDefn();
                    int n = iParameterDefnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IParameterDefn param = iParameterDefnArray[n2];
                        if (param.isDataField()) {
                            Iterator iterator = bindingColumn.argumentsIterator();
                            while (iterator.hasNext()) {
                                AggregationArgumentHandle arg = (AggregationArgumentHandle)iterator.next();
                                if (!DataAdapterUtil.adaptArgumentName((String)arg.getName()).equals(param.getName())) continue;
                                return arg.getValue();
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (BirtException e) {
                DataSetExceptionHandler.handle(e);
            }
        }
        return null;
    }
}

