/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.util.logging.Level;
import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.internal.ui.extension.IExtendedDataModelUIAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.DeleteAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class CutAction
extends AbstractViewAction {
    private static final String DEFAULT_TEXT = Messages.getString((String)"CutAction.text");

    public CutAction(Object selectedObject) {
        this(selectedObject, DEFAULT_TEXT);
    }

    public CutAction(Object selectedObject, String text) {
        super(selectedObject, text);
        ISharedImages shareImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setDisabledImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.setAccelerator(262232);
    }

    public boolean isEnabled() {
        Object selection = this.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof DesignElementHandle && this.getAdapter() != null && this.getAdapter().resolveExtendedData((DesignElementHandle)((IStructuredSelection)selection).getFirstElement()) != null) {
            return this.createDeleteAction(selection).isEnabled();
        }
        return DNDUtil.handleValidateDragInOutline((Object)selection) && this.createDeleteAction(selection).isEnabled();
    }

    public void run() {
        try {
            CommandUtils.executeCommand("org.eclipse.birt.report.designer.ui.command.cutCommand", null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected DeleteAction createDeleteAction(final Object objects) {
        return new DeleteAction(objects){

            @Override
            protected String getTransactionLabel() {
                if (objects instanceof IStructuredSelection) {
                    return Messages.getString((String)"CutAction.trans");
                }
                return String.valueOf(DEFAULT_TEXT) + " " + DEUtil.getDisplayLabel((Object)objects);
            }
        };
    }

    private IExtendedDataModelUIAdapter getAdapter() {
        return ExtendedDataModelUIAdapterHelper.getInstance().getAdapter();
    }
}

