/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.CDialogCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.DimensionBuilderDialog;
import org.eclipse.birt.report.designer.util.NumberUtil;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DimensionCellEditor
extends CDialogCellEditor {
    private String[] units;
    private String unitName;
    private Text textEditor;
    private int style;
    private int inProcessing = 0;
    Listener filter = new Listener(){

        public void handleEvent(Event event) {
            if (DimensionCellEditor.this.textEditor.isDisposed()) {
                return;
            }
            DimensionCellEditor.this.handleFocus(16);
        }
    };
    boolean hasFocus = false;

    public DimensionCellEditor(Composite parent, String[] unitNames) {
        super(parent);
        this.units = unitNames;
    }

    public DimensionCellEditor(Composite parent, String[] unitNames, int style) {
        super(parent, style);
        this.units = unitNames;
        this.style = style;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        DimensionValue value;
        DimensionBuilderDialog dialog = new DimensionBuilderDialog(cellEditorWindow.getShell());
        try {
            value = StringUtil.parseInput((String)this.getDefaultText().getText(), (ULocale)ULocale.getDefault());
        }
        catch (PropertyValueException e) {
            value = null;
        }
        dialog.setUnitNames(this.units);
        dialog.setUnitName(this.unitName);
        if (value != null) {
            dialog.setMeasureData(new Double(value.getMeasure()));
        }
        this.inProcessing = 1;
        if (dialog.open() == 0) {
            this.deactivate();
            this.inProcessing = 0;
            String newValue = null;
            Double doubleValue = 0.0;
            if (dialog.getMeasureData() instanceof Double) {
                doubleValue = (Double)dialog.getMeasureData();
            } else if (dialog.getMeasureData() instanceof DimensionValue) {
                doubleValue = ((DimensionValue)dialog.getMeasureData()).getMeasure();
            }
            DimensionValue dValue = new DimensionValue(doubleValue.doubleValue(), dialog.getUnitName());
            if (dValue != null) {
                newValue = dValue.toDisplayString();
            }
            return newValue;
        }
        this.getDefaultText().setFocus();
        this.getDefaultText().selectAll();
        this.inProcessing = 0;
        return null;
    }

    public void setUnits(String units) {
        this.unitName = units;
    }

    protected void doSetFocus() {
        this.getDefaultText().setFocus();
        this.getDefaultText().selectAll();
    }

    @Override
    protected void doValueChanged() {
        String newValue;
        DimensionValue dValue;
        Object oldValue = this.doGetValue();
        if (oldValue instanceof String) {
            oldValue = this.parseInputString2dValue((String)oldValue);
        }
        if ((dValue = this.parseInputString2dValue(newValue = this.textEditor.getText())) != null) {
            newValue = dValue.toDisplayString();
        }
        if (dValue != null && !dValue.equals(oldValue)) {
            this.markDirty();
            this.doSetValue(newValue);
        } else if (dValue == null && oldValue != null) {
            this.markDirty();
            this.doSetValue(null);
        }
    }

    private DimensionValue parseInputString2dValue(String strValue) {
        DimensionValue dValue = null;
        try {
            dValue = StringUtil.parseInput((String)strValue, (ULocale)ULocale.getDefault());
        }
        catch (PropertyValueException e) {
            dValue = null;
        }
        return dValue;
    }

    protected Control createContents(Composite cell) {
        this.textEditor = new Text(cell, 0x4000 | this.style);
        this.textEditor.setFont(cell.getFont());
        this.textEditor.setBackground(cell.getBackground());
        this.textEditor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DimensionCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.textEditor.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (DimensionCellEditor.this.textEditor != null && !DimensionCellEditor.this.textEditor.isDisposed()) {
                    DimensionCellEditor.this.focusLost();
                }
            }

            public void focusGained(FocusEvent e) {
                DimensionCellEditor.this.handleFocus(15);
            }
        });
        return this.textEditor;
    }

    void handleFocus(int type) {
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.textEditor.selectAll();
                this.hasFocus = true;
                Display display = this.textEditor.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event e = new Event();
                this.textEditor.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.textEditor.getDisplay().getFocusControl();
                if (focusControl == this.textEditor) {
                    return;
                }
                this.hasFocus = false;
                Display display = this.textEditor.getDisplay();
                display.removeFilter(15, this.filter);
                Event e = new Event();
                this.textEditor.notifyListeners(16, e);
            }
        }
    }

    protected void updateContents(Object value) {
        if (this.textEditor == null) {
            return;
        }
        String text = "";
        if (value != null) {
            if (value instanceof String) {
                DimensionValue dValue;
                try {
                    dValue = StringUtil.parseInput((String)((String)value), (ULocale)ULocale.getDefault());
                }
                catch (PropertyValueException e) {
                    dValue = null;
                }
                if (dValue == null) {
                    return;
                }
                text = String.valueOf(NumberUtil.double2LocaleNum((double)dValue.getMeasure())) + dValue.getUnits();
            } else {
                text = value.toString();
            }
        }
        this.textEditor.setText(text);
    }

    protected Text getDefaultText() {
        return this.textEditor;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        } else if (keyEvent.character == '\r') {
            this.applyEditorValueAndDeactivate();
        }
    }

    private void applyEditorValueAndDeactivate() {
        this.inProcessing = 1;
        this.doValueChanged();
        this.fireApplyEditorValue();
        this.deactivate();
        this.inProcessing = 0;
    }

    @Override
    protected void focusLost() {
        if (this.inProcessing == 1) {
            return;
        }
        Rectangle rect = this.getButton().getBounds();
        Point location = this.getButton().toDisplay(0, 0);
        rect.x = location.x;
        rect.y = location.y;
        Point cursorLocation = this.getButton().getDisplay().getCursorLocation();
        if (rect.contains(cursorLocation)) {
            return;
        }
        super.focusLost();
    }
}

