/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.dialogs;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.util.Utils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ClassFoldersSelectionDialog
extends ElementTreeSelectionDialog {
    private static final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private File topDir;

    public ClassFoldersSelectionDialog(Shell parent, File topDir) {
        super(parent, (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new ContentProvider());
        assert (topDir != null);
        this.setValidator(new SelectionValidator());
        this.setInput(topDir.getAbsolutePath());
        this.setTitle(Messages.getString("DataSet.ClassFoldersSelectDlg.Title"));
        this.topDir = topDir;
    }

    protected Control createDialogArea(Composite parent) {
        Control c = super.createDialogArea(parent);
        this.getTreeViewer().expandToLevel(2);
        return c;
    }

    private static File[] getChildren(File f) {
        if (!f.isDirectory()) {
            return new File[0];
        }
        File[] result = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return child.isDirectory();
            }
        });
        if (result != null) {
            Arrays.sort(result, new Utils.FileComparator());
        }
        return result == null ? new File[]{} : result;
    }

    public String[] getSelectedItems() {
        Object[] selected;
        ArrayList<String> result = new ArrayList<String>();
        Object[] objectArray = selected = this.getResult() == null ? new Object[]{} : this.getResult();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            File f = (File)o;
            URI relative = this.topDir.toURI().relativize(f.toURI());
            if (relative.getPath().equals("")) {
                result.add(".");
            } else {
                result.add(new File(relative.getPath()).getName());
            }
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                return ClassFoldersSelectionDialog.getChildren(f);
            }
            return null;
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public boolean hasChildren(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                return ClassFoldersSelectionDialog.getChildren(f).length > 0;
            }
            return false;
        }

        public Object[] getElements(Object arg0) {
            if (arg0 instanceof String) {
                return new Object[]{new File((String)arg0)};
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private static class LabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object arg0) {
            return IMG_FOLDER;
        }

        public String getText(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                if (f.getName().trim().equals("")) {
                    return f.getPath();
                }
                return f.getName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    private static class SelectionValidator
    implements ISelectionStatusValidator {
        private SelectionValidator() {
        }

        public IStatus validate(Object[] selections) {
            if (selections != null && selections.length > 0) {
                return new Status(0, "org.eclipse.birt.data.oda.pojo.ui", 0, "", null);
            }
            return new Status(4, "org.eclipse.birt.data.oda.pojo.ui", 4, "", null);
        }
    }
}

