/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.api.DataExtractionFormatInfo;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IDatasetPreviewTask;
import org.eclipse.birt.report.engine.api.IDocumentWriter;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.impl.DataExtractionTask;
import org.eclipse.birt.report.engine.api.impl.DatasetPreviewTask;
import org.eclipse.birt.report.engine.api.impl.DocumentWriter;
import org.eclipse.birt.report.engine.api.impl.GetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.impl.RenderTask;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentReader;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.RunAndRenderTask;
import org.eclipse.birt.report.engine.api.impl.RunTask;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ReportEngineHelper {
    private ReportEngine engine;
    protected Logger logger;
    private ExtensionManager extensionMgr;
    private EmitterInfo[] emitterInfos;

    public ReportEngineHelper(ReportEngine engine) {
        this.engine = engine;
        this.logger = engine.getLogger();
        this.extensionMgr = ExtensionManager.getInstance();
    }

    public IReportRunnable openReportDesign(String designName) throws EngineException {
        return this.openReportDesign(designName, (IResourceLocator)null);
    }

    public IReportRunnable openReportDesign(String designName, IResourceLocator locator) throws EngineException {
        File file = new File(designName);
        if (!file.exists()) {
            this.logger.log(Level.SEVERE, "{0} not found!", file.getAbsolutePath());
            throw new EngineException("Error.DesignFileNotFound", designName);
        }
        try {
            FileInputStream in = new FileInputStream(file);
            String systemId = designName;
            try {
                systemId = file.toURI().toURL().toString();
            }
            catch (MalformedURLException ue) {
                systemId = designName;
            }
            return this.openReportDesign(systemId, (InputStream)in, locator);
        }
        catch (FileNotFoundException ioe) {
            this.logger.log(Level.SEVERE, "{0} not found!", file.getAbsolutePath());
            throw new EngineException("Error.DesignFileNotFound", designName);
        }
    }

    public IReportRunnable openReportDesign(InputStream designStream) throws EngineException {
        return this.openReportDesign("<stream>", designStream);
    }

    public IReportRunnable openReportDesign(String designName, InputStream designStream) throws EngineException {
        return this.openReportDesign(designName, designStream, new HashMap());
    }

    public IReportRunnable openReportDesign(String designName, InputStream designStream, IResourceLocator locator) throws EngineException {
        HashMap<String, IResourceLocator> options = new HashMap<String, IResourceLocator>();
        if (locator != null) {
            options.put("resourceLocator", locator);
        }
        return this.openReportDesign(designName, designStream, options);
    }

    protected void intializeModuleOptions(Map options) {
        Object semanticCheck;
        EngineConfig config = this.engine.getConfig();
        if (config != null) {
            String resourcePath;
            IResourceLocator locator;
            if (options.get("resourceLocator") == null && (locator = config.getResourceLocator()) != null) {
                options.put("resourceLocator", locator);
            }
            if (options.get("resourceFolder") == null && (resourcePath = config.getResourcePath()) != null) {
                options.put("resourceFolder", resourcePath);
            }
        }
        if ((semanticCheck = options.get("semanticCheck")) == null) {
            options.put("semanticCheck", Boolean.FALSE);
        }
    }

    public ReportDesignHandle getReportDesignHandle(String designName, InputStream designStream, Map options) throws EngineException {
        ReportDesignHandle designHandle;
        try {
            if (options == null) {
                options = new HashMap();
            }
            this.intializeModuleOptions(options);
            ReportParser parser = new ReportParser(options);
            designHandle = parser.getDesignHandle(designName, designStream);
        }
        catch (DesignFileException e) {
            this.logger.log(Level.SEVERE, "invalid design file {0}", designName);
            throw new EngineException("Error.InvalidDesignFile", designName, (Throwable)e);
        }
        assert (designHandle != null);
        return designHandle;
    }

    public IReportRunnable openReportDesign(String designName, InputStream designStream, Map options) throws EngineException {
        ReportRunnable runnable = new ReportRunnable((IReportEngine)this.engine, (ModuleHandle)this.getReportDesignHandle(designName, designStream, options));
        runnable.setReportName(designName);
        return runnable;
    }

    public IReportRunnable openReportDesign(ReportDesignHandle designHandle) throws EngineException {
        ReportRunnable ret = new ReportRunnable((IReportEngine)this.engine, (ModuleHandle)designHandle);
        ret.setReportName(designHandle.getFileName());
        return ret;
    }

    public IRunAndRenderTask createRunAndRenderTask(IReportRunnable reportRunnable) {
        return new RunAndRenderTask(this.engine, reportRunnable);
    }

    public IGetParameterDefinitionTask createGetParameterDefinitionTask(ReportRunnable reportRunnable) {
        return new GetParameterDefinitionTask(this.engine, reportRunnable);
    }

    public String[] getSupportedFormats() {
        return this.extensionMgr.getSupportedFormat().toArray(new String[0]);
    }

    public synchronized EmitterInfo[] getEmitterInfo() {
        if (this.emitterInfos == null) {
            String id;
            String format;
            EmitterInfo emitterInfo;
            EmitterInfo[] tempEmitterInfo;
            EngineConfig config = this.engine.getConfig();
            HashMap<String, EmitterInfo> emitters = new HashMap<String, EmitterInfo>();
            EmitterInfo[] emitterInfoArray = tempEmitterInfo = this.extensionMgr.getEmitterInfo();
            int n = tempEmitterInfo.length;
            int n2 = 0;
            while (n2 < n) {
                emitterInfo = emitterInfoArray[n2];
                format = emitterInfo.getFormat();
                id = emitterInfo.getID();
                if (!emitters.containsKey(format) || id.equals(config.getDefaultEmitter(format))) {
                    emitters.put(format, emitterInfo);
                }
                ++n2;
            }
            this.emitterInfos = new EmitterInfo[emitters.size()];
            emitters.values().toArray(this.emitterInfos);
            emitterInfoArray = this.emitterInfos;
            n = this.emitterInfos.length;
            n2 = 0;
            while (n2 < n) {
                emitterInfo = emitterInfoArray[n2];
                format = emitterInfo.getFormat();
                id = emitterInfo.getID();
                String defaultEmitter = config.getDefaultEmitter(format);
                if (defaultEmitter != null && !defaultEmitter.equals(id)) {
                    this.logger.log(Level.WARNING, "Emitter " + defaultEmitter + " doens't exist! Emitter " + id + " is used for " + format + ".");
                }
                ++n2;
            }
        }
        return this.emitterInfos;
    }

    public DataExtractionFormatInfo[] getDataExtractionFormatInfo() {
        return this.extensionMgr.getDataExtractionExtensionInfo();
    }

    public String getMIMEType(String format) {
        return this.extensionMgr.getMIMEType(format);
    }

    public IReportDocument openReportDocument(String docArchiveName) throws EngineException {
        return this.openReportDocument(null, docArchiveName, new HashMap());
    }

    public IReportDocument openReportDocument(String systemId, String docArchiveName) throws EngineException {
        return this.openReportDocument(systemId, docArchiveName, new HashMap());
    }

    public IReportDocument openReportDocument(String systemId, String docArchiveName, IResourceLocator locator) throws EngineException {
        HashMap<String, IResourceLocator> options = new HashMap<String, IResourceLocator>();
        if (locator != null) {
            options.put("resourceLocator", locator);
        }
        return this.openReportDocument(systemId, docArchiveName, options);
    }

    public IReportDocument openReportDocument(String systemId, String docArchiveName, Map options) throws EngineException {
        Object reader = null;
        try {
            File file = new File(docArchiveName);
            reader = file.exists() ? (file.isDirectory() ? new FolderArchiveReader(docArchiveName) : new FileArchiveReader(docArchiveName)) : (docArchiveName.endsWith("\\") || docArchiveName.endsWith("/") ? new FolderArchiveReader(docArchiveName) : new FileArchiveReader(docArchiveName));
        }
        catch (IOException e) {
            throw new EngineException(e.getLocalizedMessage());
        }
        return this.openReportDocument(systemId, (IDocArchiveReader)reader, options);
    }

    public IReportDocument openReportDocument(String systemId, IDocArchiveReader archive, IResourceLocator locator) throws EngineException {
        HashMap<String, IResourceLocator> options = new HashMap<String, IResourceLocator>();
        if (locator != null) {
            options.put("resourceLocator", locator);
        }
        return this.openReportDocument(systemId, archive, options);
    }

    public IReportDocument openReportDocument(String systemId, IDocArchiveReader archive, Map options) throws EngineException {
        if (options == null) {
            options = new HashMap();
        }
        this.intializeModuleOptions(options);
        ReportDocumentReader reader = new ReportDocumentReader(systemId, this.engine, archive, options);
        this.engine.cacheOpenedDocument(reader);
        return reader;
    }

    public IDocumentWriter openDocumentWriter(IArchiveFile file) {
        return new DocumentWriter(file);
    }

    public IRunTask createRunTask(IReportRunnable runnable) {
        return new RunTask(this.engine, runnable);
    }

    public IRenderTask createRenderTask(IReportDocument reportDoc) {
        return new RenderTask(this.engine, reportDoc);
    }

    public IRenderTask createRenderTask(IReportDocument reportDocument, IReportRunnable reportRunnable) {
        return new RenderTask(this.engine, reportRunnable, reportDocument);
    }

    public IDataExtractionTask createDataExtractionTask(IReportDocument reportDoc) {
        try {
            return new DataExtractionTask(this.engine, reportDoc);
        }
        catch (EngineException ex) {
            this.logger.log(Level.SEVERE, ex.getMessage(), (Throwable)((Object)ex));
            return null;
        }
    }

    public IDatasetPreviewTask createDatasetPreviewTask() throws EngineException {
        return new DatasetPreviewTask(this.engine);
    }
}

