/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.internal.ui.extension.IExtendedDataModelUIAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.LinkedDataSetAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.core.runtime.Assert;

public class DataUtil {
    public static List getColumnList(DataSetHandle handle) throws SemanticException {
        return DataUtil.getColumnList(handle, false);
    }

    public static List getColumnList(DataSetHandle handle, boolean refresh) throws SemanticException {
        ArrayList<StructureHandle> result = new ArrayList<StructureHandle>();
        if (handle != null) {
            MemberHandle resultSet;
            CachedMetaDataHandle meta;
            if (refresh) {
                DataSetUIUtil.updateColumnCache(handle);
            }
            if ((meta = handle.getCachedMetaDataHandle()) == null) {
                DataSetUIUtil.updateColumnCache(handle);
                meta = handle.getCachedMetaDataHandle();
            }
            if (meta != null && (resultSet = meta.getResultSet()).getListValue() != null) {
                int i = 0;
                while (i < resultSet.getListValue().size()) {
                    result.add(resultSet.getAt(i));
                    ++i;
                }
            }
        }
        return result;
    }

    public static List generateComputedColumns(ReportItemHandle handle) throws SemanticException {
        Assert.isNotNull((Object)handle);
        DataSetHandle dataSetHandle = handle.getDataSet();
        if (dataSetHandle == null) {
            dataSetHandle = DEUtil.getBindingHolder((DesignElementHandle)handle).getDataSet();
        }
        if (dataSetHandle != null) {
            List resultSetColumnList = DataUtil.getColumnList(dataSetHandle);
            ArrayList<ComputedColumn> columnList = new ArrayList<ComputedColumn>();
            String groupType = DEUtil.getGroupControlType((DesignElementHandle)handle);
            List groupList = DEUtil.getGroups((DesignElementHandle)handle);
            for (ResultSetColumnHandle resultSetColumn : resultSetColumnList) {
                ComputedColumn column = StructureFactory.createComputedColumn();
                column.setName(resultSetColumn.getColumnName());
                column.setDataType(resultSetColumn.getDataType());
                ExpressionUtility.setBindingColumnExpression(resultSetColumn, column);
                if (ExpressionUtil.hasAggregation((String)column.getExpression())) {
                    if (groupType.equals("group")) {
                        column.setAggregateOn(((GroupHandle)groupList.get(0)).getName());
                    } else if (groupType.equals("listing")) {
                        column.setAggregateOn(null);
                    }
                }
                columnList.add(column);
            }
            return columnList;
        }
        return Collections.EMPTY_LIST;
    }

    public static final IPreparedQuery getPreparedQuery(DataEngine engine, DataSetHandle dataSet) throws BirtException {
        return DataUtil.getPreparedQuery(engine, dataSet, true);
    }

    public static final IPreparedQuery getPreparedQuery(DataEngine engine, DataSetHandle dataSet, boolean useColumnHints) throws BirtException {
        return DataUtil.getPreparedQuery(engine, dataSet, useColumnHints, true);
    }

    public static final IPreparedQuery getPreparedQuery(DataEngine engine, DataSetHandle dataSet, boolean useColumnHints, boolean useFilters) throws BirtException {
        return DataUtil.getPreparedQuery(engine, dataSet, null, useColumnHints, useFilters);
    }

    public static final IPreparedQuery getPreparedQuery(DataEngine engine, DataSetHandle dataSet, ParamBindingHandle[] bindingParams, boolean useColumnHints, boolean useFilters) throws BirtException {
        IBaseDataSetDesign dataSetDesign = DataUtil.getDataSetDesign(engine, dataSet, useColumnHints, useFilters);
        return engine.prepare((IQueryDefinition)DataUtil.getQueryDefinition(dataSetDesign, bindingParams));
    }

    public static final IBaseDataSetDesign getDataSetDesign(DataEngine engine, DataSetHandle dataSet, boolean useColumnHints, boolean useFilters) throws BirtException {
        if (dataSet != null) {
            DataSessionContext context = new DataSessionContext(3, dataSet.getModuleHandle());
            DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
            IModelAdapter adaptor = session.getModelAdaptor();
            BaseDataSetDesign dataSetDesign = adaptor.adaptDataSet(dataSet);
            if (!useColumnHints) {
                dataSetDesign.getResultSetHints().clear();
            }
            if (!useFilters) {
                dataSetDesign.getFilters().clear();
            }
            if (!(dataSet instanceof JointDataSetHandle)) {
                BaseDataSourceDesign dataSourceDesign = adaptor.adaptDataSource(dataSet.getDataSource());
                engine.defineDataSource((IBaseDataSourceDesign)dataSourceDesign);
            }
            if (dataSet instanceof JointDataSetHandle) {
                DataUtil.defineSourceDataSets(engine, dataSet, (IBaseDataSetDesign)dataSetDesign);
            }
            engine.defineDataSet((IBaseDataSetDesign)dataSetDesign);
            session.shutdown();
            return dataSetDesign;
        }
        return null;
    }

    private static void defineSourceDataSets(DataEngine engine, DataSetHandle dataSet, IBaseDataSetDesign dataSetDesign) throws BirtException {
        List dataSets = dataSet.getModuleHandle().getAllDataSets();
        int i = 0;
        while (i < dataSets.size()) {
            DataSetHandle dsHandle = (DataSetHandle)dataSets.get(i);
            if (dsHandle.getName() != null && (dsHandle.getName().equals(((IJointDataSetDesign)dataSetDesign).getLeftDataSetDesignName()) || dsHandle.getName().equals(((IJointDataSetDesign)dataSetDesign).getRightDataSetDesignName()))) {
                DataUtil.getDataSetDesign(engine, dsHandle, true, true);
            }
            ++i;
        }
    }

    public static final QueryDefinition getQueryDefinition(IBaseDataSetDesign dataSetDesign, ParamBindingHandle[] bindingParams) {
        return DataUtil.getQueryDefinition(dataSetDesign, bindingParams, -1);
    }

    public static QueryDefinition getQueryDefinition(IBaseDataSetDesign dataSetDesign, ParamBindingHandle[] bindingParams, int rowsToReturn) {
        if (bindingParams == null || bindingParams.length == 0) {
            return DataUtil.getQueryDefinition(dataSetDesign, rowsToReturn);
        }
        if (dataSetDesign != null) {
            QueryDefinition defn = new QueryDefinition(null);
            defn.setDataSetName(dataSetDesign.getName());
            if (rowsToReturn > 0) {
                defn.setMaxRows(rowsToReturn);
            }
            int i = 0;
            while (i < bindingParams.length) {
                ParamBindingHandle param = bindingParams[i];
                InputParameterBinding binding = new InputParameterBinding(param.getParamName(), (IBaseExpression)new ScriptExpression(param.getExpression()));
                defn.addInputParamBinding(binding);
                ++i;
            }
            return defn;
        }
        return null;
    }

    public static final QueryDefinition getQueryDefinition(IBaseDataSetDesign dataSetDesign, int rowsToReturn) {
        if (dataSetDesign != null) {
            QueryDefinition defn = new QueryDefinition(null);
            defn.setDataSetName(dataSetDesign.getName());
            if (rowsToReturn > 0) {
                defn.setMaxRows(rowsToReturn);
            }
            List parameters = dataSetDesign.getParameters();
            for (ParameterDefinition paramDefn : parameters) {
                if (!paramDefn.isInputMode() || paramDefn.getDefaultInputValue() == null) continue;
                InputParameterBinding binding = new InputParameterBinding(paramDefn.getName(), (IBaseExpression)new ScriptExpression(paramDefn.getDefaultInputValue()));
                defn.addInputParamBinding(binding);
            }
            return defn;
        }
        return null;
    }

    public static DataSetHandle findDataSet(String name) {
        return DataUtil.findDataSet(name, null);
    }

    public static DataSetHandle findDataSet(String name, ModuleHandle module) {
        DataSetHandle dataSet = null;
        dataSet = module != null ? module.findDataSet(name) : SessionHandleAdapter.getInstance().getModule().findDataSet(name);
        if (dataSet != null) {
            return dataSet;
        }
        return DataUtil.findExtendedDataSet(name);
    }

    public static DataSetHandle findExtendedDataSet(String name) {
        ReportElementHandle extData;
        IExtendedDataModelUIAdapter adapter = ExtendedDataModelUIAdapterHelper.getInstance().getAdapter();
        if (adapter != null && (extData = adapter.findExtendedDataByName(name)) != null) {
            return adapter.getDataSet(extData);
        }
        return null;
    }

    public static List<String> getAvailableDataSetNames(ModuleHandle module) {
        ArrayList<String> dataSets = new ArrayList<String>();
        if (module == null) {
            return dataSets;
        }
        for (DataSetHandle dataSetHandle : module.getVisibleDataSets()) {
            dataSets.add(dataSetHandle.getName());
        }
        Iterator<String> itr = new LinkedDataSetAdapter().getVisibleLinkedDataSets().iterator();
        while (itr.hasNext()) {
            dataSets.add(itr.next());
        }
        return dataSets;
    }

    public static List<ColumnHintHandle> getColumnHints(DataSetHandle dataSet) {
        PropertyHandle hintHandle;
        ArrayList<ColumnHintHandle> columnHints = new ArrayList<ColumnHintHandle>();
        if (dataSet != null && (hintHandle = dataSet.getPropertyHandle("columnHints")) != null) {
            for (ColumnHintHandle columnHint : hintHandle) {
                columnHints.add(columnHint);
            }
        }
        return columnHints;
    }
}

