/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import me.prettyprint.cassandra.connection.HOpTimer;
import me.prettyprint.cassandra.connection.LoadBalancingPolicy;
import me.prettyprint.cassandra.connection.NullOpTimer;
import me.prettyprint.cassandra.connection.RoundRobinBalancingPolicy;
import me.prettyprint.cassandra.connection.factory.HClientFactory;
import me.prettyprint.cassandra.connection.factory.HThriftClientFactoryImpl;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.hector.api.ClockResolution;
import me.prettyprint.hector.api.factory.HFactory;

public final class CassandraHostConfigurator
implements Serializable {
    private static final long serialVersionUID = -5798876803582956262L;
    public static final ClockResolution DEF_CLOCK_RESOLUTION;
    private static ClockResolution clockResolution;
    private String hosts;
    private int port = 9160;
    private int maxActive = 50;
    private boolean lifo = true;
    private long maxWaitTimeWhenExhausted = -1L;
    private int cassandraThriftSocketTimeout;
    private boolean useThriftFramedTransport = true;
    private boolean retryDownedHosts = true;
    private int retryDownedHostsQueueSize = -1;
    private int retryDownedHostsDelayInSeconds = 10;
    private boolean autoDiscoverHosts = false;
    private int autoDiscoveryDelayInSeconds = 30;
    private List<String> autoDiscoveryDataCenters;
    private LoadBalancingPolicy loadBalancingPolicy = new RoundRobinBalancingPolicy();
    private int hostTimeoutCounter = 10;
    private int hostTimeoutWindow = 500;
    private int hostTimeoutSuspensionDurationInSeconds = 10;
    private int hostTimeoutUnsuspendCheckDelay = 10;
    private boolean useHostTimeoutTracker = false;
    private boolean runAutoDiscoveryAtStartup = false;
    private boolean useSocketKeepalive = false;
    private HOpTimer opTimer = new NullOpTimer();
    private Class<? extends HClientFactory> clientFactoryClass = HThriftClientFactoryImpl.class;

    public CassandraHostConfigurator() {
        this.hosts = null;
    }

    public CassandraHostConfigurator(String hosts) {
        this.hosts = hosts;
    }

    public CassandraHost[] buildCassandraHosts() {
        if (this.hosts == null) {
            throw new IllegalArgumentException("Need to define at least one host in order to apply configuration.");
        }
        String[] hostVals = this.hosts.split(",");
        CassandraHost[] cassandraHosts = new CassandraHost[hostVals.length];
        for (int x = 0; x < hostVals.length; ++x) {
            CassandraHost cassandraHost = this.port == 9160 ? new CassandraHost(hostVals[x].trim()) : new CassandraHost(hostVals[x], this.port);
            this.applyConfig(cassandraHost);
            cassandraHosts[x] = cassandraHost;
        }
        return cassandraHosts;
    }

    public void applyConfig(CassandraHost cassandraHost) {
        cassandraHost.setMaxActive(this.maxActive);
        cassandraHost.setLifo(this.lifo);
        cassandraHost.setMaxWaitTimeWhenExhausted(this.maxWaitTimeWhenExhausted);
        cassandraHost.setUseThriftFramedTransport(this.useThriftFramedTransport);
        cassandraHost.setUseSocketKeepalive(this.useSocketKeepalive);
        if (this.cassandraThriftSocketTimeout > 0) {
            cassandraHost.setCassandraThriftSocketTimeout(this.cassandraThriftSocketTimeout);
        }
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public void setMaxWaitTimeWhenExhausted(long maxWaitTimeWhenExhausted) {
        this.maxWaitTimeWhenExhausted = maxWaitTimeWhenExhausted;
    }

    public void setCassandraThriftSocketTimeout(int cassandraThriftSocketTimeout) {
        this.cassandraThriftSocketTimeout = cassandraThriftSocketTimeout;
    }

    public boolean getRetryDownedHosts() {
        return this.retryDownedHosts;
    }

    public void setRetryDownedHosts(boolean retryDownedHosts) {
        this.retryDownedHosts = retryDownedHosts;
    }

    public void setRetryDownedHostsQueueSize(int retryDownedHostsQueueSize) {
        this.retryDownedHostsQueueSize = retryDownedHostsQueueSize;
    }

    public int getRetryDownedHostsQueueSize() {
        return this.retryDownedHostsQueueSize;
    }

    public void setRetryDownedHostsDelayInSeconds(int retryDownedHostsDelayInSeconds) {
        this.retryDownedHostsDelayInSeconds = retryDownedHostsDelayInSeconds;
    }

    public int getRetryDownedHostsDelayInSeconds() {
        return this.retryDownedHostsDelayInSeconds;
    }

    public static void setClockResolution(String resolutionString) {
        clockResolution = HFactory.createClockResolution(resolutionString);
    }

    public HOpTimer getOpTimer() {
        return this.opTimer;
    }

    public void setOpTimer(HOpTimer opTimer) {
        this.opTimer = opTimer;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("CassandraHostConfigurator<");
        s.append("clockResolution=");
        s.append(clockResolution);
        s.append("&cassandraThriftSocketTimeout=");
        s.append(this.cassandraThriftSocketTimeout);
        s.append("&maxWaitTimeWhenExhausted=");
        s.append(this.maxWaitTimeWhenExhausted);
        s.append("&maxActive=");
        s.append(this.maxActive);
        s.append("&hosts=");
        s.append(this.hosts);
        s.append("&useThriftFramedTransport=");
        s.append(this.useThriftFramedTransport);
        s.append("&retryDownedHosts=");
        s.append(this.retryDownedHosts);
        s.append("&opTimer=");
        s.append(this.opTimer);
        s.append(">");
        return s.toString();
    }

    public boolean getLifo() {
        return this.lifo;
    }

    public void setLifo(boolean lifo) {
        this.lifo = lifo;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUseThriftFramedTransport(boolean useThriftFramedTransport) {
        this.useThriftFramedTransport = useThriftFramedTransport;
    }

    public static ClockResolution getClockResolution() {
        return clockResolution;
    }

    public static void setClockResolution(ClockResolution clockResolution) {
        CassandraHostConfigurator.clockResolution = clockResolution;
    }

    public boolean getAutoDiscoverHosts() {
        return this.autoDiscoverHosts;
    }

    public void setAutoDiscoverHosts(boolean autoDiscoverHosts) {
        this.autoDiscoverHosts = autoDiscoverHosts;
    }

    public int getAutoDiscoveryDelayInSeconds() {
        return this.autoDiscoveryDelayInSeconds;
    }

    public void setAutoDiscoveryDelayInSeconds(int autoDiscoveryDelayInSeconds) {
        this.autoDiscoveryDelayInSeconds = autoDiscoveryDelayInSeconds;
    }

    public void setAutoDiscoveryDataCenter(String dataCenter) {
        this.autoDiscoveryDataCenters = Arrays.asList(dataCenter);
    }

    public void setAutoDiscoveryDataCenter(List<String> dataCenters) {
        this.autoDiscoveryDataCenters = dataCenters;
    }

    public List<String> getAutoDiscoveryDataCenters() {
        return this.autoDiscoveryDataCenters;
    }

    public LoadBalancingPolicy getLoadBalancingPolicy() {
        return this.loadBalancingPolicy;
    }

    public void setLoadBalancingPolicy(LoadBalancingPolicy loadBalancingPolicy) {
        this.loadBalancingPolicy = loadBalancingPolicy;
    }

    public int getHostTimeoutCounter() {
        return this.hostTimeoutCounter;
    }

    public void setHostTimeoutCounter(int hostTimeoutCounter) {
        this.hostTimeoutCounter = hostTimeoutCounter;
    }

    public int getHostTimeoutWindow() {
        return this.hostTimeoutWindow;
    }

    public void setHostTimeoutWindow(int hostTimeoutWindow) {
        this.hostTimeoutWindow = hostTimeoutWindow;
    }

    public int getHostTimeoutSuspensionDurationInSeconds() {
        return this.hostTimeoutSuspensionDurationInSeconds;
    }

    public void setHostTimeoutSuspensionDurationInSeconds(int hostTimeoutSuspensionDurationInSeconds) {
        this.hostTimeoutSuspensionDurationInSeconds = hostTimeoutSuspensionDurationInSeconds;
    }

    public int getHostTimeoutUnsuspendCheckDelay() {
        return this.hostTimeoutUnsuspendCheckDelay;
    }

    public void setHostTimeoutUnsuspendCheckDelay(int hostTimeoutUnsuspendCheckDelay) {
        this.hostTimeoutUnsuspendCheckDelay = hostTimeoutUnsuspendCheckDelay;
    }

    public boolean getUseHostTimeoutTracker() {
        return this.useHostTimeoutTracker;
    }

    public void setUseHostTimeoutTracker(boolean useHostTimeoutTracker) {
        this.useHostTimeoutTracker = useHostTimeoutTracker;
    }

    public boolean getRunAutoDiscoveryAtStartup() {
        return this.runAutoDiscoveryAtStartup;
    }

    public void setRunAutoDiscoveryAtStartup(boolean runAutoDiscoveryAtStartup) {
        this.runAutoDiscoveryAtStartup = runAutoDiscoveryAtStartup;
    }

    public boolean getUseSocketKeepalive() {
        return this.useSocketKeepalive;
    }

    public void setUseSocketKeepalive(boolean useSocketKeepalive) {
        this.useSocketKeepalive = useSocketKeepalive;
    }

    public void setClientFactoryClass(String cls) {
        Class<HClientFactory> temp;
        String className = cls.contains(".") ? cls : "me.prettyprint.cassandra.connection.factory." + cls;
        try {
            temp = Class.forName(className).asSubclass(HClientFactory.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Unable to find '%s' class.", className), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("ClientFactoryClass should be extended from HClientFactory.", e);
        }
        this.clientFactoryClass = temp;
    }

    public Class<? extends HClientFactory> getClientFactoryClass() {
        return this.clientFactoryClass;
    }

    static {
        clockResolution = DEF_CLOCK_RESOLUTION = HFactory.createClockResolution("MICROSECONDS_SYNC");
    }
}

