/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.nio.ByteBuffer;
import java.util.Map;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.model.ExecutingKeyspace;
import me.prettyprint.cassandra.model.ExecutionResult;
import me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import me.prettyprint.cassandra.service.FailoverPolicy;
import me.prettyprint.cassandra.service.Operation;
import me.prettyprint.cassandra.service.VirtualKeyspaceOperation;
import me.prettyprint.cassandra.service.VirtualKeyspaceServiceImpl;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.exceptions.HectorException;

public class ExecutingVirtualKeyspace<E>
extends ExecutingKeyspace {
    E keyPrefix;
    Serializer<E> keyPrefixSerializer;
    ByteBuffer prefixBytes;

    public ExecutingVirtualKeyspace(String keyspace, E keyPrefix, Serializer<E> keyPrefixSerializer, HConnectionManager connectionManager, ConsistencyLevelPolicy consistencyLevelPolicy, FailoverPolicy failoverPolicy) {
        super(keyspace, connectionManager, consistencyLevelPolicy, failoverPolicy);
        this.keyPrefix = keyPrefix;
        this.keyPrefixSerializer = keyPrefixSerializer;
        this.prefixBytes = keyPrefixSerializer.toByteBuffer(keyPrefix);
    }

    public ExecutingVirtualKeyspace(String keyspace, E keyPrefix, Serializer<E> keyPrefixSerializer, HConnectionManager connectionManager, ConsistencyLevelPolicy consistencyLevelPolicy, FailoverPolicy failoverPolicy, Map<String, String> credentials) {
        super(keyspace, connectionManager, consistencyLevelPolicy, failoverPolicy, credentials);
        this.keyPrefix = keyPrefix;
        this.keyPrefixSerializer = keyPrefixSerializer;
        this.prefixBytes = keyPrefixSerializer.toByteBuffer(keyPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ExecutionResult<T> doExecute(KeyspaceOperationCallback<T> koc) throws HectorException {
        VirtualKeyspaceServiceImpl ks = null;
        try {
            ks = new VirtualKeyspaceServiceImpl(this.keyspace, this.keyPrefix, this.keyPrefixSerializer, this.consistencyLevelPolicy, this.connectionManager, this.failoverPolicy, this.credentials);
            ExecutionResult<T> executionResult = koc.doInKeyspaceAndMeasure(ks);
            return executionResult;
        }
        finally {
            if (ks != null) {
                // empty if block
            }
        }
    }

    @Override
    public <T> ExecutionResult<T> doExecuteOperation(Operation<T> operation) throws HectorException {
        operation.applyConnectionParams(this.keyspace, this.consistencyLevelPolicy, this.failoverPolicy, this.credentials);
        this.connectionManager.operateWithFailover(new VirtualKeyspaceOperation<T>(operation, this.prefixBytes));
        return operation.getExecutionResult();
    }
}

