/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import me.prettyprint.cassandra.connection.BackgroundCassandraHostService;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostTimeoutTracker
extends BackgroundCassandraHostService {
    private static final Logger log = LoggerFactory.getLogger(HostTimeoutTracker.class);
    private ConcurrentHashMap<CassandraHost, LinkedBlockingQueue<Long>> timeouts;
    private ConcurrentHashMap<CassandraHost, Long> suspended;
    private int timeoutCounter;
    private int timeoutWindow;
    private int nodeSuspensionDurationInSeconds;
    public static final int DEF_TIMEOUT_COUNTER = 10;
    public static final int DEF_TIMEOUT_WINDOW = 500;
    public static final int DEF_NODE_SUSPENSION_DURATION_IN_SECONDS = 10;
    public static final int DEF_NODE_UNSUSPEND_CHECK_DELAY_IN_SECONDS = 10;

    public HostTimeoutTracker(HConnectionManager connectionManager, CassandraHostConfigurator cassandraHostConfigurator) {
        super(connectionManager, cassandraHostConfigurator);
        this.retryDelayInSeconds = cassandraHostConfigurator.getHostTimeoutUnsuspendCheckDelay();
        this.timeouts = new ConcurrentHashMap();
        this.suspended = new ConcurrentHashMap();
        this.sf = this.executor.scheduleWithFixedDelay(new Unsuspender(), this.retryDelayInSeconds, this.retryDelayInSeconds, TimeUnit.SECONDS);
        this.timeoutCounter = cassandraHostConfigurator.getHostTimeoutCounter();
        this.timeoutWindow = cassandraHostConfigurator.getHostTimeoutWindow();
        this.nodeSuspensionDurationInSeconds = cassandraHostConfigurator.getHostTimeoutSuspensionDurationInSeconds();
    }

    public boolean checkTimeout(CassandraHost cassandraHost) {
        Long last;
        this.timeouts.putIfAbsent(cassandraHost, new LinkedBlockingQueue());
        long currentTimeMillis = System.currentTimeMillis();
        this.timeouts.get(cassandraHost).add(currentTimeMillis);
        boolean timeout = false;
        if (this.timeouts.get(cassandraHost).size() > this.timeoutCounter && (last = (Long)this.timeouts.get(cassandraHost).remove()) < currentTimeMillis - (long)this.timeoutWindow) {
            timeout = true;
            this.connectionManager.suspendCassandraHost(cassandraHost);
            this.suspended.putIfAbsent(cassandraHost, currentTimeMillis);
        }
        return timeout;
    }

    @Override
    void applyRetryDelay() {
    }

    @Override
    void shutdown() {
        log.info("Shutting down HostTimeoutTracker");
        if (this.sf != null) {
            this.sf.cancel(true);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        log.info("HostTimeTracker shutdown complete.");
    }

    class Unsuspender
    implements Runnable {
        Unsuspender() {
        }

        @Override
        public void run() {
            Iterator iterator = HostTimeoutTracker.this.suspended.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry vals = iterator.next();
                if ((Long)vals.getValue() >= System.currentTimeMillis() - (long)(HostTimeoutTracker.this.nodeSuspensionDurationInSeconds * 1000)) continue;
                HostTimeoutTracker.this.connectionManager.unsuspendCassandraHost((CassandraHost)vals.getKey());
                iterator.remove();
            }
        }
    }
}

