/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.layout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportShowFigure;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class ListBandLayout
extends AbstractHintLayout {
    protected Map constraints = new HashMap();
    private static final int verticalSpan = 1;

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Dimension dim = container.getSize().getCopy();
        if (wHint > 0) {
            dim.width = wHint;
        }
        List list = container.getChildren();
        int size = list.size();
        int width = 0;
        int height = 0;
        ReportShowFigure showFigure = null;
        if (container instanceof ReportShowFigure) {
            showFigure = (ReportShowFigure)container;
        }
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)list.get(i);
            if (showFigure == null || showFigure.getContent() != figure || showFigure.isControlShowing()) {
                Dimension prefSize = figure.getPreferredSize(wHint, hHint);
                height += prefSize.height;
                width = Math.max(prefSize.width, width);
            }
            ++i;
        }
        if (height > 0) {
            dim.height = height + container.getInsets().getHeight() + (size - 1) * 1;
        }
        if (width > 0) {
            dim.width = width + container.getInsets().getWidth();
        }
        return dim;
    }

    public void layout(IFigure parent) {
        Rectangle bounds = parent.getClientArea().getCopy();
        List list = parent.getChildren();
        int size = list.size();
        int height = 0;
        ReportShowFigure showFigure = null;
        if (parent instanceof ReportShowFigure) {
            showFigure = (ReportShowFigure)parent;
        }
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)list.get(i);
            if (showFigure != null && showFigure.getContent() == figure && !showFigure.isControlShowing()) {
                this.setBoundsOfChild(parent, figure, new Rectangle(0, height, 0, 0));
            } else {
                Dimension dim = figure.getPreferredSize(bounds.width, -1);
                this.setBoundsOfChild(parent, figure, new Rectangle(0, height, dim.width, dim.height));
                height = height + dim.height + 1;
            }
            ++i;
        }
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        if (!bounds.equals((Object)child.getBounds())) {
            child.setBounds(bounds);
        }
    }

    public Object getConstraint(IFigure figure) {
        return this.constraints.get(figure);
    }

    public void remove(IFigure figure) {
        super.remove(figure);
        this.constraints.remove(figure);
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            this.constraints.put(figure, newConstraint);
        }
    }

    protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        Dimension dim = new Dimension();
        List list = container.getChildren();
        int size = list.size();
        int height = 0;
        int width = 0;
        ReportShowFigure showFigure = null;
        if (container instanceof ReportShowFigure) {
            showFigure = (ReportShowFigure)container;
        }
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)list.get(i);
            if (showFigure == null || showFigure.getContent() != figure || showFigure.isControlShowing()) {
                Dimension min = figure.getMinimumSize(wHint, hHint);
                height += min.height;
                if (min.width > width) {
                    width = min.width;
                }
            }
            ++i;
        }
        if (height > 0) {
            dim.height = height + container.getInsets().getHeight() + (size - 1) * 1;
        }
        dim.width = width + container.getInsets().getWidth();
        return dim;
    }
}

