/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import com.ibm.icu.util.TimeZone;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.HTMLWriter;
import org.eclipse.birt.report.engine.emitter.html.DetailRowState;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.emitter.html.IDGenerator;
import org.eclipse.birt.report.engine.internal.util.HTMLUtil;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.TableHandle;

public class MetadataEmitter {
    private Stack detailRowStateStack = new Stack();
    private HTMLWriter writer;
    private boolean displayFilterIcon;
    private boolean displayGroupIcon;
    private boolean wrapTemplateTable;
    private IDGenerator idGenerator;
    private List ouputInstanceIDs;
    private String imagePath;
    private String htmlIDNamespace;
    private HTMLReportEmitter htmlReportEmitter;
    private String attrNamePrefix;
    private InstanceID wrapperTableIID = null;
    protected String attrType;
    protected String attrRowType;
    protected String attrElementType;
    protected String attrIID;
    private HashMap filterConditions = new HashMap();

    public MetadataEmitter(HTMLWriter writer, HTMLRenderOption htmlOption, String attrNamePrefix, IDGenerator idGenerator, HTMLReportEmitter htmlReportEmitter) {
        this.writer = writer;
        this.displayFilterIcon = htmlOption.getDisplayFilterIcon();
        this.displayGroupIcon = htmlOption.getDisplayGroupIcon();
        this.wrapTemplateTable = htmlOption.getWrapTemplateTable();
        this.ouputInstanceIDs = htmlOption.getInstanceIDs();
        this.imagePath = htmlOption.getAppBaseURL();
        if (this.imagePath != null) {
            if (!this.imagePath.endsWith("/")) {
                this.imagePath = String.valueOf(this.imagePath) + "/";
            }
        } else {
            this.imagePath = "";
        }
        assert (idGenerator != null);
        this.idGenerator = idGenerator;
        this.attrNamePrefix = attrNamePrefix;
        this.initializeAttrName(attrNamePrefix);
        this.htmlReportEmitter = htmlReportEmitter;
    }

    public void initializeAttrName(String prefix) {
        if (prefix == null) {
            this.attrType = "type";
            this.attrRowType = "row-type";
            this.attrElementType = "element_type";
            this.attrIID = "iid";
        } else {
            this.attrType = String.valueOf(prefix) + "type";
            this.attrRowType = String.valueOf(prefix) + "row-type";
            this.attrElementType = String.valueOf(prefix) + "element_type";
            this.attrIID = String.valueOf(prefix) + "iid";
        }
    }

    public void startTable(ITableContent table) {
        Object generateBy = table.getGenerateBy();
        DetailRowState state = null;
        state = generateBy instanceof TableItemDesign ? new DetailRowState(false, false, true) : new DetailRowState(false, false, false);
        this.detailRowStateStack.push(state);
    }

    public void endTable(ITableContent table) {
        this.detailRowStateStack.pop();
    }

    public void startRow(IRowContent row) {
        if (this.isRowInDetailBand(row)) {
            DetailRowState state = (DetailRowState)this.detailRowStateStack.peek();
            if (!state.hasOutput && !state.isStartOfDetail && state.isTable) {
                state.isStartOfDetail = true;
                state.hasOutput = true;
            }
        }
    }

    public void endRow(IRowContent row) {
        DetailRowState state = (DetailRowState)this.detailRowStateStack.peek();
        if (state.isStartOfDetail) {
            state.isStartOfDetail = false;
        }
    }

    public void startCell(ICellContent cell) {
        boolean needColumnFilter = this.needColumnFilter(cell);
        boolean needGroupIcon = this.needGroupIcon(cell);
        if (needColumnFilter || needGroupIcon) {
            this.writer.openTag("table");
            this.writer.attribute("height", "100%");
            this.writer.attribute("width", "100%");
            this.writer.attribute("cellspacing", "0");
            this.writer.attribute("cellpadding", "0");
            this.writer.openTag("tr");
            this.writer.openTag("td");
            IStyle cs = cell.getComputedStyle();
            this.writer.attribute("valign", cs.getVerticalAlign());
            this.writer.attribute("align", cs.getTextAlign());
        }
        if (needGroupIcon) {
            this.writer.attribute("style", "vertical-align:top;text-align:right");
            this.writer.attribute("align", cell.getComputedStyle().getTextAlign());
            this.writer.attribute("width", "1px");
            this.writer.openTag("img");
            this.writer.attribute("src", String.valueOf(this.imagePath) + "./images/iv/collapsexpand.gif");
            this.writer.attribute("style", "cursor:pointer");
            String bookmark = this.idGenerator.generateUniqueID();
            this.htmlReportEmitter.outputBookmark(this.writer, null, this.htmlIDNamespace, bookmark);
            this.writer.attribute(this.attrElementType, "GROUP");
            this.exportElementID(bookmark, "GROUP", -1L);
            this.writer.closeTag("img");
            this.writer.closeTag("td");
            this.writer.openTag("td");
            IStyle cs = cell.getComputedStyle();
            this.writer.attribute("valign", cs.getVerticalAlign());
            this.writer.attribute("align", cs.getTextAlign());
        }
    }

    public void endCell(ICellContent cell) {
        boolean needColumnFilter = this.needColumnFilter(cell);
        boolean needGroupIcon = this.needGroupIcon(cell);
        if (needColumnFilter) {
            this.writer.closeTag("td");
            this.writer.openTag("td");
            this.writer.attribute("style", "vertical-align:top");
            this.writer.openTag("img");
            this.writer.attribute("src", String.valueOf(this.imagePath) + "./images/iv/columnicon.gif");
            this.writer.attribute("alt", this.getColumnFilterText(cell));
            this.writer.attribute("style", "cursor:pointer");
            this.writer.attribute("column", cell.getColumnInstance().getInstanceID().toString());
            String bookmark = this.idGenerator.generateUniqueID();
            this.htmlReportEmitter.outputBookmark(this.writer, null, this.htmlIDNamespace, bookmark);
            this.writer.attribute(this.attrElementType, "COLOUMNINFO");
            this.exportElementID(bookmark, "COLOUMNINFO", -1L);
            this.writer.closeTag("img");
        }
        if (needColumnFilter || needGroupIcon) {
            this.writer.closeTag("td");
            this.writer.closeTag("tr");
            this.writer.closeTag("table");
        }
    }

    private void exportElementID(String bookmark, String elementType, long componentID) {
        if (this.ouputInstanceIDs != null && bookmark != null) {
            assert (elementType != null);
            String htmlBookmark = this.htmlIDNamespace != null ? String.valueOf(this.htmlIDNamespace) + bookmark : bookmark;
            StringBuilder buffer = new StringBuilder();
            buffer.append(htmlBookmark);
            buffer.append(",");
            buffer.append(elementType);
            buffer.append(",");
            buffer.append(componentID);
            this.ouputInstanceIDs.add(buffer.toString());
        }
    }

    public boolean outputMetadataProperty(HashMap propertyMap, Object element, String tagName) {
        if (propertyMap == null) {
            return false;
        }
        boolean iidOutput = false;
        boolean bookmarkOutput = false;
        boolean elementTypeOutput = false;
        boolean addToIIDList = false;
        InstanceID iid = null;
        String bookmark = null;
        String elementType = null;
        for (Map.Entry entry : propertyMap.entrySet()) {
            Object keyObj = entry.getKey();
            Object valueObj = entry.getValue();
            if (!(keyObj instanceof String)) continue;
            String keyStr = (String)keyObj;
            if (keyStr == "iid") {
                Object genBy = null;
                if (element instanceof IContent) {
                    iid = ((IContent)element).getInstanceID();
                    genBy = ((IContent)element).getGenerateBy();
                } else if (element instanceof IColumn) {
                    iid = ((IColumn)element).getInstanceID();
                    genBy = ((IColumn)element).getGenerateBy();
                }
                if (iid == null) continue;
                if (genBy instanceof TableItemDesign || genBy instanceof ListItemDesign || genBy instanceof ExtendedItemDesign) {
                    this.writer.attribute(this.attrIID, iid.toUniqueString());
                } else {
                    this.writer.attribute(this.attrIID, iid.toString());
                }
                iidOutput = true;
                continue;
            }
            if (keyStr == "bookmark") {
                if (!(element instanceof IContent)) continue;
                IContent content = (IContent)element;
                bookmark = content.getBookmark();
                if (bookmark == null) {
                    bookmark = this.idGenerator.generateUniqueID();
                    content.setBookmark(bookmark);
                }
                this.htmlReportEmitter.outputBookmark(this.writer, tagName, this.htmlIDNamespace, bookmark);
                bookmarkOutput = true;
                continue;
            }
            if (keyStr == "element_type") {
                if (valueObj == null) continue;
                elementType = (String)valueObj;
                this.writer.attribute(this.attrElementType, elementType);
                elementTypeOutput = true;
                continue;
            }
            if (keyStr == "iid_list") {
                addToIIDList = true;
                continue;
            }
            if (keyStr.equalsIgnoreCase("type")) {
                if (valueObj == null) continue;
                this.writer.attribute(this.attrType, (String)valueObj);
                continue;
            }
            if (keyStr == "row-type") {
                if (valueObj == null) continue;
                this.writer.attribute(this.attrRowType, (String)valueObj);
                continue;
            }
            if (keyStr == "group-id") {
                String groupId;
                if (!(element instanceof IRowContent) || (groupId = ((IRowContent)element).getGroupId()) == null) continue;
                this.writer.attribute("group-id", groupId);
                continue;
            }
            if (keyStr == "raw_data") {
                Object value;
                if (!(element instanceof IDataContent) || (value = ((IDataContent)element).getValue()) == null) continue;
                String rawData = null;
                try {
                    rawData = DataTypeUtil.toLocaleNeutralString((Object)value, (TimeZone)TimeZone.getTimeZone((String)"GMT"));
                }
                catch (BirtException birtException) {
                    // empty catch block
                }
                if (rawData == null) {
                    rawData = value.toString();
                }
                this.writer.attributeAllowEmpty("raw_data", rawData);
                continue;
            }
            if (valueObj == null || keyStr.length() <= 0) continue;
            if (this.attrNamePrefix != null) {
                this.writer.attribute(String.valueOf(this.attrNamePrefix) + keyStr, valueObj.toString());
                continue;
            }
            this.writer.attribute(keyStr, valueObj.toString());
        }
        if (addToIIDList && iidOutput && bookmarkOutput && elementTypeOutput) {
            this.exportElementID(bookmark, elementType, iid.getComponentID());
        }
        return bookmarkOutput;
    }

    private boolean isRowInDetailBand(IRowContent row) {
        IElement parent = row.getParent();
        if (!(parent instanceof IBandContent)) {
            return false;
        }
        IBandContent band = (IBandContent)parent;
        return band.getBandType() == 0;
    }

    public String getMetadataStyleClass(IContent content) {
        Object generateBy = content.getGenerateBy();
        String styleName = null;
        if (content instanceof ITextContent) {
            styleName = generateBy instanceof LabelItemDesign ? "birt-label-design" : (generateBy instanceof DataItemDesign ? "birt-data-design" : "birt-label-design");
        } else if (content instanceof IImageContent) {
            if (generateBy instanceof ExtendedItemDesign) {
                styleName = "birt-chart-design";
            }
        } else if (content instanceof IForeignContent) {
            styleName = "birt-label-design";
        }
        return styleName;
    }

    private boolean needColumnFilter(ICellContent cell) {
        IColumn columnInstance = cell.getColumnInstance();
        if (columnInstance == null) {
            return false;
        }
        DetailRowState state = (DetailRowState)this.detailRowStateStack.peek();
        return state.isStartOfDetail && columnInstance.hasDataItemsInDetail() && this.displayFilterIcon && this.getFilterConditions(cell).size() > 0;
    }

    private boolean needGroupIcon(ICellContent cell) {
        return cell.getDisplayGroupIcon() && this.displayGroupIcon;
    }

    private boolean isTopLevelTemplateTable(IContent table) {
        DesignElementHandle handle = null;
        Object genBy = table.getGenerateBy();
        if (genBy instanceof TableItemDesign) {
            TableItemDesign tableDesign = (TableItemDesign)genBy;
            handle = tableDesign.getHandle();
        } else if (genBy instanceof TemplateDesign) {
            TemplateDesign templateDesign = (TemplateDesign)genBy;
            handle = templateDesign.getHandle();
        } else if (genBy instanceof ExtendedItemDesign) {
            ExtendedItemDesign extendedItemDesign = (ExtendedItemDesign)genBy;
            handle = extendedItemDesign.getHandle();
        }
        if (handle != null && handle.isTemplateParameterValue()) {
            DesignElementHandle parentHandle = handle.getContainer();
            while (parentHandle != null) {
                if (parentHandle instanceof TableHandle && parentHandle.isTemplateParameterValue()) {
                    return false;
                }
                parentHandle = parentHandle.getContainer();
            }
            return true;
        }
        return false;
    }

    public void startWrapTable(IContent table) {
        if (this.wrapTemplateTable && this.isTopLevelTemplateTable(table)) {
            this.wrapperTableIID = table.getInstanceID();
            this.writer.openTag("table");
            DimensionType width = table.getWidth();
            if (width != null) {
                StringBuilder styleBuffer = new StringBuilder();
                styleBuffer.append(" border: medium none ; border-collapse: collapse; width: ");
                styleBuffer.append(width.toString());
                styleBuffer.append(";");
            } else {
                this.writer.attribute("style", " border: medium none ; border-collapse: collapse; width: 100%;");
            }
            this.writer.openTag("tbody");
            this.writer.openTag("tr");
            this.writer.attribute("style", " vertical-align: top;");
            this.writer.openTag("td");
            this.writer.openTag("img");
            this.writer.attribute("src", String.valueOf(this.imagePath) + "./bizRD/images/sidetab_active.png");
            this.writer.attribute("style", " width: 20px; height: 60px;");
            this.writer.closeTag("img");
            this.writer.closeTag("td");
            this.writer.openTag("td");
            this.writer.attribute("style", " border: 2px solid black;");
        }
    }

    public void endWrapTable(IContent table) {
        if (this.wrapTemplateTable && table.getInstanceID() == this.wrapperTableIID) {
            this.wrapperTableIID = null;
            this.writer.closeTag("td");
            this.writer.closeTag("tr");
            this.writer.closeTag("tbody");
            this.writer.closeTag("table");
        }
    }

    private String getColumnFilterText(ICellContent cell) {
        List filterConditions = this.getFilterConditions(cell);
        StringBuilder conditionString = new StringBuilder();
        int i = 0;
        while (i < filterConditions.size()) {
            if (i != 0) {
                conditionString.append(';');
            }
            FilterConditionHandle condition = (FilterConditionHandle)filterConditions.get(i);
            conditionString.append(HTMLUtil.getFilterDescription((FilterConditionHandle)condition));
            ++i;
        }
        return conditionString.toString();
    }

    private List getFilterConditions(ICellContent cell) {
        Object genBy;
        IRowContent row = (IRowContent)cell.getParent();
        ITableContent table = row.getTable();
        List filters = null;
        if (table != null && (genBy = table.getGenerateBy()) instanceof TableItemDesign) {
            int columnId;
            TableHandle tableHandle = (TableHandle)((TableItemDesign)genBy).getHandle();
            int columnCount = tableHandle.getColumnCount();
            List[] tableFilters = (List[])this.filterConditions.get(tableHandle);
            if (tableFilters == null) {
                tableFilters = new List[columnCount];
                this.filterConditions.put(tableHandle, tableFilters);
            }
            if ((columnId = cell.getColumn()) < columnCount && (filters = tableFilters[columnId]) == null) {
                tableFilters[columnId] = filters = tableHandle.getFilters(cell.getColumn());
            }
        }
        return filters == null ? Collections.EMPTY_LIST : filters;
    }

    public void setHTMLIDNamespace(String namespace) {
        this.htmlIDNamespace = namespace;
    }
}

