/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ITextDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PropertyDescriptorProvider;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;

public class TextPropertyDescriptorProvider
extends PropertyDescriptorProvider
implements ITextDescriptorProvider {
    public TextPropertyDescriptorProvider(String property, String element) {
        super(property, element);
    }

    @Override
    public Object load() {
        String displayName;
        String deValue = super.load().toString();
        IChoice choice = null;
        if ("dataType".equals(this.getProperty())) {
            IChoiceSet dataType = DesignEngine.getMetaDataDictionary().getChoiceSet("paramType");
            choice = dataType.findChoice(deValue);
        } else if ("controlType".equals(this.getProperty())) {
            IChoiceSet controlType = DesignEngine.getMetaDataDictionary().getChoiceSet("paramControl");
            choice = controlType.findChoice(deValue);
        }
        if (choice != null && (displayName = choice.getDisplayName()) != null) {
            deValue = displayName;
        }
        return deValue;
    }

    @Override
    public void save(Object value) throws SemanticException {
        if ("controlType".equals(this.getProperty()) || "dataType".equals(this.getProperty())) {
            return;
        }
        super.save(value);
    }

    @Override
    public boolean isEditable() {
        if ("createdBy".equals(this.getProperty()) || "dataSource".equals(this.getProperty()) || "controlType".equals(this.getProperty()) || "dataType".equals(this.getProperty()) || "iconFile".equals(this.getProperty())) {
            return false;
        }
        return !super.isReadOnly();
    }
}

