/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLImageHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.util.FileUtil;

public class HTMLCompleteImageHandler
extends HTMLImageHandler {
    protected Logger log = Logger.getLogger(HTMLCompleteImageHandler.class.getName());
    private static int count = 0;
    private static HashMap map = new HashMap();

    @Override
    @Deprecated
    public String onDesignImage(IImage image, Object context) {
        return this.handleImage(image, context, "design", true);
    }

    @Override
    @Deprecated
    public String onDocImage(IImage image, Object context) {
        return null;
    }

    @Override
    @Deprecated
    public String onURLImage(IImage image, Object context) {
        assert (image != null);
        return image.getID();
    }

    @Override
    @Deprecated
    public String onCustomImage(IImage image, Object context) {
        return this.handleImage(image, context, "custom", false);
    }

    protected File createUniqueFile(String imageDir, String prefix, String postfix) {
        assert (prefix != null);
        if (postfix == null) {
            postfix = "";
        }
        File file = null;
        while ((file = new File(String.valueOf(imageDir) + "/" + prefix + ++count + postfix)).exists()) {
        }
        return new File(imageDir, String.valueOf(prefix) + count + postfix);
    }

    @Override
    @Deprecated
    public String onFileImage(IImage image, Object context) {
        return this.handleImage(image, context, "file", true);
    }

    protected String handleImage(IImage image, Object context, String prefix, boolean needMap) {
        Map<String, Object> outputSetting;
        EngineConfig config;
        IReportEngine engine;
        IReportRunnable runnable;
        String mapID = null;
        if (needMap && map.containsKey(mapID = this.getImageMapID(image))) {
            return (String)map.get(mapID);
        }
        String imageDirectory = null;
        if (context != null && context instanceof HTMLRenderContext) {
            HTMLRenderContext myContext = (HTMLRenderContext)context;
            imageDirectory = myContext.getImageDirectory();
        }
        if (imageDirectory == null && (runnable = image.getReportRunnable()) != null && (engine = runnable.getReportEngine()) != null && (config = engine.getConfig()) != null) {
            imageDirectory = config.getTempDir();
        }
        if (imageDirectory == null) {
            imageDirectory = FileUtil.getJavaTmpDir();
        }
        if (imageDirectory == null) {
            imageDirectory = ".";
        }
        String outputFile = null;
        IRenderOption renderOption = image.getRenderOption();
        if (renderOption != null && (outputSetting = renderOption.getOutputSetting()) != null) {
            outputFile = (String)image.getRenderOption().getOutputSetting().get("outputFile");
        }
        boolean returnRelativePath = this.needRelativePath(outputFile, imageDirectory);
        String imageOutputDirectory = this.getImageOutputDirectory(outputFile, imageDirectory);
        File file = this.saveImage(image, prefix, imageOutputDirectory);
        String outputPath = this.getOutputPath(returnRelativePath, imageDirectory, file);
        if (needMap) {
            map.put(mapID, outputPath);
        }
        return outputPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File saveImage(IImage image, String prefix, String imageOutputDirectory) {
        Class<HTMLCompleteImageHandler> clazz = HTMLCompleteImageHandler.class;
        synchronized (HTMLCompleteImageHandler.class) {
            File file = this.createUniqueFile(imageOutputDirectory, prefix, image.getExtension());
            try {
                image.writeImage(file);
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            return file;
        }
    }

    private String getTempFile() {
        return new File(".").getAbsolutePath();
    }

    private boolean needRelativePath(String reportOutputFile, String imageDirectory) {
        return reportOutputFile != null && FileUtil.isRelativePath(imageDirectory);
    }

    private String getImageOutputDirectory(String reportOutputFile, String imageDirectory) {
        if (!FileUtil.isRelativePath(imageDirectory)) {
            return imageDirectory;
        }
        String reportOutputDirectory = reportOutputFile == null ? this.getTempFile() : new File(reportOutputFile).getAbsoluteFile().getParent();
        return String.valueOf(reportOutputDirectory) + File.separator + imageDirectory;
    }

    private String getOutputPath(boolean needRelativePath, String imageDirectory, File outputFile) {
        String result = null;
        if (needRelativePath) {
            result = String.valueOf(imageDirectory) + "/" + outputFile.getName();
        } else {
            try {
                result = outputFile.toURL().toExternalForm();
            }
            catch (Exception ex) {
                result = outputFile.getAbsolutePath();
            }
        }
        return result;
    }

    protected String getImageMapID(IImage image) {
        if (image.getReportRunnable() != null) {
            return String.valueOf(image.getReportRunnable().hashCode()) + image.getID();
        }
        return image.getID();
    }
}

