/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.NewSectionDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.TemplateReportItemPropertiesDialog;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.processor.ElementProcessorFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.LibraryElementImageDecorator;
import org.eclipse.birt.report.designer.internal.ui.views.actions.CopyAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.CutAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.DeleteAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ExportElementToLibraryAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertInLayoutAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.PasteAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RenameAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.ColumnBindingDialog;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ContentElementHandle;
import org.eclipse.birt.report.model.api.CssSharedStyleHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementDetailHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TemplateElementHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.gef.Request;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class DefaultNodeProvider
implements INodeProvider {
    protected static Logger logger = Logger.getLogger(DefaultNodeProvider.class.getName());
    public static final String BODY = Messages.getString((String)"DefaultNodeProvider.Tree.Body");
    public static final String COMPONENTS = Messages.getString((String)"DefaultNodeProvider.Tree.Components");
    public static final String PAGESETUP = Messages.getString((String)"DefaultNodeProvider.Tree.PageSetup");
    public static final String DATASOURCES = Messages.getString((String)"DefaultNodeProvider.Tree.DataSources");
    public static final String DATASETS = Messages.getString((String)"DefaultNodeProvider.Tree.DataSets");
    public static final String STYLES = Messages.getString((String)"DefaultNodeProvider.Tree.Styles");
    public static final String THEMES = Messages.getString((String)"DefaultNodeProvider.Tree.Themes");
    public static final String IMAGES = Messages.getString((String)"DefaultNodeProvider.Tree.Images");
    public static final String PARAMETERS = Messages.getString((String)"DefaultNodeProvider.Tree.Parameters");
    public static final String SCRATCHPAD = Messages.getString((String)"DefaultNodeProvider.Tree.Scratch");
    public static final String MASTERPAGE = Messages.getString((String)"DefaultNodeProvider.Tree.MasterPages");
    public static final String COLUMNHEADING_DISPALYNAME = Messages.getString((String)"DefaultNodeProvider.Tree.ColumnHedings");
    public static final String DETAIL_DISPALYNAME = Messages.getString((String)"DefaultNodeProvider.Tree.Detail");
    public static final String HEADER_DISPALYNAME = Messages.getString((String)"DefaultNodeProvider.Tree.Header");
    public static final String FOOTER_DISPALYNAME = Messages.getString((String)"DefaultNodeProvider.Tree.Footer");
    public static final String GROUPS_DISPALYNAME = Messages.getString((String)"DefaultNodeProvider.Tree.Groups");
    public static final String MISSINGNAME = Messages.getString((String)"DefaultNodeProvider.Tree.Invalid");
    public static final String WARNING_DIALOG_TITLE = Messages.getString((String)"DefaultNodeProvider.WarningDialog.Title");
    public static final String WARNING_DIALOG_MESSAGE_EMPTY_LIST = Messages.getString((String)"DefaultNodeProvider.WarningDialog.EmptyList");
    private Comparator<Object> comparator;

    @Override
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        CopyAction copyAction;
        CutAction cutAction;
        DeleteAction deleteAction;
        RenameAction renameAction;
        menu.add((IContributionItem)new Separator());
        InsertInLayoutAction insertAction = new InsertInLayoutAction(object);
        if (insertAction.isEnabled()) {
            menu.add((IAction)insertAction);
        }
        menu.add((IContributionItem)new Separator("additions"));
        if (sourceViewer != null && (renameAction = new RenameAction(sourceViewer)).isEnabled()) {
            menu.add((IAction)renameAction);
        }
        if ((deleteAction = new DeleteAction(object)).isEnabled()) {
            menu.add((IAction)deleteAction);
        }
        if ((cutAction = new CutAction(object)).isEnabled()) {
            menu.add((IAction)cutAction);
        }
        if ((copyAction = new CopyAction(object)).isEnabled()) {
            menu.add((IAction)copyAction);
        }
        if (!(object instanceof ResultSetColumnHandle || object instanceof CssStyleSheetHandle || object instanceof CssSharedStyleHandle || object instanceof DataSetParameterHandle)) {
            menu.add((IAction)new PasteAction(object));
        }
        menu.add((IContributionItem)new Separator("additions-refresh"));
        menu.add((IContributionItem)new Separator("additions-export"));
        ExportElementToLibraryAction exportElementAction = new ExportElementToLibraryAction(object);
        if (exportElementAction.isEnabled()) {
            menu.add((IAction)exportElementAction);
        }
    }

    @Override
    public String getNodeDisplayName(Object model) {
        return DEUtil.getDisplayLabel((Object)model);
    }

    @Override
    public Object[] getChildren(Object model) {
        if (model instanceof SlotHandle) {
            Object[] children = this.getChildrenBySlotHandle((SlotHandle)model);
            if (this.comparator != null) {
                Arrays.sort(children, this.comparator);
            }
            return children;
        }
        if (model instanceof PropertyHandle) {
            Object[] children = this.getChildrenByPropertyHandle((PropertyHandle)model);
            if (this.comparator != null) {
                Arrays.sort(children, this.comparator);
            }
            return children;
        }
        return new Object[0];
    }

    @Override
    public Object getParent(Object model) {
        if (model instanceof SlotHandle) {
            return ((SlotHandle)model).getElementHandle();
        }
        if (model instanceof PropertyHandle) {
            return ((PropertyHandle)model).getElementHandle();
        }
        if (model instanceof ReportElementHandle) {
            ReportElementHandle handle = (ReportElementHandle)model;
            if (handle instanceof CellHandle || handle.getContainer() instanceof CellHandle || handle.getContainer() instanceof ParameterGroupHandle || handle instanceof RowHandle && handle.getContainer() instanceof GridHandle || handle.getContainer() instanceof ExtendedItemHandle) {
                return handle.getContainer();
            }
            if (handle.getContainerSlotHandle() != null) {
                return handle.getContainerSlotHandle();
            }
        }
        return null;
    }

    @Override
    public Image getNodeIcon(Object model) {
        Image icon = null;
        String iconName = this.getIconName(model);
        if (model instanceof DesignElementHandle && ((DesignElementHandle)model).getSemanticErrors().size() > 0) {
            return ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK");
        }
        if (iconName != null) {
            icon = ReportPlatformUIImages.getImage(iconName);
        }
        if (icon == null && model instanceof DesignElementHandle) {
            icon = ReportPlatformUIImages.getImage(model);
        }
        return this.decorateImage(icon, model);
    }

    protected Image decorateImage(Image image, Object model) {
        LibraryElementImageDecorator decorator = new LibraryElementImageDecorator();
        return decorator.decorateImage(image, model);
    }

    @Override
    public String getNodeTooltip(Object model) {
        List errors;
        if (model instanceof DesignElementHandle && (errors = ((DesignElementHandle)model).getSemanticErrors()) != null && errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < errors.size()) {
                if (i > 0) {
                    sb.append("\r\n");
                }
                sb.append(((ErrorDetail)errors.get(i)).getMessage());
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    public String getIconName(Object model) {
        return null;
    }

    protected Object[] getChildrenBySlotHandle(SlotHandle slotHandle) {
        ArrayList<DesignElementHandle> list = new ArrayList<DesignElementHandle>();
        for (Object obj : slotHandle) {
            if (!(obj instanceof DesignElementHandle)) continue;
            DesignElementHandle eleHandle = (DesignElementHandle)obj;
            list.add(eleHandle);
        }
        return list.toArray();
    }

    protected Object[] getChildrenByPropertyHandle(PropertyHandle slotHandle) {
        ArrayList<DesignElementHandle> list = new ArrayList<DesignElementHandle>();
        for (Object obj : slotHandle) {
            if (!(obj instanceof DesignElementHandle)) continue;
            DesignElementHandle eleHandle = (DesignElementHandle)obj;
            list.add(eleHandle);
        }
        return list.toArray();
    }

    @Override
    public boolean performRequest(Object model, Request request) throws Exception {
        if (request.getType().equals("insert")) {
            Map extendsData = request.getExtendedData();
            SlotHandle slotHandle = (SlotHandle)extendsData.get("insert-slot");
            if (slotHandle != null) {
                String type = (String)extendsData.get("insert-type");
                String position = (String)extendsData.get("insert-position");
                return this.performInsert(model, slotHandle, type, position, extendsData);
            }
            PropertyHandle propertyHandle = (PropertyHandle)extendsData.get("insert-property");
            if (propertyHandle != null) {
                String type = (String)extendsData.get("insert-type");
                String position = (String)extendsData.get("insert-position");
                return this.performInsert(model, propertyHandle, type, position, extendsData);
            }
        }
        if (request.getType().equals("edit")) {
            if (model instanceof ReportElementHandle) {
                return this.performEdit((ReportElementHandle)model);
            }
            if (model instanceof ElementDetailHandle) {
                return this.performEdit((ElementDetailHandle)model);
            }
            if (model instanceof ContentElementHandle) {
                return this.performEdit((ContentElementHandle)model);
            }
            if (model instanceof DesignElementHandle) {
                return this.performEdit((DesignElementHandle)model);
            }
        }
        if (request.getType().equals("delete")) {
            return false;
        }
        if (request.getType().equals("create-placeholder")) {
            return this.performCreatePlaceHolder((ReportElementHandle)model);
        }
        if (request.getType().equals("change-data-column")) {
            return this.performChangeDataColumn((ReportElementHandle)model);
        }
        if (request.getType().equals("transfer-placeholder")) {
            return this.performTransferPlaceHolder((TemplateElementHandle)model);
        }
        if (request.getType().equals("revert-to-reportitem")) {
            return this.performRevertToReportItem((DesignElementHandle)model);
        }
        if (request.getType().equals("revert-to-templateitem")) {
            return this.performRevertToTemplateItem((DesignElementHandle)model);
        }
        return false;
    }

    private boolean performRevertToTemplateItem(DesignElementHandle handle) {
        try {
            handle.revertToTemplate(ReportPlugin.getDefault().getCustomName("TemplateReportItem"));
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
        return true;
    }

    private boolean performTransferPlaceHolder(TemplateElementHandle handle) {
        DesignElementHandle copiedHandle = handle.copyDefaultElement().getHandle(SessionHandleAdapter.getInstance().getReportDesignHandle().getModule());
        try {
            ((TemplateReportItemHandle)handle).transformToReportItem((ReportItemHandle)copiedHandle);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
        return true;
    }

    private boolean performRevertToReportItem(DesignElementHandle handle) {
        try {
            handle.revertToReportItem();
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
        return true;
    }

    private boolean checkNameExist(DesignElementHandle handle, String name) {
        DesignElementHandle element = handle.getModuleHandle().findElement(name);
        return element != null;
    }

    private boolean performChangeDataColumn(ReportElementHandle handle) {
        if (!(handle instanceof DataItemHandle)) {
            return false;
        }
        handle.getModuleHandle().getCommandStack().startTrans(Messages.getString((String)"DefaultNodeProvider.stackMsg.changeBinding"));
        ColumnBindingDialog dialog = new ColumnBindingDialog((ReportItemHandle)((DataItemHandle)handle), UIUtil.getDefaultShell(), true);
        dialog.setGroupList(DEUtil.getGroups((DesignElementHandle)handle));
        if (dialog.open() == 0) {
            handle.getModuleHandle().getCommandStack().commit();
            return true;
        }
        handle.getModuleHandle().getCommandStack().rollbackAll();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean performCreatePlaceHolder(ReportElementHandle handle) {
        boolean bIsNameExist = false;
        TemplateElementHandle template = null;
        String name = ReportPlugin.getDefault().getCustomName("TemplateReportItem");
        if (name == null) {
            name = "";
        }
        String desc = "";
        try {
            do {
                TemplateReportItemPropertiesDialog dialog;
                if ((dialog = new TemplateReportItemPropertiesDialog(handle.getDefn().getDisplayName(), name, desc)).open() != 0) return false;
                name = dialog.getName().trim();
                desc = (String)dialog.getResult();
                bIsNameExist = this.checkNameExist((DesignElementHandle)handle, name);
                if (!bIsNameExist) {
                    template = handle.createTemplateElement(name);
                    template.setDescription(desc);
                    continue;
                }
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"performCreatePlaceHolder.errorMessage.title"), Messages.getString((String)"performCreatePlaceHolder.errorMessage.content"));
            } while (bIsNameExist);
            return true;
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
    }

    protected DesignElementHandle createElement(String type) throws Exception {
        return ElementProcessorFactory.createProcessor(type).createElement(null);
    }

    protected DesignElementHandle createElement(ElementDetailHandle slotHandle, String type) throws Exception {
        if (type == null) {
            List<IElementDefn> supportList = UIUtil.getUIElementSupportList(slotHandle);
            if (supportList.size() == 0) {
                ExceptionHandler.openMessageBox(WARNING_DIALOG_TITLE, WARNING_DIALOG_MESSAGE_EMPTY_LIST, 8);
                return null;
            }
            if (supportList.size() == 1) {
                type = supportList.get(0).getName();
            } else {
                NewSectionDialog dialog = new NewSectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), supportList);
                if (dialog.open() == 1) {
                    return null;
                }
                type = (String)dialog.getResult()[0];
            }
        }
        return this.createElement(type);
    }

    protected DesignElementHandle createElement(ElementDetailHandle slotHandle, String type, Map extendData) throws Exception {
        return this.createElement(slotHandle, type);
    }

    protected boolean performInsert(Object model, SlotHandle slotHandle, String type, String position, Map extendData) throws Exception {
        return this.performInsert(model, (ElementDetailHandle)slotHandle, type, position, extendData);
    }

    protected boolean performInsert(Object model, ElementDetailHandle slotHandle, String type, String position, Map extendData) throws Exception {
        if (type == null) {
            List<IElementDefn> supportList = UIUtil.getUIElementSupportList(slotHandle);
            if (supportList.size() == 0) {
                ExceptionHandler.openMessageBox(WARNING_DIALOG_TITLE, WARNING_DIALOG_MESSAGE_EMPTY_LIST, 8);
                return false;
            }
            if (supportList.size() == 1) {
                type = supportList.get(0).getName();
            } else {
                NewSectionDialog dialog = new NewSectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), supportList);
                if (dialog.open() == 1) {
                    return false;
                }
                type = (String)dialog.getResult()[0];
            }
        }
        PaletteEntryExtension[] entries = EditpartExtensionManager.getPaletteEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getItemName().equals(type)) {
                extendData.put("result", entries[i].executeCreate());
                return true;
            }
            ++i;
        }
        DesignElementHandle elementHandle = this.createElement(slotHandle, type, extendData);
        if (extendData != null) {
            extendData.put("result", elementHandle);
        }
        if (elementHandle == null) {
            return false;
        }
        if (position == "current") {
            if (slotHandle instanceof SlotHandle) {
                ((SlotHandle)slotHandle).add(elementHandle);
            } else if (slotHandle instanceof PropertyHandle) {
                ((PropertyHandle)slotHandle).add(elementHandle);
            }
        } else {
            int pos = DNDUtil.calculateNextPosition((Object)model, (int)DNDUtil.handleValidateTargetCanContain((Object)model, (Object)elementHandle, (boolean)true));
            if (pos > 0 && position.equals("above")) {
                --pos;
            }
            if (pos == -1) {
                if (slotHandle instanceof SlotHandle) {
                    ((SlotHandle)slotHandle).add(elementHandle);
                } else if (slotHandle instanceof PropertyHandle) {
                    ((PropertyHandle)slotHandle).add(elementHandle);
                }
            } else if (slotHandle instanceof SlotHandle) {
                ((SlotHandle)slotHandle).add(elementHandle, pos);
            } else if (slotHandle instanceof PropertyHandle) {
                ((PropertyHandle)slotHandle).add(elementHandle, pos);
            }
        }
        if (elementHandle instanceof ExtendedItemHandle && ElementProcessorFactory.createProcessor(elementHandle) != null && !ElementProcessorFactory.createProcessor(elementHandle).editElement(elementHandle)) {
            return false;
        }
        DEUtil.setDefaultTheme((DesignElementHandle)elementHandle);
        return true;
    }

    protected DesignElementHandle createElement(PropertyHandle propertyHandle, String type) throws Exception {
        return this.createElement(type);
    }

    protected boolean performInsert(Object model, PropertyHandle propertyHandle, String type, String position, Map extendData) throws Exception {
        DesignElementHandle elementHandle = this.createElement(propertyHandle, type);
        if (extendData != null) {
            extendData.put("result", elementHandle);
        }
        if (elementHandle == null) {
            return false;
        }
        if (position == "current") {
            propertyHandle.add(elementHandle);
        } else {
            int pos = DNDUtil.calculateNextPosition((Object)model, (int)DNDUtil.handleValidateTargetCanContain((Object)model, (Object)elementHandle, (boolean)true));
            if (pos > 0 && position.equals("above")) {
                --pos;
            }
            if (pos == -1) {
                propertyHandle.add(elementHandle);
            } else {
                propertyHandle.add(elementHandle, pos);
            }
        }
        DEUtil.setDefaultTheme((DesignElementHandle)elementHandle);
        return true;
    }

    protected boolean performEdit(ReportElementHandle handle) {
        return false;
    }

    protected boolean performEdit(ElementDetailHandle handle) {
        return false;
    }

    protected boolean performEdit(ContentElementHandle handle) {
        return false;
    }

    protected boolean performEdit(DesignElementHandle handle) {
        return false;
    }

    @Override
    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public void setSorter(Comparator<Object> comparator) {
        this.comparator = comparator;
    }

    @Override
    public boolean isReadOnly(Object model) {
        return false;
    }
}

